#include "ProcessTab.hh"
#include "Process.hh"
#include "Inittab.hh"
#include "Respawner.hh"

#include "bootstrap.hh"

void ProcessTab::respawn()
{
    for(my_respawners_type::iterator i = my_respawners.begin();
	i!=my_respawners.end();
	i++)
      {
	(*i).second->spawn();
      }
  
}


void ProcessTab::stop_all_services()
{
  for(my_respawners_type::iterator i = my_respawners.begin();
      i!=my_respawners.end();
      i++)
    delete (*i).second;
  my_respawners.clear();
  
  unsigned old_stopping=0;
  
  for(my_servicetab_type::reverse_iterator i=my_servicetab.rbegin();
      i!=my_servicetab.rend();
      i++)
    if(global_inittab.stop_service((*i).second))old_stopping++;

  const int timeout = 30;
  const int improvement = 15;
  int time_left = timeout;

  for(;;)
    {
    unsigned stopping=0;
    for(my_servicetab_type::iterator i=my_servicetab.begin();
	i!=my_servicetab.end();i++)
      if((*i).second->is_stopping())
	stopping++;

    if(!stopping)
      break;
    
    {
      PermitSignals ps;
      yield();
    }
    
    if(stopping==old_stopping){
      if(!--time_left){
	say(_("timed out waiting for services to stop"));
	break;
      }
      
    }
    else{
      time_left += improvement;
      old_stopping = stopping;
    }
  }      
}

void ProcessTab::wait()
{
  pid_t victim;
  int status;
  
  while((victim = waitpid(WAIT_ANY,&status,WNOHANG))){
    if(victim == -1)
      return;

    my_pidtab_type::iterator j = my_pidtab.find(victim);
    if(j==my_pidtab.end())continue;
    Process*process = (*j).second;
    if(!process)continue;
    if(process->died(status))
      delete process;
    else
      my_pidtab.erase(j);
  }
}

ProcessTab global_processtab;
