#ifndef PROCESS_HH
#define PROCESS_HH

#include <sys/types.h>
#include "ProcessTab.hh"

class Process 
{
  pid_t my_pid;
public:
  Process(pid_t pid):my_pid(pid)
  {
    global_processtab.add_process(pid,this);
  }
  pid_t get_pid() const
  {
    return my_pid;
  }
  
  virtual bool died(int status) = 0; /* return true if this PROCESS should be deleted */ 
  virtual ~Process() 
  {
    global_processtab.remove_process(get_pid(),this);
  }
}
;

#endif
