#ifndef PERMITSIGNALS_HH
#define PERMITSIGNALS_HH

#include <signal.h>

extern const int masked_signals[];

class PermitSignals 
{
  sigset_t my_old;
public:
  PermitSignals()
  {
    sigset_t ss;
    sigemptyset(&ss);
    for(const int*s=masked_signals;*s!=NSIG;s++)
      sigaddset(&ss,*s);
    sigprocmask(SIG_UNBLOCK,&ss,&my_old);
  }
  ~PermitSignals()
  {
    sigprocmask(SIG_SETMASK,&my_old,0);
  }
}
;

#endif
