#include <ctype.h>

#include "Inittab.hh"

static char*after_ws(char*line)
{
  while(*line && isspace(*line))line++;
  return line;
}
static bool split(char*line,char*&lhs,char*&rhs)
{
  char*end;
  char*sign;
  while(isspace(*line))line++;
  lhs = line;
  
  for(char*p=line;*p;p++){
    if(*p=='=')
      {
	sign = p;
	goto got_sign;
      }
    if(!isspace(*p))end = p;
  }
  return false; // terminated early
 got_sign:
  end[1] = 0;
  *sign = 0;
  char*q=sign+1;
  while(isspace(*q))
    q++;
  rhs = q;

  /* clip off whitespace at the end of the RHS */
  while(*q){
    if(!isspace(*q))end = q;
    q++;
  }
  end[1] = 0;
  
  return true;
}
      
void Inittab::read(const char*filename)
{
  int fd = open(filename,O_RDONLY,0);
  if(fd==-1){
    say(_("unable to open inittab \"%s\""),filename);
    return;
  }
  char*line;
  unsigned lineno=0;
  for(;simpleio::read_line(fd,line);xfree(line)){
    lineno++;
    bool do_export = false;
    for(char*p=line;*p;p++)
      if(*p=='#') {
	*p = 0;
	break;
      }
    char*first = after_ws(line);
    if(!*first)
      continue;
    if(!strncmp(first,"export",6)&&isspace(first[6])){
      first += 6;
      first = after_ws(first);
      if(!*first) {
	say(_("empty export in inittab"));
	continue;
      }
      do_export = true;
    }
    char*lhs,*rhs;
    if(!split(first,lhs,rhs)){
      say(_("bad inittab line"));
      continue;
    }
    set_var(lhs,rhs);
    if(do_export)
      set_envvar(lhs,rhs);
  }
  close(fd);
}

Inittab global_inittab;
