#!/bin/sh
#
#  initfunc.sh
#
#  $Id: initfunc.sh,v 1.1 1996/02/09 21:14:56 cg Exp $
#
#  (c)1996, Cees de Groot <C.deGroot@inter.nl.net>
#
#  Init functions, to be called by RC scripts. No error checking,
#  because this must go fast.
#

modlist=""
modcount=0
curmod=""
curdev=`tty`
errors=0

init_add_module () {
    #
    #  Add module <name> <desc> to the list of known modules.
    #
    module=$1
    shift
    modlist="$modlist $module"
    eval desc_$module=\"$1\"
    shift
    eval stat_$module=""
    modcount=`expr $modcount + 1`
}

init_list_modules () {
    #
    #  Make a dialog box of all modules.
    #
    text=""
    for i in $modlist
    do
      stat=`eval echo '$stat_'$i`
      desc=`eval echo '$desc_'$i`
      if [ -n "$text" ]
      then
        text="$text\n"
      fi
      if [ -z "$stat" ]
      then
        stat="    "
      fi
      text="$text[$stat] $desc"
    done
    dialog --backtitle "$init_title" --infobox "$text" `expr $modcount + 2` 76
}


init_start () {
    #
    #  Start work on a module
    #
    eval stat_$1=Busy
}

init_done () {
    #
    #  Done successfully with a module
    #
    eval stat_$1=-OK-
    rm /tmp/init.$1.out
}

init_error () {
    #
    #  An error status
    #
    eval stat_$1=FAIL
    errors=1
}

init_execute () {
    #
    #  Execute a module
    #
    init_start $1
    init_list_modules
    curmod=$1
    eval 'do_'$1 >&/tmp/init.$1.out
    if [ $? != 0 ]
    then
      init_error $1
    else
      init_done $1
    fi
    init_list_modules
}

init_go () {
   #
   #  Execute all modules
   #
   for i in $modlist
   do
     init_execute $i
   done
   dialog --clear
}

init_panic () {
  #
  #  Panic - start a login shell.
  #
  errors=1
  echo >$curdev
  echo >$curdev
  echo '*************************************************************' >$curdev
  echo "A serious problem occurred. The message was:" >$curdev
  echo >$curdev
  echo "  $*." >$curdev
  echo >$curdev
  echo "Please login as root, and correct this problem (or reboot)." >$curdev
  echo "More details may be found in the file /tmp/init.$curmod.out"  >$curdev
  /bin/login >&$curdev
  init_list_modules
}

