/* Parts are taken from /usr/src/linux/init/main.c
 *
 * Rest is from tino@augsburg.net
 *
 * It's really very simple.
 */
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include <fcntl.h>
#include <signal.h>
#include <unistd.h>

#include <sys/wait.h>

#define	VERSION	"VH1.31"
#define	PUTSTREAM 1

#ifndef	TIMEOUT
#define	TIMEOUT	60
#endif

#ifndef	TTY
#define	TTY	"/dev/tty1"
#endif

#ifndef	SHELL
#define	SHELL	"/bin/sh"
#endif

#ifndef	SASH
#define	SASH	"/boot/sash:/sbin/sash:/bin/sash:/etc/sash"
#endif

#ifndef	INIT
#define	INIT	"/bin/init:/sbin/init"
#endif

static void
put(const char *s)
{
  while (*s)
    {
      static int	in_line=0;
      int		i;

      for (i=0; s[i] && s[i]!='\n'; i++);
      if (i)
	{
	  if (!in_line)
	    write(PUTSTREAM, "failinit " VERSION ": ", sizeof "failinit " VERSION ": "-1);
	  in_line	= 1;
	  write(PUTSTREAM, s, i);
	  s	+= i;
	}
      if (*s=='\n')
	{
	  write(PUTSTREAM, "\r\n", 2);
	  in_line	= 0;
	  s++;
	}
    }
}

static void
puterror(const char *s)
{
  char	*e;

  e	= "unknown error";
  if (errno>=0 && errno<_sys_nerr)
    e	= _sys_errlist[errno];
  put(s);
  put(": ");
  put(e);
  put("\n");
}

static void
start(const char *shells, char * const *argv)
{
  char		name[100];
  const char	*ptr;

  for (ptr=shells;;)
    {
      int	i;

      for (i=0; i<sizeof name-1 && *ptr; i++)
	if ((name[i]= *ptr++)==':')
	  break;
      if (!i)
	break;
      name[i]	= 0;
      if (argv)
	execv(name, argv);
      else
	{
	  while (--i>=0 && name[i-1]!='/');
	  execl(name, name+i, NULL);
	}
    }
  puterror(shells);
}

static int
shell(const char *tty)
{
  if (tty)
    {
      close(0);
      close(1);
      close(2);
      setsid();
      if (open(tty,O_RDWR,0))
	{
	  puterror(tty);
	  exit(-2);
	}
      dup(0);
      dup(0);
    }
  start(SASH, NULL);
  start(SHELL, NULL);
  exit(-1);
}

/* We are an init process, so we must accept other childs,
 * too (fail shell may have reparentized processes).
 */
static void
waiter(int pid)
{
  do
    sync();
  while (wait(NULL)!=pid);
  sync();
}

static void
showargs(char **argv)
{
  if (argv[1])
    {
      int	i;

      put("\narguments passed to init:\n");
      for (i=1; argv[i]; i++)
	{
	  put("\t\'");
	  put(argv[i]);
	  put("\'\n");
	}
      put("\n");
    }
}

static void
alarmhand()
{
  signal(SIGALRM, alarmhand);
}

static void
fail_shell(char **argv, int off)
{
  static int	stop;	/* static because I may use setjmp() below	*/
  int		i;

  if ((stop=argv[off][4])!=0 && off>1 && !argv[off][5])
    {
      stop	= TIMEOUT;
      put("\nEOF=no shell; RETURN=fail shell; else background: ..");
      signal(SIGALRM, alarmhand);
      signal(SIGINT, SIG_IGN);
      for (;;)
	{
	  char	c, mu[]="\b\b..\a";

	  mu[2]	= '0'+stop/10;
	  mu[3]	= '0'+stop%10;
	  write(PUTSTREAM, mu, 5);
	  alarm(1);
	  i	= read(0, &c, 1);
	  alarm(0);
	  switch (i)
	    {
	    case -1:
	      if (stop--)
		continue;
	      stop	= 0;
	      write(PUTSTREAM, "\b\b--\n", 5);
	      break;

	    default:
	      stop	= 1;
	      if (c!=4)
		break;
	    case 0:
	      alarm(0);
	      write(PUTSTREAM, "\b\bEOF\n", 6);
	      return;
	    }
	  break;
	}
    }
  if (stop)
    showargs(argv);
  else
    put("\n");
  put("forking fail shell ");
  put(stop ? "to " TTY : "in background");
  put(" ...\n");
  if ((i=fork())==0)
    shell(stop ? TTY : NULL);
  if (stop && i>=0)
    {
      waiter(i);
      put("\nfail shell terminated, proceeding with normal startup ...\n");
    }
}

static void
emergency_shell(void)
{
  int	i, fail;

  put("\ninit not found ... spawning emergency shell (like traditional kernels)\n");
  fail	= 0;
  for (;;)
    if ((i=fork())==0)
      shell(TTY);
    else if (i<0)
      {
	if (!fail)
	  put("cannot fork() !!! sleeping ...\n");
	fail	= 1;
	sleep(1);
      }
    else
      {
	if (fail)
	  put("OK, fork() is back again\n");
	fail	= 0;
	waiter(i);
	put("emergency shell terminated.\n");
	sleep(1);
      }
}

int
main(int argc, char **argv)
{
  int	i;

  i	= 0;
  while ((argv[++i] && !strncmp(argv[i], "auto", 5))
	 );
  if (argv[i] && !strncmp(argv[i], "fail", 4))
    {
      fail_shell(argv, i);
      while ((argv[i]=argv[i+1])!=0)
	i++;
    }
  showargs(argv);
  start(INIT, argv);
  emergency_shell();
  return -1;
}
