// dialmonDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dialmon.h"
#include "dialDlg.h"
#include "dialConf.h"

#ifdef	WIN32
#define WM_TRAY_NOTIFY		WM_USER+0
#define	LDBLCLICK_TIMER		1
#endif	/* WIN32 */

#define	DIALMON_CONNECT_TIMER	2
#define	DIALMON_CONNTIME_TIMER	3

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern	void	dialmonStartComms () ;
extern	void	dialmonStopComms  () ;
extern	void	dialmonWriteCmd	  (char *) ;                   

extern	int	startmin	;
extern	int	startatx	;
extern	int	startaty	;
extern	int	lock		;
extern	int	nologin		;
extern	int	savepwd		;
extern	char	host   []	;
extern	char	port   []	;
extern	char	user   []	;
extern	char	pass   []	;
extern	char	dialmon[]	;
extern	char	dialini[]	;
extern	char	logfmt []	;
extern	int	gotconn		;
extern	int	loadint		;
extern	long	histBack	;
extern	long	histFore	;
#ifdef	WIN32
extern  int	hideicon    	;
#endif	/* WIN32 */


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT

}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDialmonDlg dialog

CDialmonDlg *dialmonDlg ;

/*  CDialmonDlg								*/
/*  CDialmonDlg	: Constructor for dialmon information dialog window	*/
/*  pParent	: Parent window if any					*/
/*  (returns)	: CDialmonDlg	:					*/

CDialmonDlg::CDialmonDlg
	(	CWnd*	pParent
	)
	:
	CDialog	(CDialmonDlg::IDD, pParent)
#ifdef	WIN32
	, trayIcon (IDI_OFFLINE)
#endif	/* WIN32 */
{
	//{{AFX_DATA_INIT(CDialmonDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	dialmonDlg = this ; 
}

/*  CDialmonDlg								*/
/*  ~CDialmonDlg: Destructor for dialmon information dialog window	*/
/*  (returns)	:		:					*/

CDialmonDlg::~CDialmonDlg ()
{
	wUpFor.Detach () ;
	wTxBar.Detach () ;
	wRxBar.Detach () ;
	delete penFore	 ;
	delete penBack	 ;
	delete brushFore ;
	delete brushBack ;
}

void CDialmonDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDialmonDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDialmonDlg, CDialog)
	//{{AFX_MSG_MAP(CDialmonDlg)
	ON_WM_QUERYDRAGICON()
	ON_WM_SYSCOMMAND   ()
	ON_WM_PAINT	   ()
	ON_BN_CLICKED	   (IDC_CONFIG,     OnConfig)
	ON_BN_CLICKED	   (IDC_UP,	    OnUp)                
	ON_BN_CLICKED	   (IDC_DOWN,	    OnDown)
	ON_BN_CLICKED	   (IDC_FORCE,	    OnForce)
	ON_BN_CLICKED	   (IDC_NORMAL,	    OnNormal)
	ON_BN_CLICKED	   (IDC_BLOCK,	    OnBlock)
	ON_BN_CLICKED	   (IDC_RESTART,    OnRestart)
	ON_WM_MOVE	   ()
	ON_WM_SIZE	   ()
	ON_WM_TIMER	   ()
	ON_WM_CTLCOLOR	   ()
#ifdef	WIN32
	ON_BN_CLICKED	   (IDC_QUEUE,	    OnQueue	)
	ON_BN_CLICKED	   (IDC_LOG,	    OnLog	)
	ON_BN_CLICKED	   (IDC_LOG_RELOAD, OnLogReload	)
	ON_MESSAGE	   (WM_TRAY_NOTIFY, OnTrayNotify)
	ON_COMMAND	   (IDM_UP,	    OnUp	)
	ON_COMMAND	   (IDM_DOWN,	    OnDown	)
	ON_COMMAND	   (IDM_RESTART,    OnRestart	)
	ON_COMMAND	   (IDM_CONNECT,    OnConnect   )
	ON_COMMAND	   (IDM_HELP,	    OnHelp      )
	ON_COMMAND	   (IDM_ABOUT,	    OnAbout     )
	ON_COMMAND	   (IDM_RESTORE,    OnRestore	)
	ON_COMMAND	   (IDM_EXIT,	    OnCancel	)
#endif	/* WIN32 */
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDialmonDlg message handlers

BOOL CDialmonDlg::OnInitDialog()
{
	BOOL	confRc	;

	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUT & 0xFFF0) == IDM_ABOUT);
	ASSERT (IDM_ABOUT < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);

	strAboutMenu.LoadString(IDS_ABOUTBOX	   ) ;
	strLinkUp   .LoadString(IDS_STRING_UPLINK  ) ;
	strLinkDown .LoadString(IDS_STRING_DOWNLINK) ;
	strConfig   .LoadString(IDS_STRING_CONFIG  ) ;      
	strConnect  .LoadString(IDS_STRING_CONNECT ) ;
	strHelp     .LoadString(IDS_STRING_HELP    ) ;

	pSysMenu->AppendMenu(MF_SEPARATOR);
	if (!strAboutMenu.IsEmpty())
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUT, strAboutMenu);
	if (!strHelp     .IsEmpty())
		pSysMenu->AppendMenu(MF_STRING, IDM_HELP,  strHelp     );

	if (!strLinkUp.IsEmpty() && !strLinkDown.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_UP,   strLinkUp  ) ;
		pSysMenu->AppendMenu(MF_STRING, IDM_DOWN, strLinkDown) ;
	}                                            

	confRc	= dialmonConfInit () ;

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
#ifdef	WIN32
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
#endif	/* WIN32 */



	penBack   = new CPen   (PS_SOLID, 1, histBack) ;
	penFore   = new CPen   (PS_SOLID, 1, histFore) ;
	brushBack = new CBrush (histBack) ;
	brushFore = new CBrush (histFore) ;


	((CButton *)GetDlgItem (IDC_CONFIG))->SetWindowText (lock ? strConnect : strConfig) ;
	if (!strConfig.IsEmpty() && !strConnect.IsEmpty())
	{	pSysMenu->AppendMenu (MF_STRING,  IDM_CONFIG, "") ;
		pSysMenu->ModifyMenu (IDM_CONFIG, MF_BYCOMMAND, IDM_CONFIG, lock ? strConnect : strConfig) ;
	}

	SetWindowPos (&wndTop, startatx, startaty, -1, -1, SWP_NOSIZE) ;        
	ShowWindow   (startmin ? SW_MINIMIZE : SW_RESTORE) ;

#ifdef	WIN32
	if (hideicon && startmin)
		PostMessage (WM_SIZE, SIZE_MINIMIZED, 0) ;

	trayIcon.SetNotificationWnd (this, WM_TRAY_NOTIFY) ;
	trayIcon.SetIcon	    (IDI_OFFLINE) ;


	/* Initialise the columns of the queue list box, and adjust the	*/
	/* window size so that it is initially hidden.			*/
	CListCtrl *pq = (CListCtrl *)GetDlgItem(IDC_PKT_QUEUE) ;
	pq->InsertColumn (0, "Proto",    LVCFMT_LEFT,   46) ;
	pq->InsertColumn (1, "Srce",     LVCFMT_LEFT,  172) ;
	pq->InsertColumn (2, "Dest",     LVCFMT_LEFT,  172) ;
	pq->InsertColumn (3, "TTL",      LVCFMT_LEFT,   60) ;

	CListCtrl *cl = (CListCtrl *)GetDlgItem(IDC_CONNECT_LOG) ;
	cl->InsertColumn (0, "Time",     LVCFMT_LEFT,  120) ;
	cl->InsertColumn (1, "Duration", LVCFMT_LEFT,   98) ;
	cl->InsertColumn (2, "Config",   LVCFMT_LEFT,  100) ;
	cl->InsertColumn (3, "Transmit", LVCFMT_RIGHT,  66) ;
	cl->InsertColumn (4, "Receive",  LVCFMT_RIGHT,  66) ;

	WINDOWPLACEMENT		dp    ;
	WINDOWPLACEMENT		qp    ;
	GetWindowPlacement 	(&dp) ;
	pq->GetWindowPlacement	(&qp) ;

	
	maxht	= dp.rcNormalPosition.bottom - dp.rcNormalPosition.top  ;
	minht	= qp.rcNormalPosition.top    + GetSystemMetrics (SM_CYCAPTION) ;
	width	= dp.rcNormalPosition.right  - dp.rcNormalPosition.left ;
	showq	= 0 ;
	showl	= 0 ;

	dp.rcNormalPosition.bottom = dp.rcNormalPosition.top + minht ;
	SetWindowPlacement (&dp) ;
#endif	/* WIN32 */

	/* Attach the up time field and transmit and receive bars to a	*/
	/* pair of CWnd's so that we do not have to locate them every	*/
	/* time we need to update them. Set the bandwidth to the	*/
	/* default in case the dialmon daemon does not tell us		*/
	/* (paranoia rules) and clear the current values.		*/
	wUpFor.Attach (GetDlgItem (IDC_UPFOR) -> m_hWnd) ;
	wTxBar.Attach (GetDlgItem (IDC_TXBAR) -> m_hWnd) ;
	wRxBar.Attach (GetDlgItem (IDC_RXBAR) -> m_hWnd) ;
	bwidth	  = DEFBWIDTH ;

	wTxBar.GetClientRect (&txrxRect)     ;
	txvals	  = new int [txrxRect.right + 1] ;
	rxvals	  = new int [txrxRect.right + 1] ;

	connected = UNKNOWN   ;		/* Initial state unknown	*/
	conntime  = 0	      ;		/* No connected-at time		*/
	modeico	  = -1	      ;		/* Unknown mode icon		*/

	if (confRc)
	{
		if ((host[0] != 0) && (port[0] != 0))
		{	if (nologin || ((user[0] != 0) && (pass[0] != 0)))
				dialmonStartComms () ;
			else	OnConfig () ;
		}
		else	OnConfig () ;
	}
	else	OnConfig () ;  

	/* Check every 15 seconds in case we have lost the connection	*/
	/* to the dialmon daemon, in which case we try to reconnect.	*/
	SetTimer (DIALMON_CONNECT_TIMER, 15 * 1000, NULL) ;

	return TRUE ;
}

/*  CDialmonDlg								*/
/*  OnHelp	: Handle help request					*/
/*  (returns)	: void							*/

void	CDialmonDlg::OnHelp ()
{
	::WinHelp (m_hWnd, "dialmon.hlp",  HELP_CONTENTS, 0) ;
}

/*  CDialmonDlg								*/
/*  OnAbout	: Handle about request					*/
/*  (returns)	: void							*/

void	CDialmonDlg::OnAbout ()
{
	CAboutDlg dlgAbout;
	dlgAbout.DoModal();
}

/*  CDialmonDlg								*/
/*  OnSysCommand: Handle system menu command				*/
/*  (returns)	: void		:					*/

void	CDialmonDlg::OnSysCommand
	(	UINT	nID,
		LPARAM	lParam
	)
{                                              
	switch (nID & 0xfff0)
	{
		case IDM_CONFIG  :
			OnConfig  () ;
			break	;

		case IDM_ABOUT  :
			OnAbout   () ;
			break	;

		case IDM_HELP	:
			OnHelp    () ;
			break	;

		case IDM_UP	:
			OnUp      () ;
			break	;

		case IDM_DOWN	:
			OnDown    () ;
			break	;

		case IDM_RESTART:
			OnRestart () ;

		default	:
			CDialog::OnSysCommand(nID, lParam);
			break	;
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDialmonDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();

		if (loadint == 0)
		{	DrawBar  (wTxBar, txtotal) ;
			DrawBar  (wRxBar, rxtotal) ;
		}
		else
		{	DrawBar  (wTxBar, txvals ) ;
			DrawBar  (wRxBar, rxvals ) ;
		}
	}
}                                          

void	CDialmonDlg::OnMove
	(	int	x,
		int	y
	)
{
	if (!IsIconic())
	{	RECT	rect	;
		GetWindowRect (&rect) ;
		startatx = rect.left  ;
		startaty = rect.top   ;
	}
}

/*  CDialmonDlg								*/
/*  OnExit	: Gateway to keep OnCancel() protected and MFC happy	*/
/*  (returns)	: void		:					*/

void	CDialmonDlg::doExit ()
{
#ifdef	WIN32
	KillTimer (LDBLCLICK_TIMER) ;
#endif	/* WIN32 */
	KillTimer (DIALMON_CONNECT_TIMER) ;
	OnCancel  () ;
}

void	CDialmonDlg::OnCancel ()
{
	char b[16] ;
	
	dialmonStopComms  () ;

	sprintf (b, "%d", startatx) ;
	WritePrivateProfileString ("dialmon", "startatx", b, "dialmon.ini") ;
	sprintf (b, "%d", startaty) ;
	WritePrivateProfileString ("dialmon", "startaty", b, "dialmon.ini") ;
#ifdef	WIN32
	trayIcon.SetIcon (0) ;
#endif	/* WIN32 */
	CDialog::OnCancel () ;
}

#ifdef	WIN32
void	CDialmonDlg::OnRestore ()
{
	ShowWindow (SW_RESTORE) ;
}

void	CDialmonDlg::OnQueue ()
{
	RECT	dRect	;
	GetWindowRect (&dRect) ;

	GetDlgItem (IDC_PKT_QUEUE  ) -> ShowWindow (SW_SHOW) ;
	GetDlgItem (IDC_LABEL_Q_A  ) -> ShowWindow (SW_SHOW) ;
	GetDlgItem (IDC_LABEL_Q_B  ) -> ShowWindow (SW_SHOW) ;
	GetDlgItem (IDC_LABEL_Q_C  ) -> ShowWindow (SW_SHOW) ;
	GetDlgItem (IDC_INTERFACE  ) -> ShowWindow (SW_SHOW) ;
	GetDlgItem (IDC_LOCAL      ) -> ShowWindow (SW_SHOW) ;
	GetDlgItem (IDC_REMOTE     ) -> ShowWindow (SW_SHOW) ;
	GetDlgItem (IDC_CONNECT_LOG) -> ShowWindow (SW_HIDE) ;
	GetDlgItem (IDC_LOG_RELOAD ) -> ShowWindow (SW_HIDE) ;

	if (showq)
	{	MoveWindow (dRect.left, dRect.top, width, minht) ;
		showq = 0 ;
	}
	else
	{	MoveWindow (dRect.left, dRect.top, width, maxht) ;
		showq = 1 ;
		showl = 0 ;
	}
}

void	CDialmonDlg::OnLog ()
{
	RECT	dRect	;
	GetWindowRect (&dRect) ;

	GetDlgItem (IDC_PKT_QUEUE  ) -> ShowWindow (SW_HIDE) ;
	GetDlgItem (IDC_LABEL_Q_A  ) -> ShowWindow (SW_HIDE) ;
	GetDlgItem (IDC_LABEL_Q_B  ) -> ShowWindow (SW_HIDE) ;
	GetDlgItem (IDC_LABEL_Q_C  ) -> ShowWindow (SW_HIDE) ;
	GetDlgItem (IDC_INTERFACE  ) -> ShowWindow (SW_HIDE) ;
	GetDlgItem (IDC_LOCAL      ) -> ShowWindow (SW_HIDE) ;
	GetDlgItem (IDC_REMOTE     ) -> ShowWindow (SW_HIDE) ;
	GetDlgItem (IDC_CONNECT_LOG) -> ShowWindow (SW_SHOW) ;
	GetDlgItem (IDC_LOG_RELOAD ) -> ShowWindow (SW_SHOW) ;

	if (showl)
	{	MoveWindow (dRect.left, dRect.top, width, minht) ;
		showl = 0 ;
	}
	else
	{	MoveWindow (dRect.left, dRect.top, width, maxht) ;
		showl = 1 ;
		showq = 0 ;
		dialmonWriteCmd ("I\n") ;
	}
}

void	CDialmonDlg::OnLogReload ()
{
	dialmonWriteCmd ("I\n") ;
}
#endif	/* WIN32 */

/*  CDialmonDlg	:							*/
/*  SetState	: Set state from diald state message			*/
/*  state	: char *	: Message from diald			*/
/*  (returns)	: void							*/

// Added system tray support, steve@blighty.com 14/5/97

void	CDialmonDlg::SetState
	(	char	*state
	)
{
#ifdef	WIN32
#define	SMAP(s,t,c,i)	{ s, t, c, i }
#else	/* WIN32 */
#define	SMAP(s,t,c,i)	{ s, t, c }
#endif	/* WIN32 */

	/* The smap array is used to map the text of state messages to	*/
	/* something a bit more informative, plus the (dis)connected	*/
	/* state and, for WIN32, an icon for the system tray.		*/
	typedef	struct
	{	char	*state		;
		char	*text		;
		int	connected	;
		UINT	icon		;
	}	SMap	;

	static	SMap	smap[] =
	{
		/* The first block of STATE messages are actually	*/
		/* derived from diald itself.				*/
		SMAP	( "START_LINK",	"Starting PPP",	DISCONNECTED,	IDI_DIALING   ),
		SMAP	( "UP",		"Connected",	CONNECTED,	IDI_ONLINE    ),
		SMAP	( "STOP_LINK",	"Stopping PPP", DISCONNECTED,	IDI_OFFLINE   ),
		SMAP	( "DISCONNECT",	"Disconnecting",DISCONNECTED,	IDI_OFFLINE   ),
		SMAP	( "CLOSE",	"Closed",	DISCONNECTED,	IDI_OFFLINE   ),
		SMAP	( "DOWN",	"Down",		DISCONNECTED,	IDI_OFFLINE   ),
		SMAP	( "CONNECT",	"Connecting",	DISCONNECTED,	IDI_DIALING   ),

		/* The second block of STATE messages arrise from	*/
		/* dialmon rather than diald.				*/
		SMAP	( "IDLE",	"Idle",		DISCONNECTED,	IDI_OFFLINE   ),

		SMAP	( NULL,		NULL,		0,		0	      )
	}	;
                   
	char	b[64] 	;
	UINT	icon	= 0 ;
	SMap	*smapp	;

	for (smapp = &smap[0] ; smapp->state != NULL ; smapp += 1)
		if (strcmp (state, smapp->state) == 0)
			break	;
#ifdef	WIN32
	if (!gotconn)
		trayIcon.SetIcon (IDI_UNKNOWN) ;
#endif	/* WIN32 */

	/* Assuming the state was found, note the corresponding state	*/
	/* text and connected state. Also, start a timer running when	*/
	/* the link comes up, and note the time at which connection	*/
	/* occured; this is used for the connection time display.	*/
	if (smapp->state != NULL)
	{
		state	  = smapp->text	       ;
		connected = smapp->connected   ;

		switch (connected)
		{
			case CONNECTED    :
				SetTimer  (DIALMON_CONNTIME_TIMER, 1000, NULL) ;
				conntime  = time (NULL) ;
				loadidx	  = loadint	;
				break	  ;

			default	:
				KillTimer (DIALMON_CONNTIME_TIMER) ;
				conntime  = 0 ;
//				wUpFor.SetWindowText ("") ;

				break	  ;
		}
#ifdef	WIN32
		trayIcon.SetIcon (smapp->icon) ;
#endif	/* WIN32 */
	}

	sprintf	      (b, "DialMon: %s", state) ;
	SetWindowText (b) ;
	((CStatic *)GetDlgItem(IDC_STATE))->SetWindowText (state) ;

	memset	(txvals, 0, txrxRect.right * sizeof(int)) ;
	memset	(rxvals, 0, txrxRect.right * sizeof(int)) ;
	DrawBar	(wTxBar, txvals) ;
	DrawBar	(wRxBar, txvals) ;

	txtotal	= 0 ;
	rxtotal	= 0 ;
	loadidx	= loadint ;
}

HBRUSH	CDialmonDlg::OnCtlColor
	(	CDC	*pDC,
		CWnd	*pWnd,
		UINT	nCtlColor
	)
{
	HBRUSH	res	= CDialog::OnCtlColor (pDC, pWnd, nCtlColor) ;

	switch (pWnd->GetDlgCtrlID())
	{
		case IDC_UPFOR	:
			pDC->SetTextColor (rgb_upfor) ;
			break	;

		default	:
			break	;
	}

	return	res	;
}

/*  CDialmonDlg								*/
/*  SetMode	: Set current mode					*/
/*  mode	: char *	: Current mode				*/
/*  (returns)	: void		:					*/

void	CDialmonDlg::SetMode
	(	char	*mode
	)
{

	if	(strcmp (mode, "FORCE" ) == 0) modeico = IDI_FORCE   ;
	else if (strcmp (mode, "NORMAL") == 0) modeico = IDI_NORMAL  ;
	else if (strcmp (mode, "BLOCK" ) == 0) modeico = IDI_BLOCK   ;
	else	return ;

	HICON hIcon = LoadIcon (AfxGetInstanceHandle (), MAKEINTRESOURCE(modeico)) ;
	((CStatic *)GetDlgItem(IDC_MODE))->SetIcon (hIcon) ;
}

/*  CDialmonDlg								*/
/*  SetIface	: Set current interface					*/
/*  iface	: char *	: Current interface			*/
/*  (returns)	: void		:					*/

void	CDialmonDlg::SetIface
	(	char	*iface
	)
{
#ifdef	_WIN32
	CStatic	*ifw	= (CStatic *)GetDlgItem(IDC_INTERFACE) ;
	CStatic	*locw	= (CStatic *)GetDlgItem(IDC_LOCAL    ) ;
	CStatic	*remw	= (CStatic *)GetDlgItem(IDC_REMOTE   ) ;

	char	*ift	= strtok (iface, " \t\n") ;
	char	*loct	= strtok (NULL,  " \t\n") ;
	char	*remt	= strtok (NULL,  " \t\n") ;

	ifw ->SetWindowText (ift  == NULL ? "" : ift ) ;
	locw->SetWindowText (loct == NULL ? "" : loct) ;
	remw->SetWindowText (remt == NULL ? "" : remt) ;
#endif
}

/*  CDialmonDlg								*/
/*  DrawBar	: Draw a bandwidth bar					*/
/*  wnd		: CWnd &	: Window to redraw			*/
/*  vals	: int *		: Values				*/
/*  (returns)	: void		:					*/

void	CDialmonDlg::DrawBar
	(	CWnd	&wnd,
		int	*vals
	)
{
	CDC	*pDC	= wnd.GetDC() ;

	for (int idx = 0 ; idx < txrxRect.right ; idx += 1)
	{
		int	value	= vals[idx] ;

		pDC->MoveTo	  (idx, txrxRect.bottom	       ) ;
		pDC->SelectObject (penFore)  ;
		pDC->LineTo	  (idx, txrxRect.bottom - value) ;
		pDC->SelectObject (penBack)  ;
		pDC->LineTo	  (idx,   0) ;

	}

	ReleaseDC (pDC) ;
}

/*  CDialmonDlg								*/
/*  DrawBar	: Draw a bandwidth bar					*/
/*  wnd		: CWnd &	: Window to redraw			*/
/*  val		: int		: Value					*/
/*  (returns)	: void		:					*/

void	CDialmonDlg::DrawBar
	(	CWnd	&wnd,
		int	val
	)
{
	CDC	*pDC	= wnd.GetDC() ;
	RECT	rect	;

	rect	    = txrxRect ;
	rect.bottom = rect.bottom + 1    ;
	rect.top    = rect.bottom - val	 ;
	pDC->FillRect (&rect, brushFore) ;

	rect	    = txrxRect ;
	rect.bottom = rect.bottom - val  ;
	pDC->FillRect (&rect, brushBack) ;

	ReleaseDC (pDC) ;
}

/*  CDialmonDlg	:							*/
/*  SetLoad	: Process diald load message				*/
/*  pszLoad	: char *	: Load message				*/
/*  (returns	: void		:					*/

void	CDialmonDlg::SetLoad
	(	char	*pszLoad
	)
{
	int	i	;
	long	txrx[4]	;
	UINT	icon	= IDI_ONLINE ;
	char	*token	;

	static	const	char	delim[] = " \t" ;

	if (connected != CONNECTED)
		return	;

	/* Parse the load string. There should be four values, the	*/
	/* transmit and receive counts in the last second, and for the	*/
	/* entire connection.						*/
	token	= strtok (pszLoad, delim) ;

	for (i = 0 ; i < sizeof(txrx)/sizeof(txrx[0]) ; i += 1)
		if (token != NULL)
		{	txrx[i] = atol   (token) ;
			token	= strtok (NULL, delim) ;
		}
		else	txrx[i]	= 0 ;

#ifdef	WIN32
	/* Decide what icon should be used for the system tray and set	*/
	/* it and the tip text.						*/
	if	((txrx[0] > 0) && (txrx[1] > 0)) icon = IDI_XMITRECV ;
	else if ( txrx[0] > 0		       ) icon = IDI_XMIT     ;
	else if ( txrx[1] > 0		       ) icon = IDI_RECV     ;

	char	tip[80]	;
	sprintf	(tip, "Connected: xmit %ld, recv %ld",
		      (txrx[2] + 512L) / 1024L,
		      (txrx[3] + 512L) / 1024L) ;
	trayIcon.SetIcon (icon, tip) ;
#endif	/* WIN32 */


	txtotal	+= txrx[0] ;
	rxtotal	+= txrx[1] ;

	if (loadint == 0)
	{
		txtotal = (((long)txrxRect.bottom * txtotal) / bwidth) ;
		rxtotal	= (((long)txrxRect.bottom * rxtotal) / bwidth) ; 
		if (txtotal > txrxRect.bottom) txtotal = txrxRect.bottom ;
		if (rxtotal > txrxRect.bottom) rxtotal = txrxRect.bottom ;
		DrawBar	(wTxBar, txtotal) ;
		DrawBar	(wRxBar, rxtotal) ;
		txtotal	= 0		 ;
		rxtotal	= 0		 ;
	}
	else if ((loadidx -= 1) <= 0)
	{
		txtotal = (((long)txrxRect.bottom * txtotal) / (bwidth * loadint)) ;
		rxtotal	= (((long)txrxRect.bottom * rxtotal) / (bwidth * loadint)) ;
		if (txtotal > txrxRect.bottom) txtotal = txrxRect.bottom ;
		if (rxtotal > txrxRect.bottom) rxtotal = txrxRect.bottom ;
		memcpy	(&txvals[0], &txvals[1], (txrxRect.right - 1) * sizeof(int)) ;
		memcpy	(&rxvals[0], &rxvals[1], (txrxRect.right - 1) * sizeof(int)) ;
		txvals[txrxRect.right - 1] = txtotal ;
		rxvals[txrxRect.right - 1] = rxtotal ;
		DrawBar	(wTxBar, txvals) ;
		DrawBar	(wRxBar, rxvals) ;
		txtotal	= 0		 ;
		rxtotal	= 0		 ;
		loadidx	= loadint	 ;
	}
}

/*  CDialmonDlg								*/
/*  Queue	: Handle packet queue message				*/
/*  (returns)	: void		:					*/

void	CDialmonDlg::Queue
	(	char	*qmsg
	)
{
#ifdef	WIN32
	CListCtrl *ql = (CListCtrl *)GetDlgItem(IDC_PKT_QUEUE) ;
	char	  *p  ;

	if (strncmp (qmsg, "START", 5) == 0)
	{	qidx	= 0 ;
		return	;
	}
	if (strncmp (qmsg, "END",   3) == 0)
	{	while (ql->DeleteItem (qidx)) ;
		return ;
	}

	ql->DeleteItem (qidx) ;

	if ((p = strtok (qmsg, "|")) == NULL) return ;
	ql->InsertItem  (qidx,    (LPCTSTR)p) ;
	if ((p = strtok (NULL, "|")) == NULL) return ;
	ql->SetItemText (qidx, 1, (LPCTSTR)p) ;
	if ((p = strtok (NULL, "|")) == NULL) return ;
	ql->SetItemText (qidx, 2, (LPCTSTR)p) ;
	if ((p = strtok (NULL, "|")) == NULL) return ;
	ql->SetItemText (qidx, 3, (LPCTSTR)p) ;

	qidx	+= 1 ;
#endif	/* WIN32 */
}

/*  CDialmonDlg								*/
/*  Logging	: Handle logging message				*/
/*  (returns)	: void		:					*/

void	CDialmonDlg::Logging
	(	char	*qmsg
	)
{
#ifdef	WIN32
	CListCtrl *ll   = (CListCtrl *)GetDlgItem(IDC_CONNECT_LOG) ;
	char	  *p1   ;
	char	  *p2   ;
	char	  *p3   ;
	char	  *p4   ;
	char	  *p5   ;
	long	  tval	;
	char	  t[80] ;
	struct tm *tm	;

	if (strncmp (qmsg, "START", 5) == 0)
	{	lidx	= 0 ;
		return	;
	}
	if (strncmp (qmsg, "END",   3) == 0)
	{	while (ll->DeleteItem (lidx)) ;
		return ;
	}

	ll->DeleteItem (lidx) ;

	if ((p1 = strtok (qmsg, "|")) == NULL) return ;
	if ((p2 = strtok (NULL, "|")) == NULL) return ;
	if ((p3 = strtok (NULL, "|")) == NULL) return ;
	if ((p4 = strtok (NULL, "|")) == NULL) return ;
	if ((p5 = strtok (NULL, "|")) == NULL) return ;

	tval = atol (p1)         ;
	tm   = localtime (&tval) ;
	strftime (t, sizeof(t), logfmt, tm) ;
	ll->InsertItem  (lidx,    (LPCTSTR)t ) ;

	/* A duration value of -1 is used to mark a restart, in which	*/
	/* case the receive and transmit counts are meaningless and are	*/
	/* set to be blank on the display.				*/
	if (strcmp (p2, "-1") == 0)
	{	strcpy	(t, "Switch") ;
		p4 = ""	      ;
		p5 = ""	      ;
	}
	else
	{
		tval = atol (p2) ;
		sprintf	 (t, "%2d:%02d:%02d",
				(tval / 3600), (tval % 3600) / 60, tval %60) ;
	}

	ll->SetItemText (lidx, 1, (LPCTSTR)t ) ;

	ll->SetItemText (lidx, 2, (LPCTSTR)p3) ;
	ll->SetItemText (lidx, 3, (LPCTSTR)p4) ;
	ll->SetItemText (lidx, 4, (LPCTSTR)p5) ;

	lidx	+= 1 ;
#endif	/* WIN32 */
}

/*  CDialmonDlg	:							*/
/*  SetMessage	: Set message from diald message			*/
/*  message	: char *	: Message from diald			*/
/*  hilite	: BOOL		: Highlight text			*/
/*  (returns)	: void							*/

void	CDialmonDlg::SetMessage
	(	char	*message,
		BOOL	hilite
	)
{
	CStatic	*field	;

	if (message[0] == '!')
	{	field	= (CStatic *)&wUpFor ;
		message	= &message[1] ;
	}
	else	field	= ((CStatic *)GetDlgItem(IDC_MESSAGE)) ;

	rgb_upfor = hilite ? RGB(255,0,0) : RGB(0,0,0) ;
	field->SetWindowText (message) ;
}
         
/*  CDialMonDlg	:							*/
/*  AllowDown	: Enable or disable down control			*/
/*  allow	: int		: Non-zero to allow			*/
/*  (returns)	: void		:					*/
         
void	CDialmonDlg::AllowDown
	(	int	allow
	)
{
	((CButton *)GetDlgItem (IDC_DOWN   ))->EnableWindow (allow) ;
}
	
/*  CDialMonDlg	:							*/
/*  AllowUp	: Enable or disable down control			*/
/*  allow	: int		: Non-zero to allow			*/
/*  (returns)	: void		:					*/
         
void	CDialmonDlg::AllowUp
	(	int	allow
	)
{
	((CButton *)GetDlgItem (IDC_UP     ))->EnableWindow (allow) ;
}
	

/*  CDialMonDlg	:							*/
/*  AllowSet	: Enable or disable state setting			*/
/*  allow	: int		: Non-zero to allow			*/
/*  (returns)	: void		:					*/
         
void	CDialmonDlg::AllowSet
	(	int	allow
	)
{
	((CButton *)GetDlgItem (IDC_FORCE ))->EnableWindow (allow) ;
	((CButton *)GetDlgItem (IDC_NORMAL))->EnableWindow (allow) ;
	((CButton *)GetDlgItem (IDC_BLOCK ))->EnableWindow (allow) ;
}
	

/*  CDialMonDlg	:							*/
/*  AllowCtrl	: Enable or disable diald control			*/
/*  allow	: int		: Non-zero to allow			*/
/*  (returns)	: void		:					*/
         
void	CDialmonDlg::AllowCtrl
	(	int	allow
	)
{
	((CButton *)GetDlgItem (IDC_RESTART))->EnableWindow (allow) ;
}

/*  CDialMonDlg	:							*/
/*  AddConfig	: Add a configuration name				*/
/*  name	: char *	: Configuration name			*/
/*  (returns)	: void		:					*/

void	CDialmonDlg::AddConfig
	(	char	*name
	)
{
	CComboBox *cb = (CComboBox *)GetDlgItem(IDC_CONFIGS) ;
	cb->ShowWindow (SW_SHOW) ;
	cb->AddString  (name) ;
}

/*  CDialMonDlg	:							*/
/*  SetConfig	: Set current configuration name			*/
/*  name	: char *	: Configuration name			*/
/*  (returns)	: void		:					*/

void	CDialmonDlg::SetConfig
	(	char	*name
	)
{
	CComboBox *cb = (CComboBox *)GetDlgItem(IDC_CONFIGS) ;
	int	  idx = cb->FindStringExact (-1, name) ;
	if (idx != CB_ERR) cb->SetCurSel (idx) ;
}

/*  CDialmonDlg								*/
/*  SetBWidth	: Set notional bandwidth				*/
/*  bw		: char *	: Bandwidth value			*/
/*  (returns)	: void		:					*/

void	CDialmonDlg::SetBWidth
	(	char	*bw
	)
{
	if ((bwidth = atol(bw)) <= 0) bwidth = DEFBWIDTH ;
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDialmonDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void	CDialmonDlg::ClrConfig ()
{
	CComboBox *cb = (CComboBox *)GetDlgItem(IDC_CONFIGS) ;
	cb->ResetContent () ;
}

void	CDialmonDlg::Reset ()
{
	ClrConfig ( ) ;
	AllowDown (0) ;
	AllowUp	  (0) ;
	AllowSet  (0) ;
	AllowCtrl (0) ;
}

void CDialmonDlg::OnConfig() 
{

	/* If the configuration is locked then the Config button will	*/
	/* be the (re)connect button ...				*/
	if (lock)
	{	Reset		  ()  ;
		dialmonStopComms  ()  ;
		dialmonStartComms ()  ;
		return ;
	}
	
	// TODO: Add your control notification handler code here
	CDialmonConfig config (this) ;
	
	if (config.DoModal () == IDOK) 
	{	Reset		  ()  ;
		dialmonStopComms  ()  ;
		dialmonStartComms ()  ;
		((CButton *)GetDlgItem (IDC_CONFIG))->SetWindowText (lock ? strConnect : strConfig) ;
		GetSystemMenu(FALSE)->ModifyMenu (IDM_CONFIG, MF_BYCOMMAND, IDM_CONFIG, lock ? strConnect : strConfig) ;
		delete penFore	 ;
		delete penBack	 ;
		delete brushFore ;
		delete brushBack ;
		penBack   = new CPen   (PS_SOLID, 1, histBack) ;
		penFore   = new CPen   (PS_SOLID, 1, histFore) ;
		brushBack = new CBrush (histBack) ;
		brushFore = new CBrush (histFore) ;
		if (loadint == 0)
		{	DrawBar  (wTxBar, txtotal) ;
			DrawBar  (wRxBar, rxtotal) ;
		}
		else
		{	DrawBar  (wTxBar, txvals ) ;
			DrawBar  (wRxBar, rxvals ) ;
		}
	}
}

void CDialmonDlg::OnUp() 
{
	dialmonWriteCmd ("U\n") ;
}
 
void CDialmonDlg::OnDown() 
{
	dialmonWriteCmd ("D\n") ;
}

void CDialmonDlg::OnForce() 
{
	dialmonWriteCmd ("F\n") ;
}

void CDialmonDlg::OnNormal() 
{
	dialmonWriteCmd ("N\n") ;
}

void CDialmonDlg::OnBlock() 
{
	dialmonWriteCmd ("B\n") ;
}

void CDialmonDlg::OnRestart()
{
	CString	  conf ;
	CComboBox *cb  = (CComboBox *)GetDlgItem(IDC_CONFIGS) ;
	int	  sel  = cb->GetCurSel () ;
	char	  cmd  [128] ;

	conf.Empty () ;
	if (sel != CB_ERR)
	{	cb->GetLBText (sel, conf) ;
		sprintf	(cmd, "R%s\n", (LPCTSTR) conf) ;
	}
	else	strcpy	(cmd, "R\n") ;

	dialmonWriteCmd (cmd) ;
}

#ifdef	WIN32

/*  CDialmonDlg								*/
/*  OnTrayNotify: Handle tray notification messages			*/
/*  wID		: WPARAM	: Window icon identifier ?		*/
/*  lEvent	: LPARAM	: Event to be handled			*/
/*  (returns)	: LRESULT	:					*/

LRESULT	CDialmonDlg::OnTrayNotify
	(	WPARAM	wID,
		LPARAM	lEvent
	)
{
	switch (lEvent)
	{
		case WM_LBUTTONDBLCLK :
			/* Left double-click is a short-cut to request	*/
			/* to bring the link up.			*/
			KillTimer (LDBLCLICK_TIMER) ;
			OnConnect () ;
			return	  0  ;
	
		case WM_LBUTTONDOWN   :
			/* Start a timer, so that if the left button	*/
			/* does not come up in the double-click time	*/
			/* then we get the tray icon menu.		*/
			SetTimer  (LDBLCLICK_TIMER, ::GetDoubleClickTime(), NULL) ;
			return	  0 ;

		case WM_RBUTTONUP     :
			/* A right-button click also brings up the tray	*/
			/* icon menu.					*/
			return	IconMenu () ;

		default	:
			break	;
	}

	return	0 ;
}

LRESULT	CDialmonDlg::IconMenu ()
{
	CMenu	menu	  ;
	CMenu	*pSubMenu ;
	CPoint	mouse	  ;

	if (!menu.LoadMenu (IDI_BLANK) || ((pSubMenu = menu.GetSubMenu (0)) == NULL))
		return	0 ;

	display_connect = connected == CONNECTED ;

	/* Make first menu item the default (bold font); there is no	*/
	/* CMenu method for this.					*/
	pSubMenu->ModifyMenu (0, MF_BYPOSITION|MF_STRING,
			 	 IDM_CONNECT,
				 display_connect ? "Disconnect ..." :
						   "Connect ..."
			     ) ;
	::SetMenuDefaultItem (pSubMenu->m_hMenu, 0, TRUE) ;

	/* Display the menu at the current mouse location. There's a	*/
	/* "bug" (Microsoft calls it a feature) in Windows 95 that	*/
	/* Requires calling SetForegroundWindow. To find out more,	*/
	/* search for Q135788 in MSDN.					*/
	GetCursorPos	    (&mouse) ;
	SetForegroundWindow ()	     ;	
	::TrackPopupMenu    (pSubMenu->m_hMenu, 0,
						mouse.x,
						mouse.y,
						0,
						GetSafeHwnd (), NULL) ;

	return	1 ;
}

void	CDialmonDlg::OnConnect ()
{
	if (connected == UNKNOWN)
		connected = CONNECTED ;

	if (display_connect)
		OnDown	() ;
	else	OnUp	() ;
}
#endif	/* WIN32 */


/*  CDialmonDlg								*/
/*  OnTimer	: Handle reconnection timer				*/
/*  nID		: UINT		: Timer identifier			*/
/*  (returns)	: void		:					*/

void	CDialmonDlg::OnTimer
	(	UINT	nID
	)
{
	switch (nID)
	{
#ifdef	WIN32
		case LDBLCLICK_TIMER	    :
			/* This timer is used in order to distinguish	*/
			/* between single- and double-left clicks in	*/
			/* system tray icon.				*/
			KillTimer (LDBLCLICK_TIMER) ;
			IconMenu  () ;
			break	  ;
#endif	/* WIN32 */

		case DIALMON_CONNECT_TIMER  :
			/* If the connection to the dialmon daemon (not	*/
			/* the diald link) is down, then attempt to	*/
			/* reconnect.					*/
			if (!gotconn)
			{	dialmonStopComms  () ;
				dialmonStartComms () ;
			}
			break	  ;

		case DIALMON_CONNTIME_TIMER :
			/* This message should only arrive while the	*/
			/* diald link is up, and is used to show the	*/
			/* link up time.				*/
			if (conntime > 0)
			{	long	upfor	= time(NULL) - conntime ;
				int	secs	= (int)(upfor % 60) ;
				int	mins	= (int)(upfor / 60) ;
				char	uptxt[64] ;
				sprintf	(uptxt, "Link up %d:%02d", mins, secs) ;
				wUpFor.SetWindowText (uptxt) ;
			}
			break	;

		default	:
			break	  ;
	}
}

/*  CDialmonDlg								*/
/*  OnSize	: Trap resize to check for minimize			*/
/*  nType	: UINT		: Resize operation type			*/
/*  cx, cy	: int, int	: New sizes				*/
/*  (returns)	: void		:					*/

void	CDialmonDlg::OnSize
	(	UINT	nType,
		int	cx,
		int	cy
	) 
{
#ifdef	WIN32
	if (hideicon && (nType==SIZE_MINIMIZED))
		ShowWindow (SW_HIDE) ;
#endif	/* WIN32 */
	CDialog::OnSize (nType, cx, cy) ;
}
