// dialconf.cpp : implementation file
//

#include "stdafx.h"
#include "dialmon.h"
#include "dialconf.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

char	server[80]	= "" 	    ;	/* DialMon config server	*/
char	host  [80]	= ""	    ;	/* DialMon host			*/
char	port  [80]	= "7002"    ;	/* DialMon service or port	*/
char	user  [80]	= ""	    ;	/* User name			*/
char	pass  [80]	= ""	    ;	/* Password			*/
char	deffmt[80]	= "%a %b %d %H:%M" ;
char	logfmt[80]	= "%a %b %d %H:%M" ;
int	startmin	= 0	    ;	/* Start minimized flag		*/
int	startatx	= 0	    ;	/* Initial window X-position	*/
int	startaty	= 0	    ;	/* Initial window Y-position	*/
int	lock		= 0	    ;	/* Lock configuration		*/
int	nologin		= 0	    ;	/* No user login		*/
int	savepwd		= 0	    ;	/* Don't save password		*/
int	loadint		= 5	    ;	/* Load display interval	*/
long	histBack	= RGB(0,0,255);
long	histFore	= RGB(255,0,0);
int	hideicon	= 0	    ;	/* Hide icon (Win95)		*/

char	dialmon[]	= "dialmon" ;
char	dialini[]	= "dialmon.ini" ;
char	loguser[80]	;

/*  The "remini" variable is set if the configuration is loaded from	*/
/*  a remote file on the host, typically via samba. In this case, all	*/
/*  changes are written back there rather than to the local file (which	*/
/*  is still needed to identify the host.				*/
static	char		*remini	;


CDialmonConfig::CDialmonConfig
	(	CWnd*	pParent
	)
	:
	CDialog	(CDialmonConfig::IDD, pParent)
{
	char	t[32] ;
	sprintf	(t, "%d", loadint) ;

	//{{AFX_DATA_INIT(CDialmonConfig)
	m_host 	   = host	;
	m_port     = port	; 
	m_user     = user	;
	m_pass     = pass	;
	m_lock     = lock	;
	m_startmin = startmin	;
	m_loadint  = t		;
	m_logfmt   = logfmt	;
	m_nologin  = nologin 	;
	m_savepwd  = savepwd 	;
	m_hideicon = hideicon	;
	m_histBack = histBack   ;
	m_histFore = histFore   ;
	//}}AFX_DATA_INIT
}


void CDialmonConfig::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CDialmonConfig)
	DDX_Text  (pDX, IDC_HOST, 	 m_host	   ) ;
	DDX_Text  (pDX, IDC_PORT, 	 m_port	   ) ;             
	DDX_Text  (pDX, IDC_USER, 	 m_user	   ) ;
	DDX_Text  (pDX, IDC_PASS, 	 m_pass	   ) ;
	DDX_Text  (pDX, IDC_PERIOD,	 m_loadint ) ;
	DDX_Check (pDX, IDC_MINIMIZE,    m_startmin) ;
	DDX_Check (pDX, IDC_LOCK_CONFIG, m_lock    ) ;
	DDX_Check (pDX, IDC_NO_LOGIN,    m_nologin ) ;
	DDX_Check (pDX, IDC_SAVE_PASSWD, m_savepwd ) ;
#ifdef	WIN32
	DDX_Text  (pDX, IDC_LOGFMT, 	 m_logfmt  ) ;
	DDX_Check (pDX, IDC_HIDEICON,    m_hideicon) ;
#endif	/* WIN32 */
	//}}AFX_DATA_MAP
}

BOOL	CDialmonConfig::OnInitDialog ()
{
	CDialog::OnInitDialog () ;
	return	TRUE ;
}



BEGIN_MESSAGE_MAP(CDialmonConfig, CDialog)
	//{{AFX_MSG_MAP(CDialmonConfig)
	ON_BN_CLICKED	   (IDC_BACKGROUND,     OnBackground)
	ON_BN_CLICKED	   (IDC_FOREGROUND,     OnForeground)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void	CDialmonConfig::SetColour
	(	long	&colour
	)
{
	CHOOSECOLOR	cc 	 ;
	DWORD		cust[16] ;

	cc.lStructSize		= sizeof(cc)	;
	cc.hwndOwner		= m_hWnd	;
	cc.hInstance		= NULL		;
	cc.rgbResult		= colour	;
	cc.lpCustColors		= cust		;
	cc.Flags		= CC_PREVENTFULLOPEN|CC_RGBINIT ;
	cc.lCustData		= 0		;
	cc.lpfnHook		= NULL		;
	cc.lpTemplateName	= NULL		;

	if (ChooseColor (&cc))
		colour	= cc.rgbResult ;
}

void CDialmonConfig::OnBackground ()
{
	SetColour (m_histBack) ;
}

void CDialmonConfig::OnForeground ()
{
	SetColour (m_histFore) ;
}

/*  CDialmonConfig							*/
/*  OnOK	  : Handle OK event					*/
/*  (returns)	  : void		:				*/

void CDialmonConfig::OnOK () 
{
	char	path[256] ;

	CDialog::OnOK () ;

	/* Copy back the string variables ...				*/
	strncpy	(host,   m_host,   sizeof(host  )) ;
	strncpy	(port,   m_port,   sizeof(port  )) ;   
	strncpy	(user,   m_user,   sizeof(user  )) ;
	strncpy	(pass,   m_pass,   sizeof(pass  )) ;
	strncpy	(logfmt, m_logfmt, sizeof(logfmt)) ;

	/* Make sure that we have a log format string. If it does not	*/
	/* contain at least one percent sign then zap it to the default	*/
	/* so that people cannot get an empty time column.		*/
	if (strchr (logfmt, '%') == NULL) strcpy (logfmt, deffmt) ;

	/* Copy back the integer configurations. The load interval is	*/
	/* checked so that we cannot get negative values.		*/
	startmin = m_startmin ;
	lock	 = m_lock     ;
	nologin	 = m_nologin  ;
	savepwd  = m_savepwd  ;
	histBack = m_histBack ;
	histFore = m_histFore ;
	hideicon = m_hideicon ;

	if ((loadint = atol (m_loadint)) < 0) loadint = 5 ;

	if (remini != NULL)
		strcpy	(path, remini) ;
	else	strcpy	(path, "dialmon.ini") ;

	WritePrivateProfileString (dialmon, "host",     host,		      path) ;
	WritePrivateProfileString (dialmon, "port",     port,		      path) ;
	WritePrivateProfileString (dialmon, "startmin", startmin ? "1" : "0", path) ;
	WritePrivateProfileString (dialmon, "lock",     lock     ? "1" : "0", path) ;
	WritePrivateProfileString (dialmon, "nologin",  nologin  ? "1" : "0", path) ;
	WritePrivateProfileString (dialmon, "savepwd",  savepwd  ? "1" : "0", path) ;
	WritePrivateProfileString (dialmon, "user",     user,		      path) ;
	WritePrivateProfileString (dialmon, "password", savepwd ? pass: "",   path) ;
	WritePrivateProfileString (dialmon, "loadint",  m_loadint,	      path) ;
	WritePrivateProfileString (dialmon, "logfmt",   logfmt,		      path) ;
	WritePrivateProfileString (dialmon, "hideicon", hideicon ? "1" : "0", path);

	char	rgb[32]	;
	sprintf	(rgb, "0x%08lx", histBack) ;
	WritePrivateProfileString (dialmon, "histback", rgb, path);
	sprintf	(rgb, "0x%08lx", histFore) ;
	WritePrivateProfileString (dialmon, "histfore", rgb, path);
}

BOOL	dialmonConfLoad
	(	BOOL	path,
		char	*inifile
	)
{
	OFSTRUCT ofs	;

	ofs.cBytes	  = sizeof(ofs) ;
	ofs.szPathName[0] = 0 ;

	if (path)
		if (OpenFile (inifile, &ofs, OF_EXIST) == HFILE_ERROR)
			return	FALSE ;

	GetPrivateProfileString (dialmon, "host",     "",     host,   sizeof(host  ), inifile) ;
	GetPrivateProfileString (dialmon, "port",     "",     port,   sizeof(port  ), inifile) ;
	GetPrivateProfileString (dialmon, "user",     "",     user,   sizeof(user  ), inifile) ;
	GetPrivateProfileString (dialmon, "password", "",     pass,   sizeof(pass  ), inifile) ;
	GetPrivateProfileString (dialmon, "logfmt",   deffmt, logfmt, sizeof(logfmt), inifile) ;

	hideicon = GetPrivateProfileInt (dialmon, "hideicon", 0, inifile) ;
	startmin = GetPrivateProfileInt (dialmon, "startmin", 0, inifile) ;
	startatx = GetPrivateProfileInt (dialmon, "startatx", 0, inifile) ;
	startaty = GetPrivateProfileInt (dialmon, "startaty", 0, inifile) ;
	lock	 = GetPrivateProfileInt (dialmon, "lock",     0, inifile) ;
	nologin	 = GetPrivateProfileInt (dialmon, "nologin",  0, inifile) ;
	savepwd	 = GetPrivateProfileInt (dialmon, "savepwd",  0, inifile) ;
	loadint  = GetPrivateProfileInt (dialmon, "loadint",  5, inifile) ;
	if (loadint < 0) loadint = 5 ;

	char	text[32] ;

	GetPrivateProfileString (dialmon, "logfmt", "%a %b %d %H:%M", text, sizeof(text), inifile) ;

	GetPrivateProfileString (dialmon, "histback", "0xff0000",     text, sizeof(text), inifile) ;
	histBack = strtol (text, NULL, 0) ;
	GetPrivateProfileString (dialmon, "histfore", "0x0000ff",     text, sizeof(text), inifile) ;
	histFore = strtol (text, NULL, 0) ;

	return	TRUE ;
}

BOOL	dialmonConfInit ()
{
	DWORD	lul	= sizeof(loguser) ;

#ifdef	WIN32
	if (!GetUserName (loguser, &lul))
#endif
		strcpy	(loguser, "dialmon") ;

	if (server[0] != 0)
	{
		char	path[256] ;

		if (server[1] == ':')
			sprintf	(path, "%s\\%s.ini",              server, loguser) ;
		else	sprintf	(path, "\\\\%s\\dialmon\\%s.ini", server, loguser) ;

		if (dialmonConfLoad (TRUE, path))
		{	remini	= strdup (path) ;
			return TRUE ;
		}
	}

	return	dialmonConfLoad (FALSE, "dialmon.ini") ;
}



