// dialcomm.cpp : implementation file
//

#include "stdafx.h"
#include "dialmon.h"
#include "dialdlg.h"  
#include "ctype.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*  CDialSock								*/
/*  This class is derived from the CAsyncSocket class, and is used to	*/
/*  provide the virtual OnConnect and OnReceive method to handle	*/
/*  asynchronous connection and reception events.			*/

class	CDialSock : public CAsyncSocket
{
	void	MapMessage (char *) ;
public:
	virtual	void	OnConnect (int) ;
	virtual	void	OnReceive (int) ;                       
	virtual	void	OnClose	  (int) ;
}	;

static	CDialSock	*sock		;	/* Connection		*/
static	char		infobuf[256]	;	/* Information buffer	*/
static	int		infolen		;	/* Information length	*/
extern	CDialmonDlg	*dialmonDlg	;	/* Monitor dialog box	*/
extern	char		host[]		;	/* DialMon host name	*/
extern	char		port[]		;	/* DialMon port name	*/
extern	char		user[]		;	/* User name		*/
extern	char		pass[]		;	/* Password		*/
extern	int		nologin		;	/* No user login	*/
extern	int		savepwd		;	/* Save password	*/
	int		gotconn		;	/* Connected to dialmon	*/

/*  CDialSock								*/
/*  OnConnect	: Handle connection event				*/
/*  errcode	: int		: Error code or zero if OK		*/
/*  (returns)	: void		:					*/

void	CDialSock::OnConnect
	(	int	errcode
	)
{
	char	b[256] ;

	/* If the connection failed then display an error message and	*/
	/* close the socket.						*/
	if (errcode != 0)
	{	dialmonDlg->SetState   ("Connection error ...") ;
		dialmonDlg->SetMessage ("") ;
#if	0
		::MessageBox (dialmonDlg->m_hWnd,
			      "Unable to connect to DialMon daemon",
		              "DialMon Error", 
		              MB_ICONEXCLAMATION|MB_OK) ;
#endif
		gotconn	 = 0 ;
		Close () ;
		return	 ;
	}

	/* Connected OK. At this stage the state of diald is not known	*/
	/* so diaplay something suitable. The Up control can alse be	*/
	/* enabled at this point.					*/
	infolen	= 0 ;
	gotconn	= 1 ;
	dialmonDlg->SetState   ("State unknown") ;
	dialmonDlg->SetMessage ("Awaiting first message") ;

	sprintf	(b, "V%d.%d\n", VERSION, SUBVER) ;
	Send	((void *)b, strlen(b)) ;

	if (!nologin)
	{	sprintf	(b, "L%s:%s\n", user, pass) ;
		Send	((void *)b, strlen(b)) ;
	}
}

/*  CDialSock								*/
/*  MapMessage	: Make DialD control messages				*/
/*  msg		: char *	: Report from dialmon daemon		*/
/*  (returns)	: void		: Passes mapped message to dialog box	*/
                                        
void	CDialSock::MapMessage
	(	char	*msg
	)
{
	static	char	*mmap[] =
	{	"DEAD",		"dead",
		"ALIVE",	"alive",
		"GOING",	"stopping",
		"BOOTF",	"failed to start",
		"RESTART",	"restarting",
		"IDLE",		"idle",
		"UNKNOWN",	"state unknown",
		NULL
	}	;

	char	text[128] ;
	char	*info	  = msg	;

	for (int idx = 0 ; mmap[idx] != NULL ; idx += 2)
		if (strncmp (mmap[idx], msg, strlen(mmap[idx])) == 0)
		{	info	= mmap[idx+1] ;
			break	;
		}

	sprintf	(text, "Dialer daemon %s", info) ;
	dialmonDlg->SetMessage (text) ;
}

/*  CDialSock								*/
/*  OnReceive	: Handle reception event				*/
/*  errcode	: int		: Error code or zero if OK		*/
/*  (returns)	: void		:					*/
                                       
void	CDialSock::OnReceive
	(	int	errcode
	)
{
	int	len	;
	char	*lp	;

	if (errcode != 0)
	{	dialmonDlg->SetState   ("Communications error ...") ;
		dialmonDlg->SetMessage ("") ;
#if	0
		::MessageBox (dialmonDlg->m_hWnd,
			      "Error communicating with DialMon daemon",
		              "DialMon Error", 
		              MB_ICONEXCLAMATION|MB_OK) ;
#endif
		gotconn	 = 0 ; 
		Close () ;                                                
		dialmonDlg->AllowDown (0) ;
		dialmonDlg->AllowUp   (0) ;
	}

	while ((len = Receive ((void *)&infobuf[infolen], sizeof(infobuf) - infolen)) > 0)
	{
		infolen += len	;

		while ((lp = (char *)memchr(infobuf, '\n', infolen)) != NULL)
		{
			*lp++	= 0 ;

			if	(strncmp (infobuf, "LOAD",	  4) == 0)
				dialmonDlg->SetLoad    (&infobuf[5]) ;
			else if (strncmp (infobuf, "QUEUE",	  5) == 0)
				dialmonDlg->Queue      (&infobuf[6]) ;
			else if (strncmp (infobuf, "LOG",	  3) == 0)
				dialmonDlg->Logging    (&infobuf[4]) ;
			else if	(strncmp (infobuf, "STATE",       5) == 0)
				dialmonDlg->SetState   (&infobuf[6]) ;
			else if (strncmp (infobuf, "INTERFACE",   9) == 0)
				dialmonDlg->SetIface   (&infobuf[10]) ;
			else if (strncmp (infobuf, "MESSAGE",     7) == 0)
			{	dialmonDlg->SetMessage (&infobuf[8]) ;
				if (strncmp (&infobuf[8], "Invalid user", 12) == 0)
				{	AfxMessageBox (&infobuf[8]) ;
					PostMessage   (dialmonDlg->m_hWnd, WM_COMMAND, IDC_CONFIG, NULL) ;
				}
			}
			else if (strncmp (infobuf, "MODE",	  4) == 0)
				dialmonDlg->SetMode     (&infobuf[5]) ;
			else if (strncmp (infobuf, "DIALD",       5) == 0)
				MapMessage (&infobuf[6]) ;

			else if (strncmp (infobuf, "EXTERN DOWN",    11) == 0)
				dialmonDlg->SetMessage ("!Incoming call cleared") ;
			else if (strncmp (infobuf, "EXTERN UP",       9) == 0)
				dialmonDlg->SetMessage ("!Incoming call active", TRUE) ;

			else if (strncmp (infobuf, "ALLOW_DOWN YES", 14) == 0)
				dialmonDlg->AllowDown  (1) ;
			else if (strncmp (infobuf, "ALLOW_UP YES",   12) == 0)
				dialmonDlg->AllowUp    (1) ;
			else if (strncmp (infobuf, "ALLOW_CTRL YES", 14) == 0)
				dialmonDlg->AllowCtrl  (1) ;
			else if (strncmp (infobuf, "ALLOW_SET YES",  13) == 0)
				dialmonDlg->AllowSet   (1) ;
			else if (strncmp (infobuf, "ALLOW_DOWN NO",  13) == 0)
				dialmonDlg->AllowDown  (0) ;
			else if (strncmp (infobuf, "ALLOW_UP NO",    11) == 0)
				dialmonDlg->AllowUp    (0) ;
			else if (strncmp (infobuf, "ALLOW_CTRL NO",  13) == 0)
				dialmonDlg->AllowCtrl  (0) ;
			else if (strncmp (infobuf, "ALLOW_SET NO",   12) == 0)
				dialmonDlg->AllowSet   (0) ;
			else if (strncmp (infobuf, "DDCONF ", 	      7) == 0)
				dialmonDlg->AddConfig  (&infobuf[7]) ;
			else if (strncmp (infobuf, "DDCURC ", 	      7) == 0)
				dialmonDlg->SetConfig  (&infobuf[7]) ;
			else if (strncmp (infobuf, "RESET", 	      5) == 0)
				dialmonDlg->ClrConfig  () ;
			else if (strncmp (infobuf, "BWIDTH ",	      7) == 0)
				dialmonDlg->SetBWidth  (&infobuf[7]) ;
			memmove	(infobuf, lp, infolen - (lp - infobuf)) ;
			infolen	-= lp - infobuf ;
		}

		if (infolen >= sizeof(infobuf)) infolen = 0 ;
	}
}
                        
/*  CDialSock								*/
/*  OnClose	: Handle close event					*/
/*  errcode	: int		: Error code or zero if OK		*/
/*  (returns)	: void		:					*/
                                       
void	CDialSock::OnClose
	(	int	errcode
	)
{
	dialmonDlg->SetState   ("Host closed connection ...") ;
	dialmonDlg->SetMessage ("") ;
#if	0
	::MessageBox (dialmonDlg->m_hWnd,
		      "DialMon daemon closed connection",
	              "DialMon Error", 
	              MB_ICONEXCLAMATION|MB_OK) ;
#endif
	gotconn	 = 0 ;
	Close () ;
	dialmonDlg->AllowDown (0) ;
	dialmonDlg->AllowUp   (0) ;
	dialmonDlg->AllowCtrl (0) ;
}
                        
/*  dialmonStartComms							*/
/*		: Start communications to DialMon daemon		*/
/*  (returns)	: void		:					*/

void	dialmonStartComms ()
{
	struct	hostent		*he	;
	struct	servent		*se	;
	struct	sockaddr_in	sin	; 
	
	if ((host[0] == 0) || (port[0] == 0)) return ;

	dialmonDlg->SetState   ("Finding DialMon daemon") ;
	dialmonDlg->SetMessage ("") ;

	/* If the host name does not start with a digit then assume	*/
	/* that it is a name and look it up. If it does start with a	*/
	/* digit the assume that is is an address in dot format.	*/
	if (!isdigit (host[0]))
	{
		if ((he = gethostbyname (host)) == NULL)
		{	dialmonDlg->SetState   ("Unknown host") ;
			dialmonDlg->SetMessage ("") ;
			::MessageBox (dialmonDlg->m_hWnd,
				      "Host name for DialMon daemon unknown",
			              "DialMon Error", 
		        	      MB_ICONEXCLAMATION|MB_OK) ;
			return	;
		}
		sin.sin_addr.s_addr	= *(long *)(he->h_addr_list[0]) ;
	}
	else	sin.sin_addr.s_addr	= inet_addr (host) ;

	/* Similarly, if the service name starts with a non-digit then	*/
	/* look it up, otherwise assume it is a port number.		*/
	if (!isdigit (port[0]))
	{
		if ((se = getservbyname (port, NULL)) == NULL)
		{	dialmonDlg->SetState   ("Unknown service") ;
			dialmonDlg->SetMessage ("") ;
			::MessageBox (dialmonDlg->m_hWnd,
				      "Port name for DialMon daemon unknown",
			              "DialMon Error", 
			              MB_ICONEXCLAMATION|MB_OK) ;
			return	;
		}

		sin.sin_port = se->s_port ;
	}
	else	sin.sin_port = htons (atoi (port)) ;

	/* In any case, this is ain Internet socket. Winsock does not	*/
	/* in fact support anything else.				*/
	sin.sin_family	= AF_INET     ;

	sock	= new CDialSock ;

	if (!sock->Create (0, SOCK_STREAM, FD_CONNECT|FD_READ|FD_CLOSE))
	{	dialmonDlg->SetState   ("Socket error ...") ;
		dialmonDlg->SetMessage ("") ;
		::MessageBox (dialmonDlg->m_hWnd,
			      "Error creating DialMon daemon connection socket",
		              "DialMon Error", 
		              MB_ICONEXCLAMATION|MB_OK) ;
		delete	sock	;
		sock =	NULL	;
		return	;
	}


	if (!sock->Connect ((struct sockaddr *)&sin, sizeof(sin)))
		if (sock->GetLastError () != WSAEWOULDBLOCK)
		{	dialmonDlg->SetState   ("Connection error") ;
			dialmonDlg->SetMessage ("") ;
			::MessageBox (dialmonDlg->m_hWnd,
				      "Unable to connect to DialMon daemon",
			              "DialMon Error", 
		        	      MB_ICONEXCLAMATION|MB_OK) ;
			delete	sock	;
			sock =	NULL	;
			return	;
		}
}

/*  dialmonStopComms							*/
/*		: Stop communications to DialMon daemon			*/
/*  (returns)	: void		:					*/

void	dialmonStopComms ()
{
	if (sock != NULL)
	{	sock->Close ()	;
		delete sock	;
		sock = NULL	;
	}

	dialmonDlg->SetState	("Idle") ;
	dialmonDlg->SetMessage	("")	 ;
}

/*  dialmonWriteCmd							*/
/*		: Write command character to DialMon daemon		*/
/*  cmd		: char *	: Command string			*/
/*  (returns)	: void		:					*/

void	dialmonWriteCmd
	(	char	*cmd
	)
{
	if (sock != NULL) sock->Send ((void *)cmd, strlen(cmd)) ;
}

