/*  sendcmd	: Send command to dialmon				*/
/*  who		: char *	: Who is calling			*/
/*  cmd		: char *	: Command text				*/
/*  (returns)	: void		:					*/

static	void	sendcmd
	(	char	*who,
		char	*cmd
	)
{
	char	path	[256] ;
	int	dialfd	;

	/* The command is sent down the status pipe to dialmon ...	*/
	sprintf	(path, "%s/dialmon.stat", PIPEDIR) ;
	if ((dialfd = open (path, O_RDWR)) < 0)
	{	syslog	(LOG_ERR|LOG_PID|LOG_NDELAY, "%s: cannot open %s: %d",
			 who, path, errno) ;
		return	;
	}

	/* Send the command. Sod all we can do if this fails so we	*/
	/* ignore the result other than to log the failure.		*/
	if (write (dialfd, cmd, strlen(cmd)) != strlen(cmd))
		syslog	(LOG_ERR|LOG_PID|LOG_NDELAY, "%s: writing %s: %d",
			 who, path, errno) ;

	sleep	(1)	 ;
	close	(dialfd) ;

	syslog	(LOG_ERR|LOG_PID|LOG_NDELAY, "%s: wrote %s", who, cmd) ;
}

