#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<unistd.h>
#include	<ctype.h>
#include	<fcntl.h>
#include	<syslog.h>
#include	<errno.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<netdb.h>

static	char	*logcmd	;
static	char	*logexe	;

#include	"dialmon.h"
#include	"sendcmd.c"

/*  login	: Invoke real login command				*/
/*  argv	: char *[]	: Argument vector			*/
/*  (returns)	: void		: Should never return			*/

static	void	login
	(	char	*argv[]
	)
{
	/* Set the command name (which defaults to "login") and the	*/
	/* executable path (which defaults to "/bin/login").		*/
	argv[0]	= logcmd  ;
	execv	(logexe, argv) ;

	exit	(1) ;
}

/*  main	: Standard entry routine				*/
/*  argc	: int		: Argument count			*/
/*  argv	: char *[]	: Argument vector			*/
/*  (returns)	: int		: Exit code				*/

int	main
	(	int	argc,
		char	*argv[]
	)
{
	char	*e	;

	/* Since we cannot get arguments through the real getty to the	*/
	/* login stub, environment variables are used ...		*/
	if ((e = getenv ("LOGIN_STUB_CMD")) != NULL) logcmd = strdup (e) ;
	if ((e = getenv ("LOGIN_STUB_EXE")) != NULL) logexe = strdup (e) ;

	if (logcmd == NULL) logcmd = "login"      ;
	if (logexe == NULL) logexe = "/bin/login" ;

	sendcmd	("loginstub", "E+\n") ;

	/* Drop through to the real login program. This call will never	*/
	/* return, so the following line just keeps the compiler happy.	*/
	login	(argv)	;
	return	1	;
}
