#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<unistd.h>
#include	<ctype.h>
#include	<fcntl.h>
#include	<syslog.h>
#include	<errno.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<netdb.h>

static	char	*gtycmd	= "getty"	;
static	char	*gtyexe	= "/sbin/getty"	;
static	char	*logcmd	= NULL		;
static	char	*logexe	= NULL		;
static	int	delay	= 0		;

#include	"dialmon.h"
#include	"sendcmd.c"

/*  getty	: Invoke real getty command				*/
/*  argv	: char *[]	: Argument vector			*/
/*  (returns)	: void		: Should never return			*/

static	void	getty
	(	char	*argv[]
	)
{
	/* The argument vector will actually point at the first		*/
	/* argument rather than the command name, so back up by one ...	*/
	argv	-= 1	  ;

	/* ... and the set the command name (which defaults to "getty")	*/
	/* and the executable path (which defaults to "/sbin/getty").	*/
	argv[0]	= gtycmd  ;
	execv	(gtyexe, argv) ;

	exit	(1) ;
}

/*  nextarg	: Check for next argument				*/
/*  lvargc	: int *		: Argument count pointer		*/
/*  lvargv	: char ***	: Argument vector pointer		*/
/*  lvopts	: char **	: Options pointer			*/
/*  (returns)	: void		:					*/

static	void	nextarg
	(	int	*lvargc,
		char	***lvargv,
		char	**lvopts
	)
{
	/* I really should learn how to use the getopt routines, but	*/
	/* for the moment ...						*/
	if ((*lvopts)[0] == 0)
	{
		if ((*lvargc) <= 0)
			exit	(1) ;

		*lvopts  = **lvargv ;
		*lvargv += 1 ;
		*lvargc -= 1 ;
	}
}

/*  main	: Standard entry routine				*/
/*  argc	: int		: Argument count			*/
/*  argv	: char *[]	: Argument vector			*/
/*  (returns)	: int		: Exit code				*/

int	main
	(	int	argc,
		char	*argv[]
	)
{
	char	logcmde	[256] ;
	char	logexee	[256] ;

	argc	-= 1	;
	argv	+= 1	;

	while (argc > 0)
	{
		char	*opts	= *argv	;

		argv	+= 1	;
		argc	-= 1	;
		opts	+= 1	;

		while (*opts) switch (*opts++)
		{
			case '-' :
				/* The argument -- marks then end of	*/
				/* arguments to logstub. Setting argc	*/
				/* to zero drops us out of the loop.	*/
				argc	= 0 ;
				break	;

			case 'g' :
				/* Set the getty program name ....	*/
				nextarg (&argc, &argv, &opts) ;
				gtycmd	= opts	;
				opts	= ""	;
				break	;

			case 'G' :
				/* ... and the getty executable.	*/
				nextarg (&argc, &argv, &opts) ;
				gtyexe	= opts	;
				opts	= ""	;
				break	;

			case 'l' :
				/* Set the login program name ....	*/
				nextarg (&argc, &argv, &opts) ;
				logcmd	= opts	;
				opts	= ""	;
				break	;

			case 'L' :
				/* ... and the login executable.	*/
				nextarg (&argc, &argv, &opts) ;
				logexe	= opts	;
				opts	= ""	;
				break	;

			case 't' :
				/* Set the delay used before the real	*/
				/* getty is invoked.			*/
				nextarg (&argc, &argv, &opts) ;
				delay	= strtol (opts, &opts, 10) ;
				break	;

			default	 :
				/* This is probably an error, but	*/
				/* assume that we have really reached	*/
				/* an argument to getty, so drop out of	*/
				/* the loop.				*/
				argc	= 0	;
				break	;
		}
	}

	sendcmd	("gettystub", "E-\n") ;

	/* Since we cannot pass arguments through to the login stub,	*/
	/* we use environment variables for each possibility.		*/
	if (logcmd != NULL)
	{	sprintf	(logcmde, "LOGIN_STUB_CMD=%s", logcmd) ;
		putenv	(logcmde) ;
	}
	if (logexe != NULL)
	{	sprintf	(logexee, "LOGIN_STUB_EXE=%s", logexe) ;
		putenv	(logexee) ;
	}

	/* Drop through to the real getty program. This call will never	*/
	/* return, so the following line just keeps the compiler happy.	*/
	if (delay > 0) sleep (delay) ;
	getty	(argv)	;
	return	1	;
}
