/*  For some consistency, #define's starting DD... refer to diald	*/
/*  related things, which those starting DM... refer to dialmon itself.	*/
/*  Those starting PP... refer to the PPP deamon.			*/

/*  DialD								*/
/*  -----								*/

/*  Define DDCFIFO to be the path name of the diald control fifo. This	*/
/*  should usually be "/etc/diald/diald.ctl", and will default to this	*/
/*  if DDCFIFO is not defined.						*/

/*  #define	DDCFIFO		"/etc/diald/diald.ctl"			*/

/*  Define DDPFILE to be the file in which the process identifierr of	*/
/*  the dialer daemon is stored. Defaults to "/var/run/diald.pid"	*/

/*  #define	DDPFILE		"/var/run/diald.pid"			*/

/*  Define DDBIN to be the path to the dialer daemon binary, defaulting	*/
/*  to "/usr/sbin/diald"						*/

/*  #define	DDBIN		"/usr/sbin/diald"			*/


/*  DialMon								*/
/*  -------								*/

/*  Define DMCFILE to specify the name of a control file for dialmon.	*/
/*  If not specified then it defaults to "/etc/dialmon.conf".		*/

/*  #define	DMCFILE		"/etc/dialmon.conf"			*/

/*  Define DMUFILE to specify the name of the dialmon user file. If not	*/
/*  specified it will default to "/etc/dialmon.users".			*/

/*  #define	DMUFILE		"/etc/dialmon.users"			*/

/*  Define DMPFILE to be the file into which the process ID of dialmon	*/
/*  is written. If not defined it will default to "/var/run/dialmon.pid	*/

/*  #define	DMPFILE		"/var/run/dialmon.pid"			*/

/*  Define LOGFILE to be the file into which connection the log will	*/
/*  be written. If not defiend it will default to "/var/log/dialmon".	*/
/*  Note that there should be no need to use system log rotation	*/
/*  utilities on this files.						*/

/*  #define	LOGFILE		"/var/log/dialmon"			*/

/*  Define DMPORT to be the port number or service name on which	*/
/*  dialmon is to listen for incoming connections. Defaults to		*/
/*  "dialmon"								*/

/*  #define	DMPORT		"dialmon"				*/

/*  Define MAXCONN to be the maximum number of clients that can		*/
/*  connect. Defaults to 32.						*/

/*  #define	MAXCONN		32					*/


/*  PPP Daemon								*/
/*  --- ------								*/

/*  Define PPPFILE to describe the path of the PPP PID file. This is	*/
/*  used as the format string in a call to sprintf, with the PPP device	*/
/*  name (eg., ppp0) as the argument. Defaults to "/var/run/%s.pid"	*/

/*  #define	PPPFILE		"/var/run/%s.pid"			*/


#define	VERSION		"DialMon V0.7\n"
#define	USAGE		"usage: dialmon [-D] [-bbwidth] [-f] [-i] "	\
			"[-P] [-S] [-ppppif] [-rddconf] [-v] [-V] "	\
			"[control]\n"
#define	NODOWN		"MESSAGE Link down not permitted\n"
#define	NOUP		"MESSAGE Link up not permitted\n"
#define	NOSET		"MESSAGE Link state setting not permitted\n"
#define	BADUSER		"MESSAGE Invalid user/password format\n"
#define	BADPWD		"MESSAGE Invalid user or password\n"
#define	PWDERR		"MESSAGE Invalid dialmon password setting\n"
#define	OKPWD		"MESSAGE Password verified OK\n"
#define	NOCTRL		"MESSAGE Dialer daemon control not allowed\n"
#define	DDKFAIL		"MESSAGE Cannot kill dialer daemon\n"
#define	DDSFAIL		"MESSAGE Cannot start dialer daemon\n"
#define	DDCONFL		"MESSAGE Dialer daemon configuration lost\n"
#define	DDLINKF		"MESSAGE Dialer daemon configuration error\n"
#define	PPKFAIL		"MESSAGE Cannot kill PPP daemon\n"

#define	DDGOING		"DIALD GOING"
#define	DDDEAD		"DIALD DEAD"
#define	DDALIVE		"DIALD ALIVE"
#define	DDBOOTF		"DIALD FAILED"
#define	DDRESTART	"DIALD RESTARTING"
#define	DDUNKNOWN	"DIALD UNKNOWN"
#define	DDIDLE		"DIALD IDLE"

#define	EXTERNUP	"EXTERN UP"
#define	EXTERNDOWN	"EXTERN DOWN"

#define	STRERR		strerror(errno)


#ifndef	DDCFIFO
#define	DDCFIFO		"/etc/diald/diald.ctl"
#endif	/* DDCFIFO */
#ifndef	DDPFILE
#define	DDPFILE		"/var/run/diald.pid"
#endif	/* DDPFILE */
#ifndef	DDBIN
#define	DDBIN		"/usr/sbin/diald"
#endif	/* DDBIN */

#ifndef	DMCFILE
#define	DMCFILE		"/etc/dialmon.conf"
#endif	/* DMCFILE */
#ifndef	DMUFILE
#define	DMUFILE		"/etc/dialmon.users"
#endif	/* DMUFILE */
#ifndef	DMPFILE
#define	DMPFILE		"/var/run/dialmon.pid"
#endif	/* DMPFILE */
#ifndef	LOGFILE
#define	LOGFILE		"/var/log/dialmon"
#endif	/* LOGFILE */
#ifndef	DMPORT
#define	DMPORT		"dialmon"
#endif	/* DMPORT */
#ifndef	MAXCONN
#define	MAXCONN		32
#endif	/* MAXCONN */
#ifndef	MAXPKTQ
#define	MAXPKTQ		64
#endif	/* MAXPKTQ */

#ifndef	PPPFILE
#define	PPPFILE		"/var/run/%s.pid"
#endif	/* PPPFILE */


#define	PIPEDIR		"/tmp"


#define	DEFBW	(33600 / 10)		/* Default bandwidth bytes/sec	*/

					/* Client permissions		*/
#define	A_UP	(0x0001)		/* Allowed to bring link up	*/
#define	A_DOWN	(0x0002)		/* Allowed to take link down	*/
#define	A_SET	(0x0004)		/* Allowed to block/force	*/
#define	A_CTRL	(0x0008)		/* Allow DialD control		*/
					/* Client request flags		*/
#define	F_QUEUE	(0x0001)		/* Send queue information	*/
#define	F_LOAD	(0x0002)		/* Send load information	*/
#define	F_ALL	(0xffff)		/* Send all information		*/

#if	0
#define	LMANUAL	(0x0010)		/* Manual link operation	*/
#endif

					/* scanfor types		*/
#define	MHOST	(0x0001)		/* Host configuration		*/
#define	MCLNT	(0x0002)		/* Client machine options	*/
#define	MUSER	(0x0004)		/* User options			*/

/*  DIALCNF								*/
/*  This structure contains diald configurations for usw with multiple	*/
/*  selectable configurations.						*/
/*									*/
typedef	struct
{	char	*name		;
	char	*cmd		;
}	DIALCNF	;

/*  DIALINF								*/
/*  The DIALINF structure contains information relating to client	*/
/*  connections, plus stuff that appears only in a global instance	*/
/*  of the structure. This appears here for convenience only.		*/
/*									*/
typedef	struct
{	int	perm		;	/* Access permissions	  GC	*/
	char	port	[ 32]	;	/* Client connection port G.	*/
	char	fifo	[128]	;	/* DialD FIFO name	  G.	*/
	char	pwd     [ 32]	;	/* Client password	  .C	*/
	int	force		;	/* Force up time	  G.	*/
	int	logsize		;	/* Log size by entries	  G.	*/
	long	logtime		;	/* Log size by time	  G.	*/
}	DIALINF	;

typedef	struct
{	char	*user		;	/* User name if logged in	*/
	char	*host		;	/* Peer host name		*/
	int	version		;	/* Client version if known	*/
	int	subver		;	/* Client sub-version if known	*/
	int	perm		;	/* Connection permissions	*/
	int	flags		;	/* Client request flags		*/
	int	force		;	/* Connection forced		*/
	char	buff[1024]	;	/* Command buffer		*/
	int	blen		;	/* Current command length	*/
}	Peer	;

#define	IDLE	"Idle"			/* Idle name			*/
#define	MAXFD	(MAXCONN+5)		/* Allow for stdin, etc ...	*/
#define	global				/* Syntactic sugar		*/

/*  queue.c								*/
/*									*/
extern	void	sendqueue	() ;
extern	void	loadserv	() ;
extern	void	startnsl	(int, char  **) ;
extern	void	checknsl	(fd_set *) ;
extern	void	clrqueue	() ;
extern	void	*queue_rtn	(char *) ;
extern	void	qtidy		() ;

/*  config.c								*/
/*									*/
extern	int	scanfor		(char *, char *, DIALINF *, int) ;
extern	void	sendconf	() ;
extern	DIALCNF	*findconf	(char *) ;

/*  ddcomms.c								*/
/*									*/
extern	int	ddinit		() ;
extern	void	dialdup		() ;
extern	void	dialddn		() ;
extern	void	dialdforce	() ;
extern	void	dialdblock	() ;
extern	void	dialdunfrc	() ;
extern	void	dialdunblk	() ;
extern	void	ddcomms		(fd_set *, int) ;
extern	void	ctidy		() ;

/*  ddctrl.c								*/
/*									*/
extern	int	restart		(int, char *) ;
extern	void	autoboot	() ;
extern	void	killall		() ;
extern	void	sigchld		(int) ;
extern	void	dtidy		() ;

/*  client.c								*/
/*									*/
extern	int	newconnection	(int) ;
extern	void	clientcomms	(fd_set *) ;
extern	int	clientreq	(int, int) ;

/*  logging.c								*/
/*									*/
extern	void	addtolog	(long, long, char *, int, int) ;
extern	void	sendlog		(int ) ;

/*  dialmon.c								*/
/*									*/
extern	void	errexit		(char *, ...) ;
extern	void	logout		(int, char *, ...) ;
extern	void	copystr		(char *, char *, int) ;
extern	void	forward		(char *, char *, char *, int) ;
extern	void	*dont_care	(char *) ;
extern	void	tidyup		() ;
extern	int	ddinit		() ;
extern	void	fdmaskset	(int, int) ;
extern	void	fdmaskclr	(int) ;
extern	void	sendmode	() ;
extern	void	logconn		() ;


extern	char	*ddconf		;	/* Dialer demon restart config	*/
extern	int	ddidle		;	/* Allow diald idling		*/
extern	char	*pppd		;	/* Restart PPP device		*/
extern	int	bwidth		;	/* Nominal link bandwidth	*/
extern	DIALINF	definfo		;	/* Default information		*/
extern	char	*dmufile	;	/* Dialmon users file		*/
extern	char	*dmcfile	;	/* Diald configuration file	*/
extern	char	laststate[]	;	/* Last state from diald	*/
extern	char	lastmsg  []	;	/* Last message from diald	*/
extern	char	lastload []	;	/* Last load from diald		*/
extern	char	lastiface[]	;	/* Last interface message	*/
extern	int	logsize		;	/* Maximum log size by entries	*/
extern	long	logtime		;	/* Maximum log size by time	*/
extern	int	extcon		;	/* External connection active	*/

typedef	enum
{	SAuto,				/* Try automatic detection	*/
	SPasswd,			/* Use standard passwords	*/
	SShadow,			/* Use shadow passwords		*/
	SPam				/* Use PAM authentication	*/
}	AuthTyp			;

typedef	enum
{	Normal,				/* Normal operation		*/
	Block,				/* Connection is blocked	*/
	Force				/* Connection is forced up	*/
}	DMode	;

typedef	enum
{	None,				/* Queue is not packed		*/
	Simple,				/* Pack host:port		*/
	Group				/* Non-priviliged ports grouped	*/
}	Packing	;

extern	AuthTyp	authtyp		;	/* Authentication mode		*/
extern	DMode	dmode		;	/* Current operation mode	*/
extern	DMode	amode		;	/* Diald's actual reported mode	*/
extern	Packing	packq		;	/* Queue packing mode		*/