/*  config.o								*/
/*  --------								*/
/*  This file contains the routines usded to load configuration		*/
/*  information.							*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<ctype.h>
#include	<time.h>

#include	"dialmon.h"

/*  The "dialcnf" array holds all configrarations (up to a maximum of	*/
/*  32); the number of such configurations is held in "ndialcnf".	*/

static	DIALCNF	dialcnf	 [32]	;
static	int	ndialcnf	;

/*  nextline	: Get next line from file skipping comments		*/
/*  line	: char *	: Line buffer				*/
/*  llen	: int		: Line buffer length			*/
/*  fd		: FILE *	: File descriptor			*/
/*  (returns)	: int		: Non-zero until EOF			*/

static	int	nextline
	(	char	*line,
		int	llen,
		FILE	*fd
	)
{
	char	*lp	;

	/* Loop reading lines and skipping comments. The first non-	*/
	/* comment has leading whitespace removed and is returned if it	*/
	/* is not empty.						*/
	while (fgets (line, llen, fd) != NULL)
	{
		if  ((line[0] == '#') || (line[0] == ';'))
			continue ;
		for (lp = line ; (*lp != 0) && isspace(*lp) ; lp += 1)
			;
		if  (*lp == 0)
			continue ;

		strcpy	(line, lp) ;
		return	1 ;
	}

	return	0 ;			
}

/*  scanfor	: Scan configuration file for entry			*/
/*  fname	: char *	: Configuration file name		*/
/*  entry	: char *	: Entry name				*/
/*  dialinf	: DIALINF *	: Entry result structure		*/
/*  types	: int		: Mask of allowed types			*/
/*  (returns)	: int		: Non-zero on success			*/

int	scanfor
	(	char	*fname,
		char	*entry,
		DIALINF	*dialinf,
		int	types
	)
{
	FILE	*fd	 ;
	char	line[200];
	char	optn[128];
	char	cmd [128];
	int	found	 ;
	int	elen	 = strlen (entry) ;

	/* Open the file and scan for a line which contains the		*/
	/* requested entry, ie., [entry]				*/
	if ((fd = fopen (fname, "r")) == NULL)
		return	0 ;

	for (found = 0 ; !found && nextline (line, sizeof(line), fd) ; )
		found	= (line[0     ]		           == '[') &&
			  (strncmp (&line[1], entry, elen) ==   0) &&
			  (line[elen+1]		           == ']') ;

	if (!found)
	{	fclose	(fd) ;
		return	0    ;
	}

	/* Now scan all lines up to the next entry or the end of the	*/
	/* file, decoding the possible configuration options.		*/
	while (nextline (line, sizeof(line), fd))
	{
		if (line[0] == '[')
			break	;

		if (sscanf (line, "allow %30s", optn) == 1)
		{
			/* The first three allow options are		*/
			/* acceptable for in all configuration		*/
			/* sections.					*/

			if (strcmp (optn, "up"  ) == 0)
			{	dialinf->perm |= A_UP	;
				continue ;
			}
			if (strcmp (optn, "down") == 0)
			{	dialinf->perm |= A_DOWN ;
				continue ;
			}
			if (strcmp (optn, "set" ) == 0)
			{	dialinf->perm |= A_UP|A_DOWN|A_SET ;
				continue ;
			}
			if (strcmp (optn, "ctrl") == 0)
			{	dialinf->perm |= A_CTRL ;
				continue ;
			}

			errexit	("Bad allow option: %s", optn) ;
		}

		if (sscanf (line, "port %30s",  optn) == 1)
		{
			/* The port option is only allowed in the	*/
			/* host section.				*/
			if ((types & MHOST) == 0)
				errexit	("Unexpected option: port") ;

			strcpy	(dialinf->port, optn) ;
			continue ;
		}

		if (sscanf (line, "force %30s", optn) == 1)
		{
			/* The force option is only allowed in the	*/
			/* host section.				*/
			if ((types & MHOST) == 0)
				errexit	("Unexpected option: force") ;

			dialinf->force = atoi (optn) ;
			continue ;
		}

		if (sscanf (line, "fifo %126s", optn) == 1)
		{
			/* The fifo option is only allowed in the	*/
			/* host section.				*/
			if ((types & MHOST) == 0)
				errexit	("Unexpected option: fifo") ;

			strcpy	(dialinf->fifo, optn) ;
			continue ;
		}

		if (sscanf (line, "passwd %30s",  optn) == 1)
		{
			/* The passed option is only allowed in user	*/
			/* sections.					*/
			if ((types & MUSER) == 0)
				errexit	("Unexpected option: passed") ;

			strcpy	(dialinf->pwd,  optn) ;
			continue ;
		}

		if (sscanf (line, "ddconf %30s \"%120[^\"]\"", optn, cmd) == 2)
		{
			/* Diald configurations are only allowed in the	*/
			/* host section.				*/
			if ((types & MHOST) == 0)
				errexit	("Unexpected option: ddconf") ;

			if (ndialcnf >= sizeof(dialcnf)/sizeof(DIALCNF))
				errexit ("Too many diald configurations") ;

			dialcnf[ndialcnf].name = strdup (optn) ;
			dialcnf[ndialcnf].cmd  = strdup (cmd ) ;
			ndialcnf += 1 ;
			continue ;
		}

		if (sscanf (line, "logtime %120[0-9]", optn) == 1)
		{
			/* Log limiting stuff is only permitted in the	*/
			/* host section.				*/
			if ((types & MHOST) == 0)
				errexit	("Unexpected option: logtime") ;

			dialinf->logtime = atol(optn) ;
			continue ;
		}

		if (sscanf (line, "logsize %120[0-9]", optn) == 1)
		{
			/* Log limiting stuff is only permitted in the	*/
			/* host section.				*/
			if ((types & MHOST) == 0)
				errexit	("Unexpected option: logtime") ;

			dialinf->logsize = atol(optn) ;
			continue ;
		}

		errexit	("Unknown option: %s", line) ;
	}

	fclose	(fd) ;
	return	1    ;

}

/*  sendconf	: Send configuration information to clients		*/
/*  fd		: int		: Client connection or negative for all	*/
/*  (returns)	: void		:					*/

global	void	sendconf
	(	int	fd
	)
{
	int	idx	;
	char	bws	[16 ] ;

	forward	(NULL, "RESET", NULL, 0) ;

	for (idx = 0 ; idx < ndialcnf ; idx += 1)
		forward (NULL, "DDCONF", dialcnf[idx].name, 0) ;

	if (ddidle)
		forward (NULL, "DDCONF", IDLE,   0) ;

	if (ddconf != NULL)
		forward	(NULL, "DDCURC", ddconf, 0) ;
	else	forward	(NULL, "DDCURC", IDLE,   0) ;

	sprintf	 (bws,  "%d",     bwidth) ;
	forward	 (NULL, "BWIDTH", bws, 0) ;
}

/*  findconf	: Look up configuration					*/
/*  name	: char *	: Configuration name			*/
/*  (returns)	: DIALCNF *	: Configuration or NULL if not found	*/

global	DIALCNF	*findconf
	(	char	*name
	)
{
	int	idx	;

	for (idx = 0 ; idx < ndialcnf ; idx += 1)
		if (strcmp (dialcnf[idx].name, name) == 0)
			return	&dialcnf[idx] ;

	return	NULL	;
}
