/*
 mem.c

 DFC -- Dedicated File Cache -- memory operations

 Copyright (c) 2000 Edward V. POPKOV
 Distributed under GPL, see COPYING for details

 "Edward V. POPKOV" <evpopkov@carry.netnet.lv>

 $Id: mem.c,v 0.5 2000/09/22 14:47:43 root Exp root $

 $Log: mem.c,v $
 Revision 0.5  2000/09/22 14:47:43  root
 Fixed permissions on pidfile

 Revision 0.4  2000/09/21 21:56:07  root
 Fixed `after file' bug

 Revision 0.3  2000/04/19 20:49:26  root
 Optimized code, fixed includes/defines

 Revision 0.2  2000/04/18 01:08:17  root
 Bugfix (buffer overrun) in dfcd

 Revision 0.1  2000/04/07 15:00:00  root
 Signal handling workaround, bugfixes, added sample conf, backup on upgrade

 Revision 0.0  2000/04/06 13:45:28  root
 Initial check-in

*/

#ifndef _MEM_
#define _MEM_

#include <dfc.h>

int dfc_mem_new( void * * mem, const size_t size )
{
	int r = FALSE;

DFC_PARAM_CHECK( mem != NULL && (* mem) == NULL )

	r = ((* mem) = calloc( size, sizeof( char ))) != NULL;

DFC_R_PERROR( r )
DFC_PARAM_ERROR

	return r;

}/* dfc_mem_new */

int dfc_mem_resize( void * * mem, const size_t new_size )
{
	int r = FALSE;

DFC_PARAM_CHECK( mem != NULL && new_size >= DFC_EMPTY )

	void * m = NULL;

	if (( m = realloc((* mem), new_size )) != NULL ) {
		(* mem) = m;
		r = TRUE;
	}

DFC_R_PERROR( r )
DFC_PARAM_ERROR

	return r;

}/* dfc_mem_resize */

int dfc_mem_free( void * * mem )
{
	int r = FALSE;

DFC_PARAM_CHECK( mem != NULL && (* mem) != NULL )

	free((* mem));
	(* mem) = NULL;
	r = TRUE;

DFC_PARAM_ERROR

	return r;

}/* dfc_mem_free */

#endif /*_MEM_*/

/* End of mem.c */
