/*
 file.c

 DFC -- Dedicated File Cache -- file operations

 Copyright (c) 2000 Edward V. POPKOV
 Distributed under GPL, see COPYING for details

 "Edward V. POPKOV" <evpopkov@carry.netnet.lv>

 $Id: file.c,v 0.5 2000/09/22 14:47:43 root Exp root $

 $Log: file.c,v $
 Revision 0.5  2000/09/22 14:47:43  root
 Fixed permissions on pidfile

 Revision 0.4  2000/09/21 21:56:07  root
 Fixed `after file' bug

 Revision 0.3  2000/04/19 20:49:26  root
 Optimized code, fixed includes/defines

 Revision 0.2  2000/04/18 01:08:17  root
 Bugfix (buffer overrun) in dfcd

 Revision 0.1  2000/04/07 15:00:00  root
 Signal handling workaround, bugfixes, added sample conf, backup on upgrade

 Revision 0.0  2000/04/06 13:45:28  root
 Initial check-in

*/

#ifndef _FILE_
#define _FILE_

#include <dfc.h>

int dfc_file_isfile( const char * fname, fstat_t * fs )
{
	int r = FALSE;

DFC_PARAM_CHECK( len_c( fname ) > DFC_EMPTY && fs != NULL &&
		fs->fs_off == DFC_ERROR && fs->fs_uid != DFC_ROOTID &&
		fs->fs_gid != DFC_ROOTID )

	struct stat st;

	if ( stat( fname, &st ) != DFC_ERROR ) {
		if ( S_ISREG( st.st_mode )) {
			fs->fs_off = st.st_size;
			fs->fs_uid = st.st_uid;
			fs->fs_gid = st.st_gid;
			r          = TRUE;
		}
	}

DFC_R_PERROR( r )
DFC_PARAM_ERROR

	return r;

}/* dfc_file_isfile */

int dfc_file_open( int * fd, const char * fname, const int flags )
{
	int r = FALSE;

DFC_PARAM_CHECK( fd != NULL && (* fd) == DFC_ERROR && len_c(fname) > DFC_EMPTY )

	r = ((* fd) = open( fname, flags )) != DFC_ERROR;

DFC_R_PERROR( r )
DFC_PARAM_ERROR

	return r;

}/* dfc_file_open */

int dfc_file_get( const int fd, char * dst, const size_t size )
{
	int r = FALSE;

DFC_PARAM_CHECK( fd != DFC_ERROR && dst != NULL && size > DFC_EMPTY )

	ssize_t sr = DFC_ERROR;
	size_t  sc = DFC_EMPTY;

	while (sc<size && (sr=read(fd,(void *)(dst+sc),size-sc)) > DFC_EMPTY)
		sc += sr;

	r = sr != DFC_ERROR;

DFC_R_PERROR( r )
DFC_PARAM_ERROR

	return r;

}/* dfc_file_get */

int dfc_file_close( int * fd )
{
	int r = FALSE;

DFC_PARAM_CHECK( fd != NULL && (* fd) != DFC_ERROR )

	r = close((* fd)) != DFC_ERROR;

	if ( r ) {
		(* fd) = DFC_ERROR;
	} else {
		dfc_perror;
	}

DFC_PARAM_ERROR

	return r;

}/* dfc_file_close */

#endif /*_FILE_*/

/* End of file.c */
