/*
 dmn.c

 DFC -- Dedicated File Cache -- daemonize

 Copyright (c) 2000 Edward V. POPKOV
 Distributed under GPL, see COPYING for details

 "Edward V. POPKOV" <evpopkov@carry.netnet.lv>

 $Id: dmn.c,v 0.5 2000/09/22 14:47:43 root Exp root $

 $Log: dmn.c,v $
 Revision 0.5  2000/09/22 14:47:43  root
 Fixed permissions on pidfile

 Revision 0.4  2000/09/21 21:56:07  root
 Fixed `after file' bug

 Revision 0.3  2000/04/19 20:49:26  root
 Optimized code, fixed includes/defines

 Revision 0.2  2000/04/18 01:08:17  root
 Bugfix (buffer overrun) in dfcd

 Revision 0.1  2000/04/07 15:00:00  root
 Signal handling workaround, bugfixes, added sample conf, backup on upgrade

 Revision 0.0  2000/04/06 13:45:28  root
 Initial check-in

*/

#ifndef _DMN_
#define _DMN_

#include <dfc.h>

#define DFC_DMN_PID_BUFSIZE    0x000A
#define DFC_DMN_PID_OPEN_FLAGS O_WRONLY | O_CREAT | O_EXCL
#define DFC_DMN_PID_OPEN_PERMS S_IRUSR | S_IWUSR
#define DFC_DMN_PID_FMT        "%d"

int dfc_dmn_loop = FALSE;
int dfc_dmn_conf = FALSE;

int dfc_dmn_bkground()
{
	int   r = FALSE;
	pid_t p = DFC_ERROR;

	if (( p = fork())) {
		if ( p == DFC_ERROR ) {
			dfc_perror;
			exit( EXIT_FAILURE );
		} else {
			exit( EXIT_SUCCESS );
		}
	}

	r = setsid() != DFC_ERROR;

DFC_R_PERROR( r )

	return r;

}/* dfc_dmn_bkground */

int dfc_dmn_writepid( const char * pidfname )
{
	int r = FALSE;

DFC_PARAM_CHECK( len_c( pidfname ) > DFC_EMPTY )

	int  s = DFC_ERROR;
	char p[ DFC_DMN_PID_BUFSIZE ];
	int  f = DFC_ERROR;

	s = snprintf( p, DFC_DMN_PID_BUFSIZE, DFC_DMN_PID_FMT, getpid());
	if ( s != DFC_ERROR ) {
		f=open(pidfname,DFC_DMN_PID_OPEN_FLAGS,DFC_DMN_PID_OPEN_PERMS);
		if ( f != DFC_ERROR ) {
			r = write( f, (void *) p, s ) == s;
			dfc_file_close( &f );
		}
	}

DFC_R_PERROR( r )
DFC_PARAM_ERROR

	return r;

}/* dfc_dmn_writepid */

int dfc_dmn_sigact( const int sig, const int reset, sighandler_t hnd )
{
	int r = FALSE;

DFC_PARAM_CHECK( sig != SIGKILL && sig != SIGSTOP && hnd != NULL )

	struct sigaction sa;

	sa.sa_handler  = hnd;
	memset((void *) &sa.sa_mask, (char) DFC_EMPTY, sizeof( sa.sa_mask ));
	sa.sa_flags    = DFC_EMPTY;
	sa.sa_restorer = NULL;

	if ( reset ) sa.sa_flags |= SA_ONESHOT;

	r = sigaction( sig, &sa, NULL ) != DFC_ERROR;

DFC_R_PERROR( r )
DFC_PARAM_ERROR

	return r;

}/* dfc_dmn_sigact */

int dfc_dmn_cleanup( const char * pidfname )
{
	int r = FALSE;

DFC_PARAM_CHECK( len_c( pidfname ) > DFC_EMPTY )

	r = unlink( pidfname ) != DFC_ERROR;

DFC_R_PERROR( r )
DFC_PARAM_ERROR

	return r;

}/* dfc_dmn_cleanup */
	
RETSIGTYPE dfc_dmn_sigterm( int s )
{

	dfc_dmn_loop = FALSE;
	dfc_dmn_conf = FALSE;

	return;

}/* dfc_dmn_sigterm */

RETSIGTYPE dfc_dmn_sighup( int s )
{

	dfc_dmn_loop = FALSE;
	dfc_dmn_conf = TRUE;

	return;

}/* dfc_dmn_sighup */

#endif /*_DMN_*/

/* End of dmn.c */
