/*
 dir.c

 DFC -- Dedicated File Cache -- read dir

 Copyright (c) 2000 Edward V. POPKOV
 Distributed under GPL, see COPYING for details

 "Edward V. POPKOV" <evpopkov@carry.netnet.lv>

 $Id: dir.c,v 0.5 2000/09/22 14:47:43 root Exp root $

 $Log: dir.c,v $
 Revision 0.5  2000/09/22 14:47:43  root
 Fixed permissions on pidfile

 Revision 0.4  2000/09/21 21:56:07  root
 Fixed `after file' bug

 Revision 0.3  2000/04/19 20:49:26  root
 Optimized code, fixed includes/defines

 Revision 0.2  2000/04/18 01:08:17  root
 Bugfix (buffer overrun) in dfcd

 Revision 0.1  2000/04/07 15:00:00  root
 Signal handling workaround, bugfixes, added sample conf, backup on upgrade

 Revision 0.0  2000/04/06 13:45:28  root
 Initial check-in

*/

#ifndef _DIR_
#define _DIR_

#include <dfc.h>

#define DFC_DIR_DOT ((char) '.' )

int dfc_dir_open( DIR * *, const char * )
	__attribute__(( __regparm__( 2 )));
int dfc_dir_entry( DIR *, char * *, const char * )
	__attribute__(( __regparm__( 3 )));
int dfc_dir_close( DIR * * )
	__attribute__(( __regparm__( 1 )));

int dfc_dir_open( DIR * * dir, const char * dname )
{
	int r = FALSE;

DFC_PARAM_CHECK( dir != NULL && (* dir) == NULL && len_c( dname ) > DFC_EMPTY )

	(* dir) = opendir( dname );
	r = (* dir) != NULL;

DFC_R_PERROR( r )
DFC_PARAM_ERROR

	return r;

}/* dfc_dir_open */

int dfc_dir_entry( DIR * dir, char * * entry, const char * dname )
{
	int    r  = FALSE;
	size_t sd = DFC_EMPTY;

DFC_PARAM_CHECK( dir != NULL && entry != NULL && (* entry) == NULL &&
		( sd = len_c( dname )) > DFC_EMPTY )

	struct dirent * de = NULL;
	size_t          se = DFC_EMPTY;

	while (( de = readdir( dir )) != NULL ) {
		if ( de->d_name[ DFC_BASE ] == DFC_DIR_DOT )
			continue;
		se = dn_len( de );
		if ( dfc_mem_new((void * *) entry, sd+sizeof(DFC_SLASH)+se+1)) {
			memcpy((void *) (* entry), (void *) dname, sd );
			(* entry)[ sd ] = DFC_SLASH;
			memcpy((void *) ((* entry) + sd + sizeof( DFC_SLASH )),
				(void *) ( de->d_name ), se );
			(* entry)[ sd + sizeof( DFC_SLASH ) + se ] = DFC_EMPTY;
			r = TRUE;
		} else {
			dfc_err( "Memory allocation error" );
		}
		break;
	}

//	if ( errno != DFC_EMPTY ) dfc_perror;

DFC_PARAM_ERROR

	return r;

}/* dfc_dir_entry */

int dfc_dir_close( DIR * * dir )
{
	int r = FALSE;

DFC_PARAM_CHECK( dir != NULL && (* dir) != NULL )

	r = closedir((* dir)) != DFC_ERROR;
	if ( r )
		(* dir) = NULL;
	else
		dfc_perror;

DFC_PARAM_ERROR

	return r;

}/* dfc_dir_close */

#endif /*_DIR_*/

/* End of dir.c */
