/*
 dfc.h

 DFC -- Dedicated File Cache -- global header

 Copyright (c) 2000 Edward V. POPKOV
 Distributed under GPL, see COPYING for details

 "Edward V. POPKOV" <evpopkov@carry.netnet.lv>

 $Id: dfc.h,v 0.5 2000/09/22 14:47:43 root Exp root $

 $Log: dfc.h,v $
 Revision 0.5  2000/09/22 14:47:43  root
 Fixed permissions on pidfile

 Revision 0.4  2000/09/21 21:56:07  root
 Fixed `after file' bug

 Revision 0.3  2000/04/19 20:49:26  root
 Optimized code, fixed includes/defines

 Revision 0.2  2000/04/18 01:08:17  root
 Bugfix (buffer overrun) in dfcd

 Revision 0.1  2000/04/07 15:00:00  root
 Signal handling workaround, bugfixes, added sample conf, backup on upgrade

 Revision 0.0  2000/04/06 13:45:28  root
 Initial check-in

*/

#ifndef _DFC_H_
#define _DFC_H_

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif /*_GNU_COURCE*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/

#if STDC_HEADERS
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#endif /*STDC_HEADERS*/
#if HAVE_DIRENT_H
#include <dirent.h>
#define dn_len( d ) ( strlen(( d )->d_name ))
#else
#define dirent direct
#define dn_len( d ) (( d )->d_namelen )
#if HAVE_SYS_NDIR_H
#include <sys/ndir.h>
#endif /*HAVE_SYS_NDIR_H*/
#if HAVE_SYS_DIR_H
#include <sys/dir.h>
#endif /*HAVE_SYS_DIR_H*/
#if HAVE_NDIR_H
#include <ndir.h>
#endif /*HAVE_NDIR_H*/
#endif /*HAVE_DIRENT_H*/
#if HAVE_ERRNO_H
#include <errno.h>
#endif /*HAVE_ERRNO_H*/
#if HAVE_FCNTL_H
#include <fcntl.h>
#endif /*HAVE_FCNTL_H*/
#if HAVE_SIGNAL_H
#include <signal.h>
#endif /*HAVE_SIGNAL_H*/
#if HAVE_STDIO_H
#include <stdio.h>
#endif /*HAVE_STDIO_H*/
#if HAVE_UNISTD_H
#include <unistd.h>
#endif /*HAVE_UNISTD_H*/
#if HAVE_SYS_IPC_H
#include <sys/ipc.h>
#endif /*HAVE_SYS_IPC_H*/
#if HAVE_SYS_SHM_H
#include <sys/shm.h>
#endif /*HAVE_SYS_SHM_H*/
#if HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif /*HAVE_SYS_STAT_H*/
#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif /*HAVE_SYS_TYPES_H*/

typedef RETSIGTYPE (* sighandler_t)( int );
typedef char dent_t[ NAME_MAX + 1 ];
typedef struct fstat_s {
			off_t fs_off;
			uid_t fs_uid;
			gid_t fs_gid;
		       } fstat_t;

#ifndef FALSE
#define FALSE 0
#endif /*FALSE*/

#ifndef TRUE
#define TRUE 1
#endif /*TRUE*/

#define DFC_ERROR  -1
#define DFC_EMPTY  0
#define DFC_BASE   0
#define DFC_ROOTID 0
#define DFC_SLASH  ((char) '/' )

#define DFC_FTOK_SYM 'X'

#define len_c( c ) (( c ) == NULL ? DFC_EMPTY : strlen(( c )))

#define dfc_err( e ) fprintf( stderr, "DFC %s(): %s.\n", __FUNCTION__, ( e ))

#if HAVE_PERROR
#define dfc_perror perror( __FUNCTION__ )
#else
#define dfc_perror dfc_err( "system error" )
#endif /*HAVE_PERROR*/

#if DFC_ENABLE_PARAMCHECK
#define DFC_PARAM_CHECK( r )	if (( r )) {
#define DFC_PARAM_ERROR		} else { dfc_err( "param check failed" ); }
#else
#define DFC_PARAM_CHECK( r )
#define DFC_PARAM_ERROR
#endif /*DFC_ENABLE_PARAMCHECK*/

#define DFC_R_PERROR( r )	if ( ! ( r )) { dfc_perror; }

#ifndef _CHR_

extern int dfc_chr_trim( char * * dst );

#endif /*_CHR_*/

#ifndef _CNF_

extern int dfc_cnf_entry( const int fd, char * * entry )
	__attribute__(( __regparm__( 2 )));

#endif /*_CNF_*/

#ifndef _DIR_

extern int dfc_dir_open( DIR * * dir, const char * dname )
	__attribute__(( __regparm__( 2 )));
extern int dfc_dir_entry( DIR * dir, char * * entry, const char * dname )
	__attribute__(( __regparm__( 3 )));
extern int dfc_dir_close( DIR * * dir )
	__attribute__(( __regparm__( 1 )));

#endif /*_DIR_*/

#ifndef _DMN_

extern int dfc_dmn_loop;
extern int dfc_dmn_conf;
extern int dfc_dmn_bkground();
extern int dfc_dmn_writepid( const char * pidfname );
extern int dfc_dmn_sigact( const int sig, const int reset, sighandler_t hnd );
extern int dfc_dmn_cleanup( const char * pidfname );
extern RETSIGTYPE dfc_dmn_sigterm( int s );
extern RETSIGTYPE dfc_dmn_sighup( int s );

#endif /*_DMN_*/

#ifndef _FILE_

extern int dfc_file_isfile( const char * fname, fstat_t * fs );
extern int dfc_file_open( int * fd, const char * fname, const int flags );
extern int dfc_file_get( const int fd, char * dst, const size_t size );
extern int dfc_file_close( int * fd );

#endif /*_FILE_*/

#ifndef _IPC_

extern int dfc_ipc_ftok( key_t * key, char * path );
extern int dfc_ipc_shm_create( int * mem, char * * addr, key_t key, int size );
extern int dfc_ipc_shm_setown( const int mem, const uid_t uid, const gid_t gid);
extern int dfc_ipc_shm_destroy( int * mem )
	__attribute__(( __regparm__( 1 )));
extern int dfc_ipc_shm_attach( char * * addr, const key_t key, const int size );
extern int dfc_ipc_shm_detach( char * * addr );

#endif /*_IPC_*/

#ifndef _MEM_

extern int dfc_mem_new( void * * mem, const size_t size );
extern int dfc_mem_resize( void * * mem, const size_t new_size );
extern int dfc_mem_free( void * * mem );

#endif /*_MEM_*/

#endif /*_DFC_H_*/

/* End of dfc.h */
