/*
 cnf.c

 DFC -- Dedicated File Cache -- config file

 Copyright (c) 2000 Edward V. POPKOV
 Distributed under GPL, see COPYING for details

 "Edward V. POPKOV" <evpopkov@carry.netnet.lv>

 $Id: cnf.c,v 0.5 2000/09/22 14:47:43 root Exp root $

 $Log: cnf.c,v $
 Revision 0.5  2000/09/22 14:47:43  root
 Fixed permissions on pidfile

 Revision 0.4  2000/09/21 21:56:07  root
 Fixed `after file' bug

 Revision 0.3  2000/04/19 20:49:26  root
 Optimized code, fixed includes/defines

 Revision 0.2  2000/04/18 01:08:17  root
 Bugfix (buffer overrun) in dfcd

 Revision 0.1  2000/04/07 15:00:00  root
 Signal handling workaround, bugfixes, added sample conf, backup on upgrade

 Revision 0.0  2000/04/06 13:45:28  root
 Initial check-in

*/

#ifndef _CNF_
#define _CNF_

#include <dfc.h>

#define DFC_CNF_COMMENT ((char) '#')
#define DFC_CNF_NL      ((char) '\n')

int dfc_cnf_entry( const int, char * * ) __attribute__(( __regparm__( 2 )));

int dfc_cnf_entry( const int fd, char * * entry )
{
	int r = FALSE;

DFC_PARAM_CHECK( fd != DFC_ERROR && entry != NULL )

	char c = DFC_EMPTY;

	if ( dfc_mem_resize((void * *) entry, sizeof( c ))) {

		ssize_t sr = DFC_ERROR;
		int     rm = FALSE;
		size_t  l  = DFC_EMPTY;

		(* entry)[ DFC_BASE ] = DFC_EMPTY;
		do {
			sr = read( fd, (void *) &c, sizeof( c ));
			if ( sr != sizeof( c )) {
				if ( sr == DFC_ERROR ) dfc_perror;
				r = FALSE;
				break;
			}

			if ( ! isprint(c) && ! isblank(c) && c != DFC_CNF_NL) {
				dfc_err( "Non-printable char" );
				r = FALSE;
				break;
			}

			rm = rm || c == DFC_CNF_COMMENT;

			if ( c == DFC_CNF_NL ) {
				if ( l > DFC_EMPTY ) {
					r = dfc_chr_trim( entry );
					if ( ! r )
						break;
					l = strlen((* entry ));
				}
				if ( l > DFC_EMPTY ) {
					r = TRUE;
					break;
				} else {
					r  = FALSE;
					rm = FALSE;
					continue;
				}
			}

			if ( rm ) continue;

			l++;
			if ( ! dfc_mem_resize((void * *) entry, l + 1 )) {
				dfc_err( "Error expanding entry buffer" );
				r = FALSE;
				break;
			}

			(* entry)[ l - 1 ] = c;
			(* entry)[ l ] = DFC_EMPTY;

		}
		while ( TRUE );
	}

DFC_PARAM_ERROR

	return r;

}/* dfc_cnf_entry */

#endif /*_CNF_*/

/* End of cnf.c */
