/*
 chr.c

 DFC -- Dedicated File Cache -- char operations

 Copyright (c) 2000 Edward V. POPKOV
 Distributed under GPL, see COPYING for details

 "Edward V. POPKOV" <evpopkov@carry.netnet.lv>

 $Id: chr.c,v 0.5 2000/09/22 14:47:43 root Exp root $

 $Log: chr.c,v $
 Revision 0.5  2000/09/22 14:47:43  root
 Fixed permissions on pidfile

 Revision 0.4  2000/09/21 21:56:07  root
 Fixed `after file' bug

 Revision 0.3  2000/04/19 20:49:26  root
 Optimized code, fixed includes/defines

 Revision 0.2  2000/04/18 01:08:17  root
 Bugfix (buffer overrun) in dfcd

 Revision 0.1  2000/04/07 15:00:00  root
 Signal handling workaround, bugfixes, added sample conf, backup on upgrade

 Revision 0.0  2000/04/06 13:45:28  root
 Initial check-in

*/

#ifndef _CHR_
#define _CHR_

#include <dfc.h>

int dfc_chr_trim( char * * dst )
{
	int    r  = FALSE;
	size_t sd = DFC_EMPTY;

DFC_PARAM_CHECK( dst != NULL && ( sd = len_c((* dst))) > DFC_EMPTY )

	char * db = (* dst);
	size_t dp = DFC_BASE;

	while ( dp < sd && isblank( db[ dp ]))
		dp++;

	db += dp;

	if (( sd = strlen( db )) > DFC_EMPTY ) {
		dp = sd - 1;
		while ( dp > DFC_BASE && isblank( db[ dp ]))
			dp--;
		sd = dp + 1;
	}

	memmove((void *) (* dst), (void *) db, sd );
	r = dfc_mem_resize((void * *) dst, sd + 1 );
	(* dst)[ sd ] = DFC_EMPTY;

DFC_R_PERROR( r )
DFC_PARAM_ERROR

	return r;

}/* dfc_chr_trim */

#endif /*_CHR_*/

/* End of chr.c */
