/*
** identd.c                   A TCP/IP link identification protocol server
**
** Version: 1.0.0
**
** This program is in the public domain and may be used freely by anyone
** who wants to. 
**
** Last update: 20 Sep 1993
**
** Please send bug fixes/bug reports to: 
**                  Pauline Middelink (middelin@calvin.iaf.nl)
*/

#define VERSION "[identd, version 1.0.0]"

#include <stdio.h>
#include <netdb.h>
#include <pwd.h>
#include <syslog.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int debug_flag = 0;
int syslog_flag = 0;

/*
** Return the name of the connecting host, or the IP number as a string.
*/
const
char *gethost(addr)
struct in_addr *addr;
{
  struct hostent *hp;

  hp = gethostbyaddr((char *)addr, sizeof(struct in_addr), AF_INET);
  if (hp) return hp->h_name;
  else return inet_ntoa(*addr);
}

int getinfo(struct in_addr *faddr, int fport, struct in_addr *laddr, int lport)
{
	FILE		*fp;
	long		dummy;
	char		buf[132];
	struct in_addr	myladdr, myraddr;
	int		mylport, myrport;
	int		uid;

	/*
	** Open the kernel memory device
	*/
	if ((fp = fopen("/proc/net/tcp", "r"))==NULL) {
		if (syslog_flag)
			syslog(LOG_INFO, "fopen(/proc/net/tcp) failed");

                printf("%d, %d: ERROR: UNKNOWN-ERROR\r\n", lport, fport), \
		exit(1);
	}

	/* eat header */
	fgets(buf,sizeof(buf)-1,fp);
	while (fscanf(fp,"%d: %lX:%x %lX:%x %x %lX:%lX %x:%lX %lx %d",
			&dummy, &myladdr, &mylport, &myraddr, &myrport,
			&dummy, &dummy, &dummy, &dummy, &dummy, &dummy,
			&uid)==12) {
		if (myladdr.s_addr==laddr->s_addr && mylport==lport &&
		    myraddr.s_addr==faddr->s_addr && myrport==fport) return uid;
	}
	return -1;
}

int main(int argc, char *argv[]) {
	int		i, len;
	int		uid;
	struct sockaddr_in sin;
	struct in_addr	laddr, faddr;
	int		lport, fport;
	struct passwd	*pwp;

	/*
	 * Parse the command line arguments
	 */
	for (i = 1; i < argc && argv[i][0] == '-'; i++)
		while (*(++argv[i]))
			switch (*argv[i]) {
			case 'l': syslog_flag++;
				  break;
			case 'V': puts(VERSION);
				  exit(0);
			case 'd': debug_flag++;
				  break;
			}

	/*
	 * Get foreign internet address
	 */
	len = sizeof(sin);
	if (getpeername(0,(struct sockaddr *)&sin,&len) == -1) {
		/*
		 * A user has tried to start us from the command line or
		 * the network link died, in which case this message won't
		 * reach to other end anyway, so lets give the poor user some
		 * errors.
		 */
		perror("identd: getpeername()");
		exit(1);
	}
	faddr = sin.sin_addr;

	/*
	 * Get local internet address
	 */
	len = sizeof(sin);
	if (getsockname(0,(struct sockaddr *)&sin,&len) == -1) {
		/*
		 * We can just die here, because if this fails then the
		 * network has died and we haven't got anyone to return
		 * errors to.
		 */
		exit(1);
	}
	laddr = sin.sin_addr;

	/*
	 * Open the connection to the Syslog daemon if requested
	 */
	if (syslog_flag) {
#ifdef LOG_DAEMON
		openlog("identd", LOG_PID, LOG_DAEMON);
#else
		openlog("identd", LOG_PID);
#endif
		syslog(LOG_NOTICE, "Connection from %s", gethost(&faddr));
	}
  
	/*
	 * Get the local/foreign port pair from the luser
	 */
	lport = fport = 0;
	if (scanf("%d , %d", &lport, &fport) != 2 ||
	    lport < 1 || lport > 65535 ||
 	    fport < 1 || fport > 65535) {
		if (syslog_flag)
			syslog(LOG_INFO, "scanf: invalid-port(s): %d, %d", lport, fport);

		printf("%d, %d: ERROR: INVALID-PORT\r\n", lport, fport);
		exit(0);
	}


	/*
	 * Next - get the specific TCP connection and return the uid
	 */
	uid = getinfo(&faddr, fport, &laddr, lport);
	if (uid<0) {
		if (syslog_flag && debug_flag)
			syslog(LOG_INFO, "Returned: %d, %d: NO-USER", lport, fport);

		printf("%d, %d: ERROR: NO-USER\r\n", lport, fport);
		exit(0);
	}

	/*
	 * Then we should try to get the username
	 */
	pwp = getpwuid(uid);
	if (!pwp) {
		if (syslog_flag)
			syslog(LOG_WARNING, "getpwuid() could not map uid (%d) to name", uid);

		printf("%d, %d: ERROR: UNKNOWN-ERROR\r\n", lport, fport);
		exit(1);
	}

	/*
	 * Hey! We finally made it!!!
	 */
	if (syslog_flag && debug_flag)
		syslog(LOG_INFO, "Successful lookup: %d, %d: %s\n", lport, fport, pwp->pw_name);

	printf("%d, %d: USERID: UNIX: %s\r\n", lport, fport, pwp->pw_name);
	exit(0);
}
