/*
 * vsprintf.c  -  Print into a string buffer using variadic args
 *
 * Copyright (C) 2006-2007 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  Parts of this file have been taken from the GNU libiberty library,
 *  and the original file carries the following copyright:
 *
 *      Written by Per Bothner of Cygnus Support.
 *      Based on libg++'s "form" (written by Doug Lea; dl@rocky.oswego.edu).
 *      Copyright (C) 1991, 1995 Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: vsprintf.c,v 1.3 2007/01/06 18:31:39 gkminix Exp $
 */

#include <common.h>
#include <nblib.h>



/*
 * Define _doprnt to as an external routine
 */
extern int _doprnt();



/*
 * Print a string using variadic arguments
 *
 * This routine uses _doprnt, which is defined in almost all
 * classical runtime libraries. Newer libraries should have
 * vfprintf anyway.
 */
#ifndef HAVE_VSPRINTF
int nbvsprintf __F((buf, format, ap),
				char *buf AND
				const char *format AND
				va_list ap)
{
  FILE b;
  int ret;

#ifdef VMS
  b->_flag = _IOWRT|_IOSTRG;
  b->_ptr = buf;
  b->_cnt = 12000;
#else
  b._flag = _IOWRT|_IOSTRG;
  b._ptr = buf;
  b._cnt = 12000;
#endif

  ret = _doprnt(format, ap, &b);
  putc('\0', &b);
  return(ret);

}
#endif

