/*
 * vfprintf.c  -  Print into a file using variadic args
 *
 * Copyright (C) 2003-2007 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  Parts of this file have been taken from the GNU libiberty library,
 *  and the original file carries the following copyright:
 *
 *	Provide a version vfprintf in terms of _doprnt.
 *	By Kaveh Ghazi  (ghazi@caip.rutgers.edu)  3/29/98
 *	Copyright (C) 1998 Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: vfprintf.c,v 1.9 2007/01/06 18:31:39 gkminix Exp $
 */

#include <common.h>
#include <nblib.h>



/*
 * Define _doprnt to as an external routine
 */
extern int _doprnt();



/*
 * Print a string using variadic arguments
 *
 * This routine uses _doprnt, which is defined in almost all
 * classical runtime libraries. Newer libraries should have
 * vfprintf anyway.
 */
#ifndef HAVE_VFPRINTF
int nbvfprintf __F((stream, format, ap),
				FILE *stream AND
				const char *format AND
				va_list ap)
{
  return(_doprnt(format, ap, stream));
}
#endif

