/*
 * strncmp.c  -  String handling which should be in the standard library
 *
 * Copyright (C) 2003-2007 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: strncmp.c,v 1.8 2007/01/06 18:31:39 gkminix Exp $
 */

#include <common.h>
#include <nblib.h>
#include "privlib.h"



/*
 * Compare two strings with a maximum length
 */
int nbstrncmp __F((s1, s2, n),
			const char *s1 AND
			const char *s2 AND
			size_t n)
{
  register unsigned char u1, u2;

  while (n-- > 0) {
	u1 = (unsigned char)*s1++;
	u2 = (unsigned char)*s2++;
	if (u1 != u2)
		return(u1 - u2);
	if (u1 == '\0')
		return(0);
  }
  return(0);
}

