/*
 * privlib.h  -  Header file with declarations private to netboot library
 *
 * Copyright (C) 1998-2007 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: privlib.h,v 1.19 2007/01/06 18:31:38 gkminix Exp $
 */

#ifndef PRIVLIB_H
#define PRIVLIB_H



/*
 * Variables shared between library modules
 */
extern char *configname;	/* name of configuration file */
extern char *nblogname;		/* name of logging file */
extern char *nblibdir;		/* netboot non-shared data directory */
extern char *nbdatadir;		/* netboot shared data directory */
extern char *nbhomedir;		/* netboot home directory */
extern char *nbtempdir;		/* temporary files directory */
extern char *sysdbname;		/* system database name */
extern char *userhomedir;	/* user home directory */
extern char *nblocale;		/* current locale name */
extern char *nbcharname;	/* current character set name */
extern char *nberrmsg;		/* last error message */
extern int   nberrnum;		/* last error number */
extern int   nbcharset;		/* character set definition */



/*
 * Section definitions for database module
 */
extern struct sectdef dbsects[];



/*
 * Global variables of the signal handling module
 */
extern volatile int nblib_sigchld;	/* number of SIGCHLD signals */



/*
 * Routines shared between library modules
 */
extern struct cmdopt *nblib_find_opt __P((const voidstar param));
extern int nblib_readconfig __P((const struct sectdef *sects, const char *fname));
extern void nblib_parse_opt __P((int argc, char **argv, struct cmdopt *opts));
extern void nblib_init_log __P((void));
extern void nblib_init_signal __P((void));
extern void nblib_restore_signal __P((void));
extern void nblib_exit_cleanup __P((void));

#endif

