/*
 * parsefile.h  -  Header file for text file parsing routines
 *
 * Copyright (C) 2003-2007 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: parsefile.h,v 1.7 2007/01/06 18:31:38 gkminix Exp $
 */

#ifndef PARSEFILE_H
#define PARSEFILE_H


/*
 * Parser status values
 */
#define PARSESTATUS_SUCCESS	0		/* successful operation */
#define PARSESTATUS_READERR	1		/* error reading from file */
#define PARSESTATUS_SYNTAXERR	2		/* syntax error */



/*
 * We need the definition of database items here
 */
#include "privdb.h"



/*
 * List of file names to specify an item location
 */
struct parseloc {
	char             *fname;	/* file name */
	struct parseloc  *next;
};



/*
 * Definition of item meta-data. The item data itself is contained
 * in a dbitem structure list.
 */
struct parseitem {
	int               lineno;	/* line number of item */
	struct parseloc  *loc;		/* item file location */
	struct dbitem    *data;		/* item data */
	struct parseitem *next;
};



/*
 * Structure holding one parser record
 */
struct parserec {
	int               lineno;	/* current line number */
	struct parseloc  *loc;		/* item file location */
	char             *name;		/* name of record */
	int               itemnum;	/* number of items */
	struct dbitem    *datalist;	/* list of item data */
	struct dbitem    *datalast;	/* last data item */
	struct parseitem *parselist;	/* list of item meta-data */
	struct parseitem *parselast;	/* last meta-data item */
	struct parserec  *next;
};



/*
 * Definition for reading one complete file
 */
struct parseinfo {
	struct parserec  *reclist;	/* List of records */
	struct parseloc  *loclist;	/* List of file names */
};



/*
 * Global error code
 */
extern int nblib_parse_error;



/*
 * Error handling routine for syntax errors
 */
typedef void (*parseerr) __P((const char *msg, const char *fname, int lineno));



/*
 * Text file parser routines
 */
extern struct parseinfo *nblib_parse_file
			__P((FILE *fd, const char *fname, parseerr doerr));

extern void nblib_parse_free __P((struct parseinfo *info));

#endif

