/*
 * memmove.c  -  String handling which should be in the standard library
 *
 * Copyright (C) 2003-2007 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: memmove.c,v 1.7 2007/01/06 18:31:38 gkminix Exp $
 */

#include <common.h>
#include <nblib.h>
#include "privlib.h"



/*
 * Handle overlapping memory copies.
 */
voidstar memmove __F((dest, src, len),
			voidstar dest AND
			const voidstar src AND
			size_t len)
{
  voidstar srcend = (voidstar)((__u8 *)src + len);
  voidstar destend = (voidstar)((__u8 *)dest + len);
  voidstar buf;

  if ((src > dest && src < destend) ||
      (dest > src && dest < srcend)) {
	buf = (voidstar)nbmalloc(len);
	memcpy(buf, src, len);
	memcpy(dest, buf, len);
	free(buf);
  } else if (src != dest) {
	memcpy(dest, src, len);
  }
  return(dest);
}

