/*
 * memcpy.c  -  String handling which should be in the standard library
 *
 * Copyright (C) 2003-2007 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: memcpy.c,v 1.8 2007/01/06 18:31:38 gkminix Exp $
 */

#include <common.h>
#include <nblib.h>
#include "privlib.h"



/*
 * Handle simple memory copies
 */
void nbmemcpy __F((dest, src, len),
			voidstar dest AND
			const voidstar src AND
			size_t len)
{
  if (dest < src) {
	register __u8 *firsts = (__u8 *)src;
	register __u8 *firstd = (__u8 *)dest;

	while (len--)
		*firstd++ = *firsts++;
  } else {
	register __u8 *lasts = (__u8 *)src + len - 1;
	register __u8 *lastd = (__u8 *)dest + len - 1;

	while (len--)
		*lastd-- = *lasts--;
  }
}

