/*
 * memcmp.c  -  String handling which should be in the standard library
 *
 * Copyright (C) 2003-2007 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: memcmp.c,v 1.8 2007/01/06 18:31:38 gkminix Exp $
 */

#include <common.h>
#include <nblib.h>
#include "privlib.h"



/*
 * Compare two memory areas
 */
int nbmemcmp __F((m1, m2, len),
			const voidstar m1 AND
			const voidstar m2 AND
			size_t len)
{
  register const __u8 *s1 = (const __u8 *)m1;
  register const __u8 *s2 = (const __u8 *)m2;

  while (len-- > 0) {
	if (*s1++ != *s2++)
		return(s1[-1] < s2[-1] ? -1 : 1);
  }
  return(0);
}

