/*
 * filetime.c  -  Determine access time of file
 *
 * Copyright (C) 2002-2007 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: filetime.c,v 1.9 2007/01/06 18:31:38 gkminix Exp $
 */

#include <common.h>
#include <nblib.h>
#include "privlib.h"



/*
 * Determine access time of file
 */
time_t filetime __F((name, timetype), const char *name AND int timetype)
{
  struct stat sbuf;

  if (stat(name, &sbuf) != 0) {
	nberror(EXIT_STAT, "unable to stat file %s", name);
	return((time_t)(-1));
  }
  if (timetype == FT_CTIME)
	return(sbuf.st_ctime);
  else if (timetype == FT_MTIME)
	return(sbuf.st_mtime);
  else
	return(sbuf.st_atime);
}

