/*
 * mknbi.h  -  Definitions for the MGL compiler
 *
 * Copyright (C) 1997-2007 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mknbi.h,v 1.14 2007/01/06 18:31:28 gkminix Exp $
 */


#ifndef MKNBI_H_MGL
#define MKNBI_H_MGL


/*
 * We need internet header files almost everywhere, so include them here
 */
#include <common.h>
#ifdef HAVE_INET
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#define IPADDR_SIZE	sizeof(struct in_addr)
#else
#define IPADDR_SIZE	4
#endif
#include <nblib.h>



/*
 * Name of systems database section
 */
#define DBSECTNAME	"mknbi-mgl"



/*
 * The following structures have to be packed.
 */
#define PACK_ENABLED
#ifdef USE_PRAGMA_PACK
#pragma pack(1)
#endif
#ifdef USE_PRAGMA_ALIGN
#pragma options align=packed
#endif



/*
 * Load the primary boot loader definitions. This also loads the netboot
 * specification definitions.
 */
#include "first/first.i86"



/*
 * Size of one copy block
 */
#define SECTSIZE 512



/*
 * Maximum number of compiler errors
 */
#define MAXERRS	32



/*
 * The bootrom loads the load header to 0x30000, the initial loader at
 * 0x31000 and the compiled program to 0x40000.
 */
#define DEF_HEADERSEG	0x03000L	/* segment for boot image header */

#define DEF_BOOTLSEG	0x03100L	/* segment for boot image loader */
#define BOOTLLSIZE	65024L		/* maximum load size for loader */
#define BOOTLMSIZE	65024L		/* maximum memory size for loader */

#define DEF_PROGSEG	0x04000L	/* segment for MGL executable program */
#define PROGLSIZE	131072L		/* maximum load size of MGL program */
#define PROGMSIZE	131072L		/* maximum memory size of MGL program */



/*
 * Turnoff structure packing and return to normal data alignment.
 */
#ifdef USE_PRAGMA_PACK
#pragma pack()
#endif
#ifdef USE_PRAGMA_ALIGN
#pragma options align=reset
#endif



/*
 * Types of output file
 */
#define OUTPUT_USER	-1		/* User provided runtime loader */
#define OUTPUT_PLAIN	 0		/* Plain MGL binary */
#define OUTPUT_NETBOOT	 1		/* Netboot runtime loader */
#define OUTPUT_PXE	 2		/* PXE runtime loader */
#define OUTPUT_DOS	 3		/* DOS runtime loader */

#define OUTPUT_DEFAULT	OUTPUT_NETBOOT	/* Default output type */



/*
 * Definition of data area which contains command line parameters or
 * the parameters specified in a systems database entry.
 */
struct sysdef {
	char          *outname;		/* Name of output file */
	char          *mglname;		/* Name of mgl source file */
	char          *rtname;		/* Name of runtime file */
	char          *ldname;		/* Name of loader file */
	char          *incpath;		/* Include file path */
	int            outtype;		/* Type of output file */
};



/*
 * Global variables
 */
extern int debug;			/* include debugging information */
extern int maxerrors;			/* maximum number of errors */
extern int printsizes;			/* print size values */



/*
 * Global routines
 */
extern char *getouttype __P((char *typestr, struct sysdef *sysentry));
extern void getdb __P((const char *name, struct sysdef *sysentry));
extern void putdb __P((const char *name, struct sysdef *sysentry,
							const char *definc));



/*
 * Data area which contains the boot loader module
 */
extern __u8 first_nb_data[];
extern unsigned int first_nb_data_size;
extern __u8 first_pxe_data[];
extern unsigned int first_pxe_data_size;
extern __u8 first_dos_data[];
extern unsigned int first_dos_data_size;


#endif

