/* A lexical scanner generated by flex */

/* Scanner skeleton version:
 * $Header: /home/daffy/u0/vern/flex/RCS/flex.skl,v 2.91 96/09/10 16:58:48 vern Exp $
 */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5

#include <stdio.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#include <unistd.h>

/* Use prototypes in function declarations. */
#define YY_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define YY_USE_CONST
#define YY_USE_PROTOS
#endif

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define YY_BUF_SIZE 16384

typedef struct yy_buffer_state *YY_BUFFER_STATE;

extern int yyleng;
extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		yyless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the yyless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		*yy_cp = yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yy_c_buf_p = yy_cp = yy_bp + n - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yytext_ptr )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int yy_size_t;


struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2
	};

static YY_BUFFER_STATE yy_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */


int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart YY_PROTO(( FILE *input_file ));

void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));
void yy_flush_buffer YY_PROTO(( YY_BUFFER_STATE b ));
#define YY_FLUSH_BUFFER yy_flush_buffer( yy_current_buffer )

YY_BUFFER_STATE yy_scan_buffer YY_PROTO(( char *base, yy_size_t size ));
YY_BUFFER_STATE yy_scan_string YY_PROTO(( yyconst char *yy_str ));
YY_BUFFER_STATE yy_scan_bytes YY_PROTO(( yyconst char *bytes, int len ));

static void *yy_flex_alloc YY_PROTO(( yy_size_t ));
static void *yy_flex_realloc YY_PROTO(( void *, yy_size_t ));
static void yy_flex_free YY_PROTO(( void * ));

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (yy_current_buffer->yy_at_bol)

typedef unsigned char YY_CHAR;
FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;
typedef int yy_state_type;
extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state YY_PROTO(( void ));
static yy_state_type yy_try_NUL_trans YY_PROTO(( yy_state_type current_state ));
static int yy_get_next_buffer YY_PROTO(( void ));
static void yy_fatal_error YY_PROTO(( yyconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 68
#define YY_END_OF_BUFFER 69
static yyconst short int yy_accept[188] =
    {   0,
        0,    0,   69,   67,    1,   64,   63,    8,   67,   67,
       60,    9,   67,   57,   56,   55,   67,   58,    6,   67,
       52,   49,   50,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,    4,    1,   10,    7,    3,   65,    6,
       66,   44,    2,    0,    6,   43,   53,   54,   51,   62,
       62,   62,   12,   62,   62,   62,   62,   17,   62,   62,
       62,   62,   62,   62,   25,   62,   62,   62,   62,   28,
       47,   62,   62,   62,   36,   62,   62,   62,   62,   62,
       62,   62,    2,    0,   45,   62,   62,   62,   62,   62,

       59,   62,   62,   20,   62,   22,   62,   62,   62,   61,
       27,   46,   62,   62,   62,   62,   62,   62,   37,   62,
       62,   40,   62,   62,   48,    0,   62,   62,   62,   62,
       62,   62,   19,   62,   62,   24,   62,   62,   62,   62,
       62,   62,   62,   35,   38,   62,   62,   42,    0,   11,
       13,   14,   15,   62,   62,   62,   62,   26,   62,   62,
       62,   62,   62,   62,   39,   41,    0,   62,   18,   21,
       62,   62,   62,   31,   32,   62,   34,    5,   16,   62,
       62,   30,   33,   23,   62,   29,    0
    } ;

static yyconst int yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    5,    6,    7,    8,    1,    9,   10,
       11,   12,   13,    1,   14,   15,   16,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   18,    1,   19,
       20,   21,    1,    1,   22,   22,   22,   22,   22,   22,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
        1,    1,    1,    1,   23,    1,   24,   25,   26,   27,

       28,   29,   30,   31,   32,   23,   33,   34,   35,   36,
       37,   38,   23,   39,   40,   41,   42,   43,   44,   45,
       46,   23,   47,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst int yy_meta[48] =
    {   0,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    3,    1,    1,    1,
        1,    3,    4,    3,    3,    3,    3,    3,    3,    4,
        4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    4,    4,    4,    1
    } ;

static yyconst short int yy_base[191] =
    {   0,
        0,    0,  202,  203,  199,  203,  203,  203,  183,    0,
      203,  203,   36,  203,  182,  181,   38,  181,   35,  176,
       34,  203,  175,    0,   20,   29,  157,   26,   26,   27,
      156,  163,  167,  153,   37,   37,  150,  160,   36,  151,
      162,   46,  148,  203,  182,  166,    0,  203,  203,  165,
      203,  203,    0,  164,   55,  203,  203,  203,  203,    0,
      153,  140,    0,  148,  149,  140,   40,  131,  134,  146,
      146,  132,  134,  128,    0,  143,  140,  122,  124,    0,
        0,  127,   53,  135,    0,  116,  123,  119,  120,  126,
      116,  117,    0,   69,    0,  131,  122,  129,  112,  113,

        0,  114,  121,    0,  120,    0,  121,  109,  117,    0,
        0,    0,   55,  107,  115,  101,   99,  104,    0,  111,
      106,    0,  103,  105,    0,  118,   88,   97,   99,   90,
       93,   88,    0,   90,   86,    0,   92,   97,   85,   84,
       98,   97,   81,    0,    0,   85,   90,    0,   72,    0,
        0,    0,    0,   77,   79,   74,   82,    0,   86,   88,
       84,   69,   70,   72,    0,    0,   90,   78,    0,    0,
       68,   62,   68,    0,    0,   61,    0,   84,    0,   62,
       53,    0,    0,    0,   62,    0,  203,   85,   92,   96
    } ;

static yyconst short int yy_def[191] =
    {   0,
      187,    1,  187,  187,  187,  187,  187,  187,  187,  188,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  189,  189,  189,  189,  189,  189,  189,
      189,  189,  189,  189,  189,  189,  189,  189,  189,  189,
      189,  189,  189,  187,  187,  187,  188,  187,  187,  187,
      187,  187,  190,  187,  187,  187,  187,  187,  187,  189,
      189,  189,  189,  189,  189,  189,  189,  189,  189,  189,
      189,  189,  189,  189,  189,  189,  189,  189,  189,  189,
      189,  189,  189,  189,  189,  189,  189,  189,  189,  189,
      189,  189,  190,  187,  189,  189,  189,  189,  189,  189,

      189,  189,  189,  189,  189,  189,  189,  189,  189,  189,
      189,  189,  189,  189,  189,  189,  189,  189,  189,  189,
      189,  189,  189,  189,  189,  187,  189,  189,  189,  189,
      189,  189,  189,  189,  189,  189,  189,  189,  189,  189,
      189,  189,  189,  189,  189,  189,  189,  189,  187,  189,
      189,  189,  189,  189,  189,  189,  189,  189,  189,  189,
      189,  189,  189,  189,  189,  189,  187,  189,  189,  189,
      189,  189,  189,  189,  189,  189,  189,  187,  189,  189,
      189,  189,  189,  189,  189,  189,    0,  187,  187,  187
    } ;

static yyconst short int yy_nxt[251] =
    {   0,
        4,    5,    6,    7,    8,    9,   10,   11,   12,   13,
        4,   14,   15,   16,   17,   18,   19,   20,   21,   22,
       23,   24,   24,   25,   26,   27,   28,   29,   30,   31,
       24,   32,   24,   33,   34,   35,   36,   37,   38,   24,
       39,   40,   41,   42,   43,   24,   44,   48,   51,   54,
       49,   55,   52,   57,   58,   61,   64,   67,   62,   69,
       63,   70,   68,   72,   78,   80,   84,   65,   73,   54,
       71,   55,   85,   79,   86,   81,   90,   91,  114,  100,
      138,   87,  101,  126,  139,   94,  167,   47,  149,  186,
      115,  185,  116,  117,   60,   60,   93,  184,   93,   93,

      178,  183,  182,  181,  180,  179,  178,  177,  176,  175,
      174,  173,  172,  171,  170,  169,  168,  166,  165,  164,
      163,  162,  161,  160,  159,  158,  157,  156,  155,  154,
      153,  152,  151,  150,  149,  148,  147,  146,  145,  144,
      143,  142,  141,  140,  137,  136,  135,  134,  133,  132,
      131,  130,  129,  128,  127,  125,  124,  123,  122,  121,
      120,  119,  118,  113,  112,  111,  110,  109,  108,  107,
      106,  105,  104,  103,  102,   99,   98,   97,   96,   95,
       94,   50,   46,   45,   92,   89,   88,   83,   82,   77,
       76,   75,   74,   66,   59,   56,   53,   50,   50,   46,

       45,  187,    3,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187
    } ;

static yyconst short int yy_chk[251] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,   13,   17,   19,
       13,   19,   17,   21,   21,   25,   26,   28,   25,   29,
       25,   29,   28,   30,   35,   36,   39,   26,   30,   55,
       29,   55,   39,   35,   39,   36,   42,   42,   83,   67,
      113,   39,   67,   94,  113,   94,  149,  188,  149,  185,
       83,  181,   83,   83,  189,  189,  190,  180,  190,  190,

      178,  176,  173,  172,  171,  168,  167,  164,  163,  162,
      161,  160,  159,  157,  156,  155,  154,  147,  146,  143,
      142,  141,  140,  139,  138,  137,  135,  134,  132,  131,
      130,  129,  128,  127,  126,  124,  123,  121,  120,  118,
      117,  116,  115,  114,  109,  108,  107,  105,  103,  102,
      100,   99,   98,   97,   96,   92,   91,   90,   89,   88,
       87,   86,   84,   82,   79,   78,   77,   76,   74,   73,
       72,   71,   70,   69,   68,   66,   65,   64,   62,   61,
       54,   50,   46,   45,   43,   41,   40,   38,   37,   34,
       33,   32,   31,   27,   23,   20,   18,   16,   15,    9,

        5,    3,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "mgllex.l"
#define INITIAL 0
#line 2 "mgllex.l"
/*
 * mgllex.l  -  Lexer for Bootrom Menu Generation Language
 *
 * Copyright (C) 1997-2007 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mgllex.l,v 1.13 2005/11/13 20:14:30 gkminix Exp $
 */

#include "mknbi.h"
#include "mgl.h"
#include "gencode.h"
#include "headers/runtime.h"
#ifndef _DEPEND_
# include "y.tab.h"
#endif



/*
 ********************************************************************
 *
 * Some lex implementations (notably AT&T) have a very small limit
 * on buffer and line size. We increase those values here to at
 * least 512 characters. flex has a buffer size of 8192 characters
 * which should be enough, so we don't need to change anything in
 * that case.
 */
#ifdef YYLMAX
# if YYLMAX < 512
#  undef YYLMAX
#  define YYLMAX 512
# endif
#else
# define YYLMAX 512
#endif

#ifndef YY_BUF_SIZE
# define YY_BUF_SIZE 8192
#endif



/*
 ********************************************************************
 *
 * Adjust Flex error output to our own format. Also we don't need
 * yyunput.
 */
#ifdef FLEX_SCANNER
# ifdef YY_FATAL_ERROR
#  undef YY_FATAL_ERROR
# endif
# define YY_FATAL_ERROR(msg)	lex_error(msg)
#endif



/*
 ********************************************************************
 *
 * If yywrap() is a macro, undefine it here, because we use our own
 * routine.
 */
#ifdef yywrap
# undef yywrap
#endif



/*
 ********************************************************************
 *
 * Making it possible to include another source file into the current
 * source is a nightmare because of the various different ways such
 * a feature is implemented in different lex versions. We only support
 * two ways:
 *
 *	1.)  If input() and unput() are macros, we can redefine them.
 *	     This is the way most AT&T lex versions handle it. However,
 *	     there exist some lex versions which don't define these
 *	     routines as macros, sigh.
 *	2.)  Flex uses a complete different approach but provides all
 *	     necessary functions to handle file inclusion.
 *
 * In all other cases we are yet unable to support file inclusion.
 */
#ifdef FLEX_SCANNER
# define USE_INCLUDE 1
#else
# if defined(input) && defined(unput)
#  undef input
#  undef unput
#  define input mgl_input
#  define unput mgl_unput
#  define USE_MGL_INPUT 1
#  define USE_INCLUDE 1
# endif
#endif


/* Structure holding all values for one input file */
#ifdef USE_INCLUDE
struct input_file {
	char              *fname;	/* file name */
	FILE              *infile;	/* input file descriptor */
# ifdef FLEX_SCANNER
	YY_BUFFER_STATE    inbuf;	/* input file buffer */
# else
	char              *inbuf;	/* input file buffer */
	int                insize;	/* size of input buffer */
	int                inpos;	/* current reading position */
# endif
	int                lineno;	/* current input line number */
	struct input_file *next;	/* next input file structure */
};

static struct input_file *curinput = NULL;
#else
# ifdef USE_MGL_INPUT
static int unput_char = 0;
# endif
#endif



/*
 ********************************************************************
 *
 * Definition of builtin data types
 */

/* No type - used to catch errors in type definitions */
struct typesdef none_type = {
	EXPR_NONE,   0, { { 0, 0, -1 } },		NULL
};

/* Any type - used for arguments to runtime functions */
struct typesdef any_type = {
	EXPR_ANY,   0, { { 0, 0, -1 } },		&none_type
};

/* Integer type */
struct typesdef int_type = {
	EXPR_NUM,    2, { { -MAX_INT, MAX_INT, -1 } },	&any_type
};

/* Pointer type */
struct typesdef pointer_type = {
	EXPR_POINTER, 2, { { 0, 0, -1 } }, &int_type
};

/* String type */
struct typesdef string_type = {
	EXPR_STRING, MAX_STR_LEN+1, { { 0, 0, -1 } },	&pointer_type
};

/* Type for string index */
struct typesdef strindex_type = {
	EXPR_NUM,    2, { { 0, MAX_STR_LEN, -1 } },	&string_type
};

/* Type for string length */
struct typesdef strlength_type = {
	EXPR_NUM,    1, { { 0, 255, -1 } },		&strindex_type
};

/* Character type */
struct typesdef char_type = {
	EXPR_CHAR,   1, { { 0, MAX_CHAR, -1 } },	&strlength_type
};

/* Boolean type */
struct typesdef bool_type = {
	EXPR_BOOL,   1, { { 0, 1, -1 } },		&char_type
};

/* IP address type */
struct typesdef ipaddr_type = {
	EXPR_IPADDR, IPADDR_SIZE, { { 0, 0, -1 } },	&bool_type
};


/* Define the start of the types list */
#define TYPES_START	(&ipaddr_type)



/*
 ********************************************************************
 *
 * Define some special "function" names, which return a token back
 * to the parser instead of a symbol ID. This is necessary because
 * these "functions" do have a special syntax.
 */
static struct {
	char *name;
	int   token;
} specialtab[] = {
	{ "get",	GET     },
	{ "load",	LOAD    },
	{ "print",	PRINT   },
	{ "select",	SELECT	},
	{ "raise",	RAISE	},
	{ NULL,         0       }
};



/*
 ********************************************************************
 *
 * Global variables
 */
char *curfile;			/* Name of current input file */
int lineno;			/* Current line number */



/*
 ********************************************************************
 *
 * Local variables
 */
static pcchar_t string_buf[MAX_STR_LEN + 1];	/* string buffer */
static int string_flag;				/* flag if string too long */
static int cstring = TRUE;			/* C-style string flag */
static int nobuiltin = FALSE;			/* dont't allow builtins */
static char *lexincpath = NULL;			/* include file path */



/*
 ********************************************************************
 *
 * Forward declarations of functions and routines
 */
static void do_string __P((char quote));
static void do_comment __P((int brace_flag));
static int yywrap __P((void));

#ifdef USE_MGL_INPUT
static int mgl_input __P((void));
static void mgl_unput __P((int c));
#endif

#ifdef FLEX_SCANNER
static void lex_error __P((char *msg));
#endif
#line 269 "mgllex.l"
	/*
	 ********************************************************************
	 *
	 * Define some generally useful regular expressions
	 */
#line 745 "lex.yy.c"

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap YY_PROTO(( void ));
#else
extern int yywrap YY_PROTO(( void ));
#endif
#endif

#ifndef YY_NO_UNPUT
static void yyunput YY_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy YY_PROTO(( char *, yyconst char *, int ));
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen YY_PROTO(( yyconst char * ));
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif
#endif

#if YY_STACK_USED
static int yy_start_stack_ptr = 0;
static int yy_start_stack_depth = 0;
static int *yy_start_stack = 0;
#ifndef YY_NO_PUSH_STATE
static void yy_push_state YY_PROTO(( int new_state ));
#endif
#ifndef YY_NO_POP_STATE
static void yy_pop_state YY_PROTO(( void ));
#endif
#ifndef YY_NO_TOP_STATE
static int yy_top_state YY_PROTO(( void ));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( yy_current_buffer->yy_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else if ( ((result = fread( buf, 1, max_size, yyin )) == 0) \
		  && ferror( yyin ) ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );
#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL int yylex YY_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

YY_DECL
	{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;

#line 284 "mgllex.l"





	/*
	 ********************************************************************
	 *
	 * Skip all whitespace and comments. Many lex versions don't support
	 * exclusive start states, and also might have too small buffers, so
	 * we read a multiline comment using input().
	 */

#line 910 "lex.yy.c"

	if ( yy_init )
		{
		yy_init = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yy_start )
			yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! yy_current_buffer )
			yy_current_buffer =
				yy_create_buffer( yyin, YY_BUF_SIZE );

		yy_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start;
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				yy_last_accepting_state = yy_current_state;
				yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 188 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 203 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yy_hold_char;
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 297 "mgllex.l"
;
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 298 "mgllex.l"
;
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 300 "mgllex.l"
{ do_comment(FALSE); }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 301 "mgllex.l"
{ do_comment(TRUE); }
	YY_BREAK

	/*
	 ********************************************************************
	 *
	 * Parse an IP number
	 */

case 5:
YY_RULE_SETUP
#line 313 "mgllex.l"
{
		yylval.ipaddr = getinet(yytext, TRUE);
		return(IPADDR);
	}
	YY_BREAK

	/*
	 ********************************************************************
	 *
	 * Parse an integer number
	 */

case 6:
YY_RULE_SETUP
#line 327 "mgllex.l"
{
		/* Decimal number */

		char *cp;
		unsigned int result;
		int sign;

		/* Determine sign of number */
		if (yytext[0] == '+') {
			sign = 1;
			cp = &(yytext[1]);
		} else if (yytext[0] == '-') {
			sign = -1;
			cp = &(yytext[1]);
		} else {
			sign = 1;
			cp = &(yytext[0]);
		}

		/* Read absolute integer value */
		result = 0;
		while (*cp) {
			if (result >= ((MAX_INT + 1) / 10)) {
				warning("integer number too large, assuming maximum");
				result = MAX_INT;
				break;
			}
			result = result * 10 + *cp - '0';
			cp++;
		}
		yylval.intarg = (int)result * sign;
		return(NUM);
	}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 362 "mgllex.l"
{
		/* Hex number */

		char *cp;
		unsigned int result = 0;

		for (cp = yytext; *cp; cp++) {
			if (result >= (MAX_INT / 10)) {
				warning("integer number too large, assuming maximum");
				result = MAX_INT;
				break;
			}
			if (*cp >= '0' && *cp <= '9')
				result = result * 16 + *cp - '0';
			else if (*cp >= 'a' && *cp <= 'f')
				result = result * 16 + *cp + 10 - 'a';
			else if (*cp >= 'A' && *cp <= 'F')
				result = result * 16 + *cp + 10 - 'F';
		}
		yylval.intarg = result;
		return(NUM);
	}
	YY_BREAK

	/*
	 ********************************************************************
	 *
	 * Parse a string or character constant
	 */

case 8:
YY_RULE_SETUP
#line 394 "mgllex.l"
{
		/* Parse string constant if using C-style strings */
		if (cstring) {
			do_string(yytext[0]);
			yylval.string = copy_string(string_buf);
			return(QSTRING);
		}

		/* For Pascal-style strings, the double-quote has no meaning */
		return(yytext[0]);
	}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 407 "mgllex.l"
{
		/* Parse string constant */
		do_string(yytext[0]);

		/* Character constant if using C-style */
		if (cstring) {
			if (string_buf[0] != 1) {
				error("invalid character constant", FALSE);
				yylval.chrarg = 0;
			} else
				yylval.chrarg = string_buf[1];
			return(CHR);
		}

		/* For Pascal-style a character constant is a one-char string */
		if (string_buf[0] == 1) {
			yylval.chrarg = string_buf[1];
			return(CHR);
		}
		yylval.string = copy_string(string_buf);
		return(QSTRING);
	}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 430 "mgllex.l"
{
		/* Parse a pascal-style character constant */

		char *cp;
		unsigned int result = 0;

		for (cp = &yytext[1]; *cp; cp++) {
			if (result >= ((MAX_CHAR + 1) / 10)) {
				warning("character constant out of range");
				result = MAX_CHAR;
				break;
			}
			result = result * 10 + *cp - '0';
		}
		yylval.chrarg = result;
		return(CHR);
	}
	YY_BREAK

	/*
	 ********************************************************************
	 *
	 * Rules to parse reserved names
	 */

case 11:
YY_RULE_SETUP
#line 457 "mgllex.l"
{ return(ARRAY); }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 458 "mgllex.l"
{ return(AT); }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 459 "mgllex.l"
{ return(CBEGIN); }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 460 "mgllex.l"
{ return(BREAK); }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 461 "mgllex.l"
{ return(CONST); }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 462 "mgllex.l"
{ return(DISPOSE); }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 463 "mgllex.l"
{ return(DO); }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 464 "mgllex.l"
{ return(DOWNTO); }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 465 "mgllex.l"
{ return(ELSE); }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 466 "mgllex.l"
{ return(END); }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 467 "mgllex.l"
{ return(EXCEPT); }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 468 "mgllex.l"
{ return(FOR); }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 469 "mgllex.l"
{ return(FUNCTION); }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 470 "mgllex.l"
{ return(GOTO); }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 471 "mgllex.l"
{ return(IF); }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 472 "mgllex.l"
{ return(LABEL); }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 473 "mgllex.l"
{ return(NEW); }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 474 "mgllex.l"
{ return(OF); }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 475 "mgllex.l"
{ return(PROCEDURE); }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 476 "mgllex.l"
{ return(PROGRAM); }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 477 "mgllex.l"
{ return(RECORD); }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 478 "mgllex.l"
{ return(REPEAT); }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 479 "mgllex.l"
{ return(RESTART); }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 480 "mgllex.l"
{ return(RETURN); }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 481 "mgllex.l"
{ return(THEN); }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 482 "mgllex.l"
{ return(TO); }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 483 "mgllex.l"
{ return(TRY); }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 484 "mgllex.l"
{ return(TYPE); }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 485 "mgllex.l"
{ return(UNTIL); }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 486 "mgllex.l"
{ return(VAR); }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 487 "mgllex.l"
{ return(WHILE); }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 488 "mgllex.l"
{ return(WITH); }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 490 "mgllex.l"
{ return(ASSIGN); }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 491 "mgllex.l"
{ return(DOTS); }
	YY_BREAK

	/*
	 ********************************************************************
	 *
	 * Logical operations
	 */

case 45:
YY_RULE_SETUP
#line 502 "mgllex.l"
{ yylval.op = CMD_AND; return(ANDOP); }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 503 "mgllex.l"
{ yylval.op = CMD_NOT; return(NOTOP); }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 504 "mgllex.l"
{ yylval.op = CMD_OR;  return(OROP); }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 505 "mgllex.l"
{ yylval.op = CMD_XOR; return(OROP); }
	YY_BREAK

	/*
	 ********************************************************************
	 *
	 * Comparison rules
	 */

case 49:
YY_RULE_SETUP
#line 516 "mgllex.l"
{ yylval.op = CMD_EQ; return(COMPARISON); }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 517 "mgllex.l"
{ yylval.op = CMD_GT; return(COMPARISON); }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 518 "mgllex.l"
{ yylval.op = CMD_GE; return(COMPARISON); }
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 519 "mgllex.l"
{ yylval.op = CMD_LT; return(COMPARISON); }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 520 "mgllex.l"
{ yylval.op = CMD_LE; return(COMPARISON); }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 521 "mgllex.l"
{ yylval.op = CMD_NE; return(COMPARISON); }
	YY_BREAK

	/*
	 ********************************************************************
	 *
	 * Arithmetic operations
	 */

case 55:
YY_RULE_SETUP
#line 532 "mgllex.l"
{ yylval.op = '-'; return(ADDOP); }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 533 "mgllex.l"
{ yylval.op = '+'; return(ADDOP); }
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 534 "mgllex.l"
{ yylval.op = '*'; return(MULOP); }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 535 "mgllex.l"
{ yylval.op = '/'; return(MULOP); }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 536 "mgllex.l"
{ yylval.op = '/'; return(MULOP); }
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 537 "mgllex.l"
{ yylval.op = '%'; return(MULOP); }
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 538 "mgllex.l"
{ yylval.op = '%'; return(MULOP); }
	YY_BREAK

	/*
	 ********************************************************************
	 *
	 * Symbol names
	 */

case 62:
YY_RULE_SETUP
#line 549 "mgllex.l"
{
		/* Check if we have to find a builtin symbol */
		if (!nobuiltin && !strncmp(yytext, "__builtin_", 10)) {
			yylval.symbol = NULL;
			if (yytext[10] != '\0')
				yylval.symbol = findsym(&yytext[10], SYMBOL_RTREF);
			if (yylval.symbol == NULL) {
				/*
				 * In case a builtin symbol could not be found,
				 * we generate a dummy symbol to be able to
				 * countinue the parsing process.
				 */
				error("invalid builtin symbol", TRUE);
				yylval.symbol = addsym(yytext, SYMBOL_NOREF);
			}
			return(ID);
		}

		/* Find symbol and check if it's special */
		yylval.symbol = findsym(yytext, SYMBOL_ANYREF);
		if (isspecialsym(yylval.symbol))
			return(yylval.symbol->def.s.token);

		/* If symbol doesn't exist, create it. */
		if (yylval.symbol == NULL)
			yylval.symbol = addsym(yytext, SYMBOL_NOREF);

		/* Return the symbol to the parser */
		return(ID);
	}
	YY_BREAK

	/*
	 ********************************************************************
	 *
	 * Misc. rules: count lines and ignore \r, return all other
	 * characters as-is to the parser.
	 */

case 63:
YY_RULE_SETUP
#line 590 "mgllex.l"
;
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 591 "mgllex.l"
{ lineno++; }
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 592 "mgllex.l"
{ return('['); }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 593 "mgllex.l"
{ return(']'); }
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 594 "mgllex.l"
{ return(yytext[0]); }
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 596 "mgllex.l"
ECHO;
	YY_BREAK
#line 1529 "lex.yy.c"
case YY_STATE_EOF(INITIAL):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between yy_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yy_n_chars = yy_current_buffer->yy_n_chars;
			yy_current_buffer->yy_input_file = yyin;
			yy_current_buffer->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yy_c_buf_p = yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yy_did_buffer_switch_on_eof = 0;

				if ( yywrap() )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yy_c_buf_p = yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yy_c_buf_p =
					yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yy_c_buf_p =
				&yy_current_buffer->yy_ch_buf[yy_n_chars];

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of yylex */


/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int yy_get_next_buffer()
	{
	register char *dest = yy_current_buffer->yy_ch_buf;
	register char *source = yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( yy_current_buffer->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yy_c_buf_p - yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yy_c_buf_p - yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		yy_current_buffer->yy_n_chars = yy_n_chars = 0;

	else
		{
		int num_to_read =
			yy_current_buffer->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = yy_current_buffer;

			int yy_c_buf_p_offset =
				(int) (yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yy_flex_realloc( (void *) b->yy_ch_buf,
							 b->yy_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = yy_current_buffer->yy_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
			yy_n_chars, num_to_read );

		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	if ( yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			yy_current_buffer->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	yy_n_chars += number_to_move;
	yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yytext_ptr = &yy_current_buffer->yy_ch_buf[0];

	return ret_val;
	}


/* yy_get_previous_state - get the state just before the EOB char was reached */

static yy_state_type yy_get_previous_state()
	{
	register yy_state_type yy_current_state;
	register char *yy_cp;

	yy_current_state = yy_start;

	for ( yy_cp = yytext_ptr + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yy_last_accepting_state = yy_current_state;
			yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 188 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
	}


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static yy_state_type yy_try_NUL_trans( yy_state_type yy_current_state )
#else
static yy_state_type yy_try_NUL_trans( yy_current_state )
yy_state_type yy_current_state;
#endif
	{
	register int yy_is_jam;
	register char *yy_cp = yy_c_buf_p;

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yy_last_accepting_state = yy_current_state;
		yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 188 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 187);

	return yy_is_jam ? 0 : yy_current_state;
	}


#ifndef YY_NO_UNPUT
#ifdef YY_USE_PROTOS
static void yyunput( int c, register char *yy_bp )
#else
static void yyunput( c, yy_bp )
int c;
register char *yy_bp;
#endif
	{
	register char *yy_cp = yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yy_hold_char;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = yy_n_chars + 2;
		register char *dest = &yy_current_buffer->yy_ch_buf[
					yy_current_buffer->yy_buf_size + 2];
		register char *source =
				&yy_current_buffer->yy_ch_buf[number_to_move];

		while ( source > yy_current_buffer->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		yy_current_buffer->yy_n_chars =
			yy_n_chars = yy_current_buffer->yy_buf_size;

		if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;


	yytext_ptr = yy_bp;
	yy_hold_char = *yy_cp;
	yy_c_buf_p = yy_cp;
	}
#endif	/* ifndef YY_NO_UNPUT */


#ifdef __cplusplus
static int yyinput()
#else
static int input()
#endif
	{
	int c;

	*yy_c_buf_p = yy_hold_char;

	if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			/* This was really a NUL. */
			*yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yy_c_buf_p - yytext_ptr;
			++yy_c_buf_p;

			switch ( yy_get_next_buffer() )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/* fall through */

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap() )
						return EOF;

					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yy_c_buf_p = yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yy_c_buf_p;	/* cast for 8-bit char's */
	*yy_c_buf_p = '\0';	/* preserve yytext */
	yy_hold_char = *++yy_c_buf_p;


	return c;
	}


#ifdef YY_USE_PROTOS
void yyrestart( FILE *input_file )
#else
void yyrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! yy_current_buffer )
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_init_buffer( yy_current_buffer, input_file );
	yy_load_buffer_state();
	}


#ifdef YY_USE_PROTOS
void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif
	{
	if ( yy_current_buffer == new_buffer )
		return;

	if ( yy_current_buffer )
		{
		/* Flush out information for old buffer. */
		*yy_c_buf_p = yy_hold_char;
		yy_current_buffer->yy_buf_pos = yy_c_buf_p;
		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	yy_current_buffer = new_buffer;
	yy_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yy_did_buffer_switch_on_eof = 1;
	}


#ifdef YY_USE_PROTOS
void yy_load_buffer_state( void )
#else
void yy_load_buffer_state()
#endif
	{
	yy_n_chars = yy_current_buffer->yy_n_chars;
	yytext_ptr = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
	yyin = yy_current_buffer->yy_input_file;
	yy_hold_char = *yy_c_buf_p;
	}


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yy_flex_alloc( b->yy_buf_size + 2 );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
	}


#ifdef YY_USE_PROTOS
void yy_delete_buffer( YY_BUFFER_STATE b )
#else
void yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == yy_current_buffer )
		yy_current_buffer = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yy_flex_free( (void *) b->yy_ch_buf );

	yy_flex_free( (void *) b );
	}


#ifndef YY_ALWAYS_INTERACTIVE
#ifndef YY_NEVER_INTERACTIVE
extern int isatty YY_PROTO(( int ));
#endif
#endif

#ifdef YY_USE_PROTOS
void yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif


	{
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

#if YY_ALWAYS_INTERACTIVE
	b->yy_is_interactive = 1;
#else
#if YY_NEVER_INTERACTIVE
	b->yy_is_interactive = 0;
#else
	b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
	}


#ifdef YY_USE_PROTOS
void yy_flush_buffer( YY_BUFFER_STATE b )
#else
void yy_flush_buffer( b )
YY_BUFFER_STATE b;
#endif

	{
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == yy_current_buffer )
		yy_load_buffer_state();
	}


#ifndef YY_NO_SCAN_BUFFER
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_buffer( char *base, yy_size_t size )
#else
YY_BUFFER_STATE yy_scan_buffer( base, size )
char *base;
yy_size_t size;
#endif
	{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef YY_NO_SCAN_STRING
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_string( yyconst char *yy_str )
#else
YY_BUFFER_STATE yy_scan_string( yy_str )
yyconst char *yy_str;
#endif
	{
	int len;
	for ( len = 0; yy_str[len]; ++len )
		;

	return yy_scan_bytes( yy_str, len );
	}
#endif


#ifndef YY_NO_SCAN_BYTES
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_bytes( yyconst char *bytes, int len )
#else
YY_BUFFER_STATE yy_scan_bytes( bytes, len )
yyconst char *bytes;
int len;
#endif
	{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) yy_flex_alloc( n );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef YY_NO_PUSH_STATE
#ifdef YY_USE_PROTOS
static void yy_push_state( int new_state )
#else
static void yy_push_state( new_state )
int new_state;
#endif
	{
	if ( yy_start_stack_ptr >= yy_start_stack_depth )
		{
		yy_size_t new_size;

		yy_start_stack_depth += YY_START_STACK_INCR;
		new_size = yy_start_stack_depth * sizeof( int );

		if ( ! yy_start_stack )
			yy_start_stack = (int *) yy_flex_alloc( new_size );

		else
			yy_start_stack = (int *) yy_flex_realloc(
					(void *) yy_start_stack, new_size );

		if ( ! yy_start_stack )
			YY_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	yy_start_stack[yy_start_stack_ptr++] = YY_START;

	BEGIN(new_state);
	}
#endif


#ifndef YY_NO_POP_STATE
static void yy_pop_state()
	{
	if ( --yy_start_stack_ptr < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(yy_start_stack[yy_start_stack_ptr]);
	}
#endif


#ifndef YY_NO_TOP_STATE
static int yy_top_state()
	{
	return yy_start_stack[yy_start_stack_ptr - 1];
	}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

#ifdef YY_USE_PROTOS
static void yy_fatal_error( yyconst char msg[] )
#else
static void yy_fatal_error( msg )
char msg[];
#endif
	{
	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
	}



/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		yytext[yyleng] = yy_hold_char; \
		yy_c_buf_p = yytext + n; \
		yy_hold_char = *yy_c_buf_p; \
		*yy_c_buf_p = '\0'; \
		yyleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef yytext_ptr
#ifdef YY_USE_PROTOS
static void yy_flex_strncpy( char *s1, yyconst char *s2, int n )
#else
static void yy_flex_strncpy( s1, s2, n )
char *s1;
yyconst char *s2;
int n;
#endif
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif

#ifdef YY_NEED_STRLEN
#ifdef YY_USE_PROTOS
static int yy_flex_strlen( yyconst char *s )
#else
static int yy_flex_strlen( s )
yyconst char *s;
#endif
	{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
	}
#endif


#ifdef YY_USE_PROTOS
static void *yy_flex_alloc( yy_size_t size )
#else
static void *yy_flex_alloc( size )
yy_size_t size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef YY_USE_PROTOS
static void *yy_flex_realloc( void *ptr, yy_size_t size )
#else
static void *yy_flex_realloc( ptr, size )
void *ptr;
yy_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}

#ifdef YY_USE_PROTOS
static void yy_flex_free( void *ptr )
#else
static void yy_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#if YY_MAIN
int main()
	{
	yylex();
	return 0;
	}
#endif
#line 596 "mgllex.l"



/*
 ********************************************************************
 *
 *		Local routines for the lexer
 *
 ********************************************************************
 */


/*
 ********************************************************************
 *
 * Flex 2.5.31 undefines yytext_ptr at the end of the rules section
 * (which is clearly a bug), so we have to redefine it here.
 */
#if defined(FLEX_SCANNER) && !defined(yytext_ptr)
# define yytext_ptr	yytext
#endif



/*
 ********************************************************************
 *
 * Print lexer error message and exit
 */
#ifdef FLEX_SCANNER
static void lex_error(msg)
char *msg;
{
  if (FALSE) {
	/*
	 * This is just to avoid compiler warnings. It gets optimized away by
	 * the compiler.
	 */
	yy_fatal_error(msg);
  }
  prnerr("%s", msg);
  exit(EXIT_MGL_LEX);
}
#endif



/*
 ********************************************************************
 *
 * Read the next character from the current input file
 */
#ifdef USE_MGL_INPUT
static int mgl_input()
{
  int c;

#if !defined(USE_INCLUDE)
  assert(yyin != NULL);
  if (unput_char != 0) {
	c = unput_char;
	unput_char = 0;
	return(c);
  }
  return(getc(yyin));
#else
  assert(curinput != NULL && curinput->inbuf != NULL);
  if (curinput->inpos > 0)
	return(curinput->inbuf[--curinput->inpos]);
  return((c = (int)getc(curinput->infile)) == EOF ? 0 : c);
#endif
}
#endif



/*
 ********************************************************************
 *
 * Put a character back into the input buffer
 */
#ifdef USE_MGL_INPUT
static void mgl_unput(c)
int c;
{
#if !defined(USE_INCLUDE)
  unput_char = c;
#else
  assert(curinput != NULL && curinput->inbuf != NULL);
  if (curinput->inpos >= curinput->insize) {
	char *tmpbuf;

	tmpbuf = (char *)nbmalloc(curinput->insize + YYLMAX);
	memcpy(tmpbuf, curinput->inbuf, curinput->insize);
	free(curinput->inbuf);
	curinput->inbuf = tmpbuf;
	curinput->insize += YYLMAX;
  }
  curinput->inbuf[curinput->inpos++] = (char)c;
#endif
}
#endif



/*
 ********************************************************************
 *
 * Open a new input file
 */
static void openinput(fname)
char *fname;
{
#ifdef USE_INCLUDE
  struct input_file *ifp;
#endif
  FILE *infile;

  /* Open input file */
  if (fname == NULL || !*fname) {
	infile = stdin;
	fname = "<stdin>";
  } else if ((infile = fopen(fname, "r")) == NULL) {
	perror(progname);
	exit(EXIT_MGL_PROGOPEN);
  }

  /* Create a new input file buffer */
#ifdef USE_INCLUDE
  if (curinput != NULL)
	curinput->lineno = lineno;
  ifp = (struct input_file *)nbmalloc(sizeof(struct input_file));
  ifp->infile = infile;
  ifp->next = curinput;
  curinput = ifp;
#ifdef FLEX_SCANNER
  ifp->inbuf = yy_create_buffer(ifp->infile, YY_BUF_SIZE);
  yy_switch_to_buffer(ifp->inbuf);
#else
  ifp->inbuf = (char *)nbmalloc(YYLMAX);
  ifp->insize = YYLMAX;
  ifp->inpos = 0;
#endif
  copystr(&(ifp->fname), fname);
  curfile = ifp->fname;
#else /* USE_INCLUDE */
  curfile = fname;
#endif
  yyin = infile;
  lineno = 1;
}



/*
 ********************************************************************
 *
 * Close the current input file
 */
static void closeinput()
{
#ifdef USE_INCLUDE
  struct input_file *ifp;
#endif
  FILE *infile;

  /* Delete input buffer */
#ifdef USE_INCLUDE
  assert(curinput != NULL);
  ifp = curinput;
  curinput = ifp->next;
#ifdef FLEX_SCANNER
  if (curinput != NULL) {
	curfile = curinput->fname;
	lineno = curinput->lineno;
	yy_switch_to_buffer(curinput->inbuf);	/* This will also set yyin */
  }
  if (ifp->inbuf != NULL)
	yy_delete_buffer(ifp->inbuf);
#else
  if (curinput != NULL) {
	curfile = curinput->fname;
	lineno = curinput->lineno;
	yyin = curinput->infile;
  }
  if (ifp->inbuf != NULL)
	free(ifp->inbuf);
#endif
  if (ifp->fname != NULL)
	free(ifp->fname);
  infile = ifp->infile;
  free(ifp);
#else /* USE_INCLUDE */
  assert(yyin != NULL);
  infile = yyin;
  yyin = NULL;
#endif

  /* Close the current input file */
  if (infile != NULL && infile != stdin)
	fclose(infile);
}



/*
 *****************************************************************************
 *
 * Switch to previous file if we are at the end of the current include file
 */
static int yywrap()
{
  closeinput();
#ifdef USE_INCLUDE
  return(curinput != NULL ? 0 : 1);
#else
  return(1);
#endif
}



/*
 ********************************************************************
 *
 * Handle multi-line comments
 */
static void do_comment(brace_flag)
int brace_flag;
{
  /* Define the current reading state */
  enum {
	STATE_BEGIN,
	STATE_DOLLAR,
	STATE_COMMAND,
	STATE_NUMARG,
	STATE_STRARG,
	STATE_OTHER
  } curstate = STATE_BEGIN;

  /* Define the allowed commands */
  enum {
	CMT_CMD_NONE,
	CMT_CMD_INCLUDE,
	CMT_CMD_STKSIZE,
	CMT_CMD_STRING,
	CMT_CMD_BUILTIN
  } curcmd = CMT_CMD_NONE;

  /* Define the allowed types of argument */
  enum {
	CMT_ARG_NONE,
	CMT_ARG_NUM,
	CMT_ARG_STR,
	CMT_ARG_FLAG
  } argneeded = CMT_ARG_NONE;

  int c1 = 0;
  int c2;
  int argflag = -1;
  int argnum = 0;
  char argstr[MAX_CMT_ARG + 1];

  /*
   * First scan through the whole comment. The leading character has already
   * been read by the lexer, so we can now read all the rest of the comment
   * using the lexer's input() routine. We also check for compiler commands
   * within the comment by using a very simple state machine.
   */
  while (TRUE) {
	/* Check if end of file */
	if ((c2 = input()) == 0) {
		error("end of file reached within comment", FALSE);
		break;
	}

	/* We have to continue counting lines in a comment */
	if (c2 == '\n')
		lineno++;

	/* Determine current state regarding compiler flag parsing */
	switch (curstate) {

		case STATE_BEGIN:
			/* We just began to scan a comment */
			if (c2 == '$')
				curstate = STATE_DOLLAR;
			else if (c2 != ' ' && c2 != '\t')
				curstate = STATE_OTHER;
			break;

		case STATE_DOLLAR:
			/* We found a dollar sign and now need a command char */
			switch (c2) {
				case 'I':
					curcmd = CMT_CMD_INCLUDE;
					argneeded = CMT_ARG_STR;
					break;
				case 'H':
					curcmd = CMT_CMD_STKSIZE;
					argneeded = CMT_ARG_NUM;
					break;
				case 'S':
					curcmd = CMT_CMD_STRING;
					argneeded = CMT_ARG_FLAG;
					break;
				case 'B':
					curcmd = CMT_CMD_BUILTIN;
					argneeded = CMT_ARG_FLAG;
					break;
				default:
					curcmd = CMT_CMD_NONE;
					argneeded = CMT_ARG_NONE;
					break;
			}
			if (curcmd != CMT_CMD_NONE)
				curstate = STATE_COMMAND;
			else
				curstate = STATE_OTHER;
			break;

		case STATE_COMMAND:
			/* We found a valid command, now scan for an argument */
			if (c2 != ' ' && c2 != '\t') {
				if (argneeded == CMT_ARG_FLAG) {
					if (c2 == '+')
						argflag = TRUE;
					else if (c2 == '-')
						argflag = FALSE;
					else {
						warning("invalid flag command");
						argneeded = CMT_ARG_NONE;
						curcmd = CMT_CMD_NONE;
					}
					curstate = STATE_OTHER;
				} else if (argneeded == CMT_ARG_NUM) {
					if (c2 >= '0' && c2 <= '9') {
						argnum = c2 - '0';
						curstate = STATE_NUMARG;
					} else {
						warning("invalid or missing number argument");
						argneeded = CMT_ARG_NONE;
						curcmd = CMT_CMD_NONE;
						curstate = STATE_OTHER;
					}
				} else if (argneeded == CMT_ARG_STR) {
					if (c2 == (cstring ? '"' : '\'')) {
						argnum = 0;
						curstate = STATE_STRARG;
					} else {
						warning("missing string argument");
						argneeded = CMT_ARG_NONE;
						curcmd = CMT_CMD_NONE;
						curstate = STATE_OTHER;
					}
				} else
					curstate = STATE_OTHER;
			}
			break;

		case STATE_NUMARG:
			/* Process a numerical argument */
			if (c2 >= '0' && c2 <= '9') {
				if (argnum >= ((MAX_INT + 1) / 10)) {
					warning("argument number too large");
					curstate = STATE_OTHER;
					curcmd = CMT_CMD_NONE;
				} else
					argnum = argnum * 10 + (c2 - '0');
			} else {
				if (argnum == 0)
					warning("invalid or missing argument number");
				curstate = STATE_OTHER;
			}
			break;

		case STATE_STRARG:
			/* Process a string argument */
			argflag = FALSE;
			if (argnum >= MAX_CMT_ARG) {
				warning("string argument too long, truncating");
				argflag = TRUE;
			} else if (c2 == '\n') {
				warning("unterminated string argument");
				argflag = TRUE;
			}

			if (argflag || c2 == (cstring ? '"' : '\''))
				curstate = STATE_OTHER;
			else
				argstr[argnum++] = c2;
			break;

		case STATE_OTHER:
			/* Skip rest of comment */
			break;
	}

	/* Check if end of comment reached */
	if (curstate == STATE_OTHER) {
		if (brace_flag) {
			if (c2 == '}')
				break;
		} else {
			if (c1 == '*' && c2 == ')')
				break;
			c1 = c2;
		}
	}
  }

  /* If there was a string argument, we have to terminate the string with 0 */
  if (argneeded == CMT_ARG_STR) {
	assert(argnum >= 0 && argnum <= MAX_CMT_ARG);
	argstr[argnum] = '\0';
  }

  /* Finally process any embedded compiler command */
  switch (curcmd) {
	case CMT_CMD_INCLUDE:
#ifdef USE_INCLUDE
		if (strlen(argstr) == 0)
			warning("empty file name for include command");
		else {
			char *infile = NULL;

			copystr(&infile, argstr);
			checkaccess(&infile, lexincpath, ACCESS_FILE_READ);
			if (infile == NULL)
				warning("include file not found");
			else {
				openinput(infile);
				free(infile);
			}
		}
#else
		warning("include command unsupported");
#endif
		break;
	case CMT_CMD_STKSIZE:
		if (argnum < RTSTK_MIN || argnum > RTSTK_MAX)
			warning("stack size out of range");
		else
			stacksize = (argnum + 1) & ~1;
		break;
	case CMT_CMD_STRING:
		assert(argflag == TRUE || argflag == FALSE);
		cstring = argflag;
		break;
	case CMT_CMD_BUILTIN:
		assert(argflag == TRUE || argflag == FALSE);
		nobuiltin = !argflag;
		break;
	default:
		break;
  }
}



/*
 ********************************************************************
 *
 * Routine to add a character to the string constant
 */
static void add_string(c)
pcchar_t c;
{
  if (!string_flag) {
	if (string_buf[0] > MAX_STR_LEN) {
		warning("string too long, truncating");
		string_flag = TRUE;
	} else {
		string_buf[0] += 1;
		/*
		 * The blanks in the following command are intentional.
		 * Leaving them out triggers a bug in flex-2.5.31.
		 */
		string_buf[ string_buf[0] ] = c;
	}
  }
}



/*
 *****************************************************************************
 *
 * Scan the input for a string constant
 */
static void do_string(quote)
char quote;
{
  /* Current scanning state */
  enum {
	STATE_SCAN,
	STATE_SLASH,
	STATE_OCTAL,
	STATE_OTHER,
	STATE_END
  } curstate = STATE_SCAN;

  int octnum = 0;
  int octlen = 0;
  int c;

  string_flag = FALSE;
  string_buf[0] = 0;
  while (curstate != STATE_END) {
	/* Check for end of file */
	if ((c = input()) == 0) {
		error("end of file reached within string or character constant", FALSE);
		break;
	}

	/* Strings can't span more than one line */
	if (c == '\n') {
		lineno++;
		error("unterminated string or character constant", FALSE);
		break;
	}

	/* Check for invalid character */
	if (iscntrl(c)) {
		warning("invalid character in string or character constant, skipping");
		if (curstate != STATE_SCAN && curstate != STATE_OTHER) {
			if (curstate == STATE_OCTAL)
				add_string((pcchar_t)(octnum & 0xff));
			curstate = STATE_SCAN;
		}
		continue;
	}

	/* Now check current reading state */
rescan:
	switch (curstate) {

		case STATE_SCAN:
			/* Insert character as-is into result string buffer */
			if (c == (int)quote) {
				if (!cstring) {
					int c1;

					if ((c1 = input()) == (int)quote)
						add_string((pcchar_t)chartotarget(c1));
					else {
						unput(c1);
						curstate = STATE_END;
					}
				} else
					curstate = STATE_END;
			} else if (c == '\\')
				curstate = STATE_SLASH;
			else
				add_string((pcchar_t)chartotarget(c));
			break;

		case STATE_SLASH:
			/* Slash detected, check for following character */
			if (c >= '0' && c <= '7') {
				octlen = 1;
				octnum = c - '0';
				curstate = STATE_OCTAL;
			} else {
				switch (c) {
					case 'n':	c = '\n'; break;
					case 'r':	c = '\r'; break;
					case 'f':	c = '\f'; break;
					case 't':	c = '\t'; break;
					case 'b':	c = '\b'; break;
					default:	break;
				}
				add_string((pcchar_t)chartotarget(c));
				curstate = STATE_SCAN;
			}
			break;

		case STATE_OCTAL:
			/* Scan octal number */
			if (c >= '0' && c <= '7' && octlen < 3) {
				octnum = octnum * 8 + c - '0';
				if (octnum > 0xff) {
					error("octal number too large for character value", FALSE);
					octnum = 0xff;
				}
				octlen++;
			} else {
				add_string((pcchar_t)(octnum & 0xff));
				curstate = STATE_SCAN;
				goto rescan;
			}
			break;

		case STATE_OTHER:
			/* Skip everything which doesn't fit into buffer anymore */
			if (c == (int)quote)
				curstate = STATE_END;
			break;

		case STATE_END:
			/* This is just here to make the compiler happy */
			break;
	}
  }
  if (curstate == STATE_OCTAL)
	add_string((pcchar_t)(octnum & 0xff));
}



/*
 *****************************************************************************
 *
 * Initialize lexer
 */
void yylexinit(infile, incpath)
char *infile;
char *incpath;
{
  struct sym *sp;
  int i;

  /* Set include file path */
  lexincpath = incpath;

  /* Open input file */
  openinput(infile);

  /* Initialize the list of known types */
  typetab = TYPES_START;

  /* The string type is special */
  string_type.def.a.indextype = &strindex_type;
  string_type.def.a.basetype = &char_type;

  /* The pointer type is also special */
  pointer_type.def.p.basetype = &any_type;
  pointer_type.def.p.unknownsym = NULL;

  /* Preset the list of special symbols */
  for (i = 0; specialtab[i].name != NULL; i++) {
	sp = addsym(specialtab[i].name, SYMBOL_NOREF);
	sp->type = specialsym;
	sp->def.s.token = specialtab[i].token;
  }
}

