/*
 * runtime.h  -  Definitions for MGL runtime module
 *
 * Copyright (C) 2003-2007 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: runtime.h,v 1.11 2007/01/06 18:31:38 gkminix Exp $
 *
 */

#ifndef HEADERS_RUNTIME_H
#define HEADERS_RUNTIME_H


/*
 * Check the compile system and turn structure packing on
 */
#include <compiler.h>
#include <pack.h>



/*
 * The runtime module contains a structure at the beginning which contains
 * various operating parameters.
 */
#define RT_IDSTRING	"mglruntime"	/* ID string for every runtime module */

#define RT_DATAOFS	0x0008		/* offset to data structure */

#ifndef _ASSEMBLY_

struct rtdata {
  __u16		id;			/* offset to ID string */
  __long	loadsize;		/* total load size */
  __u16		textend;		/* end of runtime text seg */
  __u16		dataend;		/* end of runtime data seg */
  __u16		bssend;			/* end of runtime BSS seg */
  __u16         constend;		/* end of constant data */
  __u16         varend;			/* end of variable data */
  __u16		dataofs;		/* offset to data segment */
  __u16		debug;			/* offset to debugging data */
  __u16		start;			/* offset to first screen */
  __u16		stksize;		/* size of stack */
} PACKED;

#else

			.struct	0
rtdata_id:		.struct	.+2	/* offset to ID string */
rtdata_loadsize:	.struct	.+4	/* total load size */
rtdata_textend:		.struct	.+2	/* end of runtime text seg */
rtdata_dataend:		.struct	.+2	/* end of runtime data seg */
rtdata_bssend:		.struct	.+2	/* end of runtime BSS seg */
rtdata_constend:	.struct	.+2	/* end of constant data */
rtdata_varend:		.struct	.+2	/* end of variable data */
rtdata_dataofs:		.struct	.+2	/* offset to data segment */
rtdata_debug:		.struct	.+2	/* offset to debugging data */
rtdata_start:		.struct	.+2	/* offset to first screen */
rtdata_stksize:		.struct	.+2	/* size of stack */

#endif /* _ASSEMBLY_ */



/*
 * Minimum, maximum and default stack sizes for runtime module
 */
#define RTSTK_DEFAULT	 (8 * 1024)
#define RTSTK_MIN	 (2 * 1024)
#define RTSTK_MAX	(32 * 1024)



/*
 * Error codes returned by the runtime module
 */
#define RTERROR_LOAD	0			/* load new boot image */
#define RTERROR_RUN	1			/* run a new boot image */
#define RTERROR_ABORT	2			/* abort boot process */



/*
 * Mapping of compare commands for runtime module. These are needed
 * for the strcmp routine.
 */
#define RTCMP_NONE	0
#define RTCMP_EQ	1
#define RTCMP_GT	2
#define RTCMP_GE	3
#define RTCMP_LT	4
#define RTCMP_LE	5
#define RTCMP_NE	6



/*
 * Definitions for exports table
 */
#define RTIF_MAJOR_VER		0	/* version info of interface */
#define RTIF_MINOR_VER		2
#define RTIF_VERSION		(RTIF_MAJOR_VER * 256 + RTIF_MINOR_VER)

#define RTEXP_END		0	/* marks end of table */
#define RTEXP_VERSION		1	/* version number of interface */
#define RTEXP_PROC		2	/* procedure name */
#define RTEXP_VAR		3	/* variable name */
#define RTEXP_VARCONST		4	/* constant variable name */
#define RTEXP_CONST		5	/* constant name */

#define VALTYPE_NONE		0	/* value has no type */
#define VALTYPE_ANY		1	/* value has any type */
#define VALTYPE_NUM		2	/* value is a number */
#define VALTYPE_BOOL		3	/* value is a boolean */
#define VALTYPE_CHAR		4	/* value is a character */
#define VALTYPE_STRING		5	/* value is a string */
#define VALTYPE_IPADDR		6	/* value is an IP address */
#define VALTYPE_POINTER		7	/* value is a pointer */
#define VALTYPE_OTHER		8	/* value has another non-scalar type */

#define VALCLASS_NONE		0	/* value has no class */
#define VALCLASS_CONST		1	/* value has constant class */
#define VALCLASS_REF		2	/* value has reference class */

#ifndef _ASSEMBLY_

struct rtexport {
  __u8		exptype;		/* type of export record */
  __u8		valtype;		/* type of value */
  __u16		value;			/* symbol value */
  __u16		size;			/* size of symbol */
} PACKED;

#else

			.struct	0
rtexport_exptype:	.struct	.+1	/* type of export record */
rtexport_valtype:	.struct	.+1	/* type of value */
rtexport_value:		.struct	.+2	/* symbol value */
rtexport_size:		.struct	.+2	/* symbol value */
rtexport_name:		.struct	.+2	/* offset to name */
rtexport_args:		.struct	.+2	/* offset to arguments */

#endif /* _ASSEMBLY_ */



/*
 * Restore all definitions for data structure packing
 */
#include <unpack.h>

#endif

