.\" @(#)mknbi-linux.8
.\"
.\" Copyright (C) 1995-2007 Gero Kuhlmann   <gero@gkminix.han.de>
.\" Copyright (C) 1996,1997 Gero Kuhlmann   <gero@gkminix.han.de>
.\"                and Markus Gutschke <gutschk@math.uni-muenster.de>
.\"
.\"  This program is free software; you can redistribute it and/or modify
.\"  it under the terms of the GNU General Public License as published by
.\"  the Free Software Foundation; either version 2 of the License, or
.\"  any later version.
.\"
.\"  This program is distributed in the hope that it will be useful,
.\"  but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"  GNU General Public License for more details.
.\"
.\"  You should have received a copy of the GNU General Public License
.\"  along with this program; if not, write to the Free Software
.\"  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.\" $Id: mknbi.man,v 1.12 2007/01/06 18:31:26 gkminix Exp $
.TH MKNBI-LINUX 8 "25 Jul 2002"
.SH NAME
mknbi-linux - MaKe NetBoot Image for Linux

.SH SYNOPSIS
.LP
.B mknbi-linux
[OPTIONS] [<kernel image> [<output file>]]

.SH DESCRIPTION
.B mknbi-linux
is a program to convert a 
.B Linux
kernel image into a file which is directly loadable by diskless 
systems using a bootrom which is compliant with the 
.B netboot
specification.

.SH OPTIONS
.TP
.B -a, --append STRING
String to append to the end of the kernel command line. The kernel
command line starts with \(dqauto rw\(dq by default in order to tell the
kernel to automatically check and mount all file systems and to mount 
the root file system read-write. However, if you want to mount the
root file system read-only, you can use the word \(dqro\(dq with the
.B -a
option instead of \(dqrw\(dq.
Likewise, if you want to remove the word \(dqauto\(dq from the
command line, use \(dqnoauto\(dq with the
.B -a
option. You can also give any other command line options here which
are necessary for the kernel.
.TP
.B -b, --batch-sys SYSTEM
Lets 
.B mknbi-linux
operate in batch mode. It will look up the given system name in a
database file and generate a netbootable image according to the 
parameters specified in the database entry. If this option is not
given,
.B mknbi-linux
will operate according to the other command line options. If giving
any other options in addition to 
.B -b
or 
.BR --batch-sys ,
the parameters found in the database will override those processed from 
the command line.
.TP
.B -C, --config-file FILE
Specifies the pathname of the configuration file. If this option is not
given, the value of the
.SM NETBOOT_CONFIG
environment variable or a compiled-in default will be used.
.TP
.B -d, --root-dir STRING
Define the name of a directory to mount via NFS on the boot server.
.B STRING
can have the following values:
.RS
.TP
.B rom
That directory is used as root in which the loaded netboot 
image file is located. This is determined by the bootrom
at run time, usually by using
.SM BOOTP
or 
.SM DHCP.
If the boot server is able to handle RFC 1497 extensions,
it is possible to define a different root directory than that 
where the image file is located.
.TP
.B kernel
The root directory is that used by the loaded kernel as it's compiled-in
default.
.TP
.B ram[0-9]
Tells the kernel to use a ramdisk for booting. No NFS
directory will be mounted in that case. If a number is given
that numbered ram disk will be used for the root directory.
Otherwise, if no number is given the initial ram disk of the
kernel is used.
.TP
.B initrd
This will use the initial ramdisk as the root directory, and is
therefore the same as 
.BR ram0 .
However, with the
.B initrd
root device specification the boot loader will not pass any 
IP autoconfiguration option to the kernel, and the initial ramdisk
has to setup the network interface itself if necessary. Also the
kernel command line will be built so that /linuxrc will be started
by the kernel as the first process (see initrd-Documentation for
further information).
.TP
.B <directory name>
Compile the directory name directly into the boot image. It will be used
by the kernel for it's root directory. There is no way lateron to change
it at run time. This is the default when this option is not given, and
the default directory name is 
.IR /tftpboot/%s ,
with the 
.B \(dq%s\(dq
representing the IP address of the booting system.
If the directory name starts with 
.IR /dev/ ,
that named device is 
used as the root device, and no NFS directory will be mounted.
.RE
.TP
.B -D, --database FILE|DBSPEC
Pathname of database file (or database specification) to be used
together with the 
.B -b
or 
.B --batch-sys
options. If this option is not given, the value of the
.SM NETBOOT_DATABASE
environment variable or a compiled-in default will be used.
See the netboot(5) man page for a further explanation of
different ways to specify a database.
.TP
.B -F, --logfile
Name of log file to write debugging output to. The default is to
print all verbose output to stdout.
.TP
.B -h, --help
Print short usage information.
.TP
.B -H, --home-dir
Specifies the home directory. If this command line option is not
given, either the
.B homedir
configuration file parameter or the current user's home directory
will be used.
.TP
.B -i, --ip-addrs STRING
Define client and server IP addresses.
.B STRING
can have the following values:
.RS
.TP
.B rom
All necessary IP addresses for NFS root mounting will be determined 
at run time using the 
.SM BOOTP
or 
.SM DHCP
answer the bootrom received from the server. This is the preferred value
when using 
.B mknbi-linux
together with a 
.B netboot
bootrom.
.TP
.B kernel
No IP addresses are defined, and the kernel should determine them
by itself, usually by using
.SM RARP,
.SM BOOTP
or 
.SM DHCP.
.TP
.B <client:server:gateway:netmask:hostname[:dev[:proto]]>
Define the necessary boot addresses 
during compilation of the boot image. All addresses must be
seperated by a colon.
.B mknbi-linux
will automatically convert system names into decimal IP addresses for 
the first four entries in this string. The
.B hostname
entry will be used 
by the kernel to set the host name of the booted Linux diskless client 
and shouldn't contain any domain name part.
When more than one network interface are installed in the diskless client,
it is possible to specify the name of the interface to use for mounting 
the root directory via NFS by giving the optional value 
.BR dev .
This entry has to start with the string 
.B eth
followed by a number from 0 to 9. However, if only one interface is
installed in the client, this
.B dev
entry including the preceding semicolon can be left out, or remain empty.
The 
.B proto
entry is only usable with kernel version 2.2.x or newer
and can be used to specify the protocol with which the kernel should 
detect any missing addresses. It can have one the following values:
.BR off ,
.BR none ,
.BR on ,
.BR any ,
.BR dhcp ,
.BR bootp ,
.B rarp
or 
.BR both .
.RE
.TP
.B -k, --kernel FILE
Pathname of kernel image file. The default is
.IR /vmlinuz .
.TP
.B -l, --ramdisk-mode
The startup code that will be included with the netboot image can 
usually take care of moving the ramdisk image to a valid location in 
memory. But depending on the version of your BIOS, the kind of
bootrom you use, and the fact that you might have more than 16MB of
memory, there could be difficulties. In this case, you will have to
provide further information:
.RS
.TP
.B auto
This is the default behavior. The Bootrom will load the ramdisk
image at right behind the kernel image. The
startup code will then try to determine the last legal address in the 
lower 16MB and subsequently move the ramdisk image there. This
technique will work in most cases and provides the highest degree of 
compatibility and portability among different machines.
.TP
.B eom
If 
.B auto
does not work for you, you should check if your bootrom is capable
of loading the ramdisk image to the end of the physical memory. This
might work fine, but it is slightly less compatible than
.BR auto .
.TP
.B <address>
If everything else fails, you can resort to explicitly specifying the
load address. Although beware that this is likely to cause problems,
when trying to use the same image on machines with different amounts 
of memory. You should try to specify an address that is both below
16MB and below the physical end of memory; you will have to leave
enough room for the entire (compressed) ramdisk image. If you move the
image too low, it will collide with the uncompressed kernel image and
the kernel will ignore the contents of the ramdisk; you will notice a
warning message, when booting. If you have at least 16MB of main
memory, you should try to load the image to
.BR 0xD30000 ,
as this leaves enough room for an uncompressed 2.88MB ramdisk image,
but is unlikely to conflict with the uncompressed kernel image. If you
want to see if there is a conflict between the ramdisk image and 
other parts of the compiled netboot image, you can increase the
verbosity level until detailed load record information is printed.
.RE
.TP
.B -m, --vga-mode MODE
Specifies the mode into which to set the graphics card when the Linux kernel 
starts.
.B MODE
can be any of the following values:
.RS
.TP
.B normal
Use normal VGA mode, which is what the BIOS has selected when the bootrom
started.
.TP
.B extended
Switch to a larger screen size.
.TP
.B ask
Ask the user which mode to use when the Linux kernel starts. The user will
be presented with a menu of possible video modes.
.TP
.B default
Use the VGA mode value defined in the Linux kernel and don't allow
.B mknbi-linux
to change it. This is the default behaviour if the
.B --vga-mode
option is missing.
.TP
.B <number>
Directly specify the video mode.
.RE
.TP
.B -N, --datadir DIR
Pathname of the shared-data directory. If this option is not given, the value
of the 
.SM NETBOOT_DATA
environment variable or a compiled-in default will be used.
.TP
.B -L, --libdir DIR
Pathname of the non-shared-data directory. If this option is not given, the
value of the 
.SM NETBOOT_LIB
environment variable or a compiled-in default will be used.
.TP
.B -o, --outfile FILE
Pathname of output file, which is lateron loaded by the
bootrom via TFTP.
.TP
.B -r, --ramdisk-image FILE
Preloaded ramdisk image; for further information look into
.I linux/Documentation/initrd.txt
in the Linux source tree. This requires Linux version 1.3.73 or above.
.TP
.B -S, --save-sys SYSTEM
This option lets you save the parameters for a netboot image into the 
systems database using the name SYSTEM. Lateron, it is no longer
necessary to type all command line arguments to 
.B mknbi-linux
again, but you can use the
.B -b
or 
.B --batch-sys
option to generate a new netboot image.
.TP
.B -v, --version
Print version information.
.TP
.B -x, --verbose
Verbose output to let you know what 
.B mknbi-linux
is doing. Each
.B -x
increases the verbosity level.

.SH BOOTP VENDOR TAGS
.B mknbi-linux
includes a startup code at the beginning of the Linux kernel which is able 
to detect certain 
.SM BOOTP
or 
.SM DHCP
vendor defined tags. These can be used to modify
the kernel loading process at runtime. To use these tags with bootpd, a
publicly available 
.SM BOOTP
server daemon, you can use the following syntax
in the /etc/bootptab file:
.RS
.LP
T<number>=\(dq<string>\(dq
.LP
.RE
For example, to specify a different root NFS device, you can use:
.RS
.LP
T130=\(dqeth1\(dq
.LP
.RE
The following tags are presently supported by 
.BR mknbi-linux :
.TP
.B 129
The 
.B <string>
value given with this tag is appended verbatim to the end of the 
kernel command line.
It can be used to specify arguments like I/O addresses or DMA channels
required for special hardware like SCSI adapters, network cards etc. Please
consult the Linux kernel documentation about the syntax required by those 
options. It is the same as the
.B -a
or 
.B --append
command line option to 
.BR mknbi-linux ,
but works at runtime instead of compile time.
.TP
.B 130
With this tag it is possible to the select the network adapter used for 
mounting root via NFS on a multihomed diskless client. The syntax for
the 
.B <string>
value is the same as for the 
.B dev
entry used with the 
.B -i
option as described above. However note that the
.B mknbi-linux
runtime loader does not check the syntax of the string.

.SH DATABASE FILE
.B mknbi-linux
does not use any sections in the configuration file except the [general]
section. However, for easier maintenance of different client configurations
the database file can be used. The entries have to be preceded by a
[mknbi-linux:<system name>] tag and can contain the following parameters:
.TP
.B outfile
Specifies the name of the output file 
.TP
.B ramdisk-image
Specifies the name of the ramdisk image file or directory 
.TP
.B ramdisk-mode
Specifies the mode of the ramdisk like the 
.B -l
or 
.B --ramdisk-mode
command line options.
.TP
.B vga-mode
Specifies the mode to set the graphics card into when starting the 
Linux kernel like the 
.B -m
or 
.B --vga-mode
command line options.
.TP
.B append
Adds a string verbatim at the end of the Linux kernel command line.
.TP
.B root-dir
Specifies the name of the client root directory like the 
.B -d
or 
.B --root-dir
command line options.
.TP
.B ip-addrs
Specifies the Linux kernel IP address option like the 
.B -i
or 
.B --ip-addrs
command line options.
.TP
.B debug
Boolean value which specifies if the debugging version of the kernel 
loader should be used on the client or not.

.SH ENVIRONMENT VARIABLES
See the netboot(5) man page for a description of all environment
variables used by 
.BR mknbi-linux .

.SH BUGS
None known yet 

.SH SEE ALSO
netboot(5), netboot.config(5)

.SH AUTHOR
.B mknbi-linux
was written by 
.SM Gero Kuhlmann <gero@gkminix.han.de>.
Support for preloaded ramdisks and loading into extended memory has 
been added by 
.SM Markus Gutschke <gutschk@uni-muenster.de>.

