/*
 * mknbi.h  -  mknbi constants and type definitions
 *
 * Copyright (C) 1995-2007 Gero Kuhlmann   <gero@gkminix.han.de>
 * Copyright (C) 1996-2007 Gero Kuhlmann   <gero@gkminix.han.de>
 *                and Markus Gutschke <gutschk@math.uni-muenster.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mknbi.h,v 1.14 2007/01/06 18:31:26 gkminix Exp $
 */

#ifndef MKNBI_H_LINUX
#define MKNBI_H_LINUX


/*
 * Everything in this file has to be in packed structures.
 */
#include <common.h>
#define PACK_ENABLED
#ifdef USE_PRAGMA_PACK
#pragma pack(1)
#endif
#ifdef USE_PRAGMA_ALIGN
#pragma options align=packed
#endif



/*
 * Name of systems database section
 */
#define DBSECTNAME	"mknbi-linux"



/*
 * Load the primary boot loader definitions. This also loads the netboot
 * specification definitions.
 */
#include "first/first.i86"



/*
 * The RAM looks like this after the boot image has been loaded by the
 * Boot-ROM:
 *
 *  0x030000-0x0301FF   0.5kB   linux boot sector (aka INITSEG)
 *  0x030200-0x0341FF    16kB   linux kernel setup (aka SETUPSEG)
 *  0x034200-0x0349FF     2kB   default command line
 *  0x034A00-0x034BFF   0.5kB   load header
 *  0x034C00-0x038BFF    16kB   primary boot loader
 *  0x100000-0xxxxxxx     xkB   linux kernel (aka SYSSEG)
 *
 * Note that the kernel has to start at 0x100000, as the kernel decompression
 * routine depends on this.
 */
#define DEF_HEADERSEG	0x034A0L	/* boot header load segment */
#define DEF_SYSSEG	0x10000L	/* kernel load segment */

#define DEF_INITSEG	0x03000L	/* boot sector load segment */
#define INITLSIZE	512L		/* max load size of boot sector */
#define INITMSIZE	512L		/* max memory size of boot sector */

#define DEF_SETUPSEG	0x03020L	/* kernel setup load segment */
#define SETUPLSIZE	12288L		/* max load size of kernel setup */
#define SETUPMSIZE	16384L		/* max memory size of kernel setup */

#define DEF_CMDLSEG	0x03420L	/* command line load segment */
#define CMDLLSIZE	2048L		/* max load size of command line */
#define CMDLMSIZE	2048L		/* max memory size of command line */

#define DEF_BOOTLSEG	0x034C0L	/* primary loader load segment */
#define BOOTLLSIZE	8192L		/* max load size of primary loader */
#define BOOTLMSIZE	16384L		/* max memory size of primary loader */



/*
 * Default values for command line etc.
 */
#define BOOT_SIGNATURE	0xaa55			/* boot signature */
#define BOOT_SIG_OFF	510			/* boot signature offset */
#define BOOT_SETUP_SEGS	497			/* offset to setup sect num */

#define MAX_ADDR_SIZE	15			/* Max size of addr strings */

#define DFLT_CMDL	"auto rw"		/* Default kernel cmd line */
#define DFLT_IMAGE	"/vmlinuz"		/* Name of default krnl image */
#define DFLT_DIR	"kernel"		/* Name of default NFS dir */
#define DFLT_ADDRS	"kernel"		/* Default address resolution */
#define DFLT_DEV	"root=/dev/nfs"		/* root device for kernel */
#define INITRD_INIT	"/linuxrc"		/* Init prog whe using initrd */
#define KERNEL_ADDRS	"::::::any"		/* Default kernel addresses */



/*
 * Turnoff structure packing and return to normal data alignment.
 */
#ifdef USE_PRAGMA_PACK
#pragma pack()
#endif
#ifdef USE_PRAGMA_ALIGN
#pragma options align=reset
#endif
#undef PACK_ENABLED



/*
 * Definition of data area which contains command line parameters or
 * the parameters specified in a systems database entry.
 */
struct sysdef {
	char          *outname;		/* Name of output file */
	char          *rdname;		/* Name of ramdisk image file */
	char          *nfsdir;		/* Directory to mount as root via NFS */
	char          *kname;		/* Name of kernel image file */
	char          *append;		/* String to append to cmd line end */
	char          *addrs;		/* String with various IP addresses */
	int            vgamode;		/* VGA mode to set upon kernel start */
	int            rdmode;		/* Ramdisk mode */
	unsigned long  rdlocation;	/* Memory location of ramdisk image */
};



/*
 * External routines in the systems database module
 */
extern char *getrdmode __P((const char *rdmodestr, struct sysdef *sysentry));
extern char *getvgamode __P((const char *vgamodestr, struct sysdef *sysentry));
extern void getdb __P((const char *name, struct sysdef *sysentry));
extern void putdb __P((const char *name, struct sysdef *sysentry));



/*
 * Data area which contains the boot loader module
 */
extern __u8 first_data[];
extern unsigned int first_data_size;
extern __u8 firstd_data[];
extern unsigned int firstd_data_size;


#endif

