.\" @(#)mknbi-dos.8
.\"
.\" Copyright (C) 1996-2007 Gero Kuhlmann   <gero@gkminix.han.de>
.\"
.\"  This program is free software; you can redistribute it and/or modify
.\"  it under the terms of the GNU General Public License as published by
.\"  the Free Software Foundation; either version 2 of the License, or
.\"  any later version.
.\"
.\"  This program is distributed in the hope that it will be useful,
.\"  but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"  GNU General Public License for more details.
.\"
.\"  You should have received a copy of the GNU General Public License
.\"  along with this program; if not, write to the Free Software
.\"  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.\" $Id: mknbi.man,v 1.12 2007/01/06 18:31:22 gkminix Exp $
.TH MKNBI-DOS 8 "15 Nov 2002"
.SH NAME
mknbi-dos - MaKe NetBoot Image for DOS

.SH SYNOPSIS
.LP
.B mknbi-dos
[OPTIONS] [<ramdisk> [<output file>]]

.SH DESCRIPTION
.B mknbi-dos
is a program to convert a 
.SM DOS
boot disk image into a file which is directly loadable by diskless 
systems using a bootrom which is compliant with the 
.B netboot
specification. It supports various variants of DOS like MS-DOS\*R,
IBM-DOS (which has also been called PC-DOS\*R), PTS-DOS\*R,
OpenDOS\*R, NovellDOS\*R and FreeDOS.

.SH OPTIONS
.TP
.B -b, --batch-sys SYS
Lets 
.B mknbi-dos
operate in batch mode. It will look up the given system name in a
database and generate a netbootable image according to the 
parameters given in the database entry. If this option is not
given,
.B mknbi-dos
will operate according to the other command line options. If giving
any other options in addition to 
.B -b
or 
.BR --batch-sys ,
the parameters found in the database will override those processed from 
the command line.
.TP
.B -c, --simulate-hard-disk
Let the ram disk get mounted as a virtual hard disk instead of a 
floppy drive. Only floppy drives can be removed lateron, but a
hard disk image can have a user selectable size.
.TP
.B -C, --config-file FILE
Specifies the pathname of the configuration file. If this option is
not given, the value of the
.SM NETBOOT_CONFIG
environment variable or a compiled-in default will be used.
.TP
.B -D, --database FILE|DBSPEC
Pathname of database file (or database specification) to be used
together with the 
.B -b
or 
.B --batch-sys
options. If this option is not given, the value of the
.SM NETBOOT_DATABASE
environment variable or a compiled-in default will be used.
See the netboot(5) man page for a further explanation of
different ways to specify a database.
.TP
.B -F, --logfile
Name of log file to write debugging output to. The default is to
print all verbose output to stdout.
.TP
.B -h, --help
Print short usage information.
.TP
.B -H, --home-dir
Specifies the home directory. If this command line option is not
given, either the
.B homedir
configuration file parameter or the current user's home directory
will be used.
.TP
.B -i, --use-int-15
The bootrom loads the ramdisk into high memory. After DOS has started
the ramdisk contents has to be protected against getting overwritten.
To do this, the ramdisk driver tries to identify an XMS driver like
.SM HIMEM.SYS
once it has been loaded, and tell it the memory area used by
the ramdisk as being occupied. Unfortunately, sometimes this doesn't
work (the
.SM HIMEM.EXE
of FreeDOS is known to not work properly). In these
cases the ramdisk driver uses a different method of protecting the ramdisk 
contents called interrupt 15h protection.
.B mknbi-dos
tries to automatically identify those DOS versions which are known to 
not provide a properly working XMS driver. If this check doesn't work
correctly for your DOS version, or you are not loading an XMS driver
at all on the diskless client, you should use this option to protect the
ramdisk from getting overwritten by a program. However, when using this
option, the memory occupied by the ramdisk can't get reclaimed lateron
when the ramdisk is no longer needed. It then remains as unusable memory.
.TP
.B -k, --keep STRING
After the boot image got loaded the bootrom will disable all it's
services and pass control to the DOS loader. This option controls how
much of the bootrom PXE services interface will be removed before 
calling the loader.
.B STRING
can have the following values:
.RS
.TP
.B none
Don't keep anything in memory when DOS gets started. This is the default if
this option has not been given.
.TP
.B undi
Only keep the UNDI interface in memory and remove all base code, which is
responsible for all higher protocols like IP and UDP within the bootrom. With
this option, DOS can access the basic network adapter functions using the
UNDI interface as specified by the Preboot eXecution Environment (PXE)
specification.
.TP
.B all
Keep all parts of the bootrom in memory when starting DOS. This keeps the
base code in memory in addition to the UNDI interface. While it is possible
to use the UDP and TFTP functions according to the PXE specification, it
effectively prevents to run your own TCP/IP stack on top of the UNDI
interface.
.LP
This option will only have an effect with bootroms which support PXE. With
.B netboot
bootroms older than version 0.9, specifying anything different but
.B none
may give unpredictable results.
.RE
.TP
.B -l, --no-rpl
In order to allow DOS to access the ramdisk the primary boot loader 
has to permanently install a ramdisk driver before DOS gets started.
This driver has to get protected from getting overwritten. To protect
the driver, certain versions of MS-DOS\*R, PC-DOS\*R and OpenDOS\*R
use a mechanism called RPL protection, which allows reclaiming the
memory occupied by the ramdisk driver lateron when its no longer needed.
However, older DOS versions or some other DOS brands (like FreeDOS)
don't support this RPL protection.
.B mknbi-dos
tries to identify the DOS version correctly but this might not work 
with all different kinds of DOS. If your diskless client breaks after
starting DOS, you should try to use this option. The primary loader will
then use a different method of protecting the ramdisk driver.
.TP
.B -n, --no-hard-disk
When the ramdisk is simulating a floppy disk drive, this switch will
disable hard disk accesses. This is necessary if the client should
use a network file system as drive C:, which is only possible if there
are no hard disks found by DOS.
.TP
.B -N, --datadir DIR
Pathname of the shared-data directory. If this option is not given, the value
of the 
.SM NETBOOT_DATA
environment variable or a compiled-in default will be used.
.TP
.B -L, --libdir DIR
Pathname of the non-shared-data directory. If this option is not given, the
value of the 
.SM NETBOOT_LIB
environment variable or a compiled-in default will be used.
.TP
.B -o, --outfile FILE
Pathname of output file, which is lateron loaded by the
bootrom via TFTP.
.TP
.B -r, --ramdisk-image DIR | FILE
Pathname of ramdisk image. This can either be a file, a block
device or a directory. If the pathname is a file or block device,
it is treated as a bootable DOS ramdisk image, and the boot sector
defined in this image will be used. Otherwise, if the pathname is a
directory,
.B mknbi-dos
will treat all files in that directory as MS-DOS files and will create
a ramdisk image with a DOS filesystem and a simple boot sector 
in it. The directory has to contain at least the files
.SM IO.SYS,
.SM MSDOS.SYS
and 
.SM COMMAND.COM.
Alternatively, it can also contain the corresponding files for PC-DOS\*R,
OpenDOS\*R or FreeDOS.
.TP
.B -s, --ramdisk-size SIZE
Size of ramdisk in kB, which can not be smaller than that of the
ramdisk image. If this option is missing, then for a hard disk
simulation the default is to provide approximately 20% free
space within the ramdisk. For a ramdisk simulating a floppy the
size defaults to 1.44 MB. This option
can be used with or without the 
.B -c
option. However, when it is used without
.B -c
then the specified ramdisk size has to be one of 320, 360, 720, 1200,
1440 or 2880. Otherwise, any arbitrary ramdisk size can be selected
as long as it is large enough to hold the ramdisk contents.
.TP
.B -S, --save-sys SYSTEM
This option lets you save the parameters for a netboot image into the 
systems database using the name SYSTEM. Lateron, it is no longer
necessary to type all command line arguments to 
.B mknbi-linux
again, but you can use the
.B -b
or 
.B --batch-sys
option to generate a new netboot image.
.TP
.B -F, --single-fat
Normally the ramdisk will be built with two File Allocation Tables (FAT)
like with normal DOS disks. DOS uses two FATs in case one becomes
unreadable on the disk. Since the ramdisk can't fail two FATs are not
absolutely necessary so 
.B mknbi
can also create a filesystem with just one FAT using this command line 
option. This gives slightly more ramdisk space for user files.
.TP
.B -V, --volume-name STRING
Set the ramdisk volume name. The
.B STRING
argument should not exceed 
11 characters. When this option is not given, no volume name will
be set. Note that setting a volume name can cause problems on very
old MS-/PC-DOS versions. In order for some DOS tools (like Windows-9x)
to recognize the ramdisk the volume name should be set to 
.BR MS-RAMDRIVE .
.TP
.B -v, --version
Print version information.
.TP
.B -x, --verbose
Increase verbosity level.

.SH RAMDISK SIZE
The actual size of the ramdisk is determined by several parameters. When
the ramdisk is going to simulate a floppy drive, only the standard floppy
sizes are available:
.BR 320 ,
.BR 360 ,
.BR 720 ,
.BR 1200 ,
.B 1440
or 
.B 2880
kB. If the
.B -s
or 
.B --ramdisk-size
options are not used, the default ramdisk size will be 1440 kB.
.LP
When the ramdisk is going to simulate a hard drive by using the 
.B -c
or 
.B --simulate-hard-disk
switch, the default ramdisk size is determined so that the ramdisk
will have approximately 20% free space. If using the
.B -s
or 
.B --ramdisk-size
options the ramdisk size will be determined by the option argument.
It can have any value larger than 360 and is not restricted to the
standard floppy values mentioned above. The maximum value is 262144.

.SH MEMORY MANAGEMENT
The bootrom loads the image file created by 
.B mknbi-dos
so that the ramdisk image is placed at the start of the extended memory 
on the client. When DOS starts, this memory area is not protected in any
way against clobbering by client programs. But if the ramdisk driver finds
that a XMS driver like 
.SM HIMEM.SYS
gets loaded, it will use it to allocate a XMS memory block to protect the
ramdisk. Unfortunately,
.SM HIMEM.SYS,
starting with version 3.10, does a check of extended memory which destroys
the ramdisk image. You can use either a version of
.SM HIMEM.SYS
prior to 3.10, or use the command line option /TESTMEM:OFF.
.LP
When booting OpenDOS\*R you have to load
.SM HIMEM.SYS
before starting 
.SM EMM386.EXE
even though the documentation and the screen messages say that the 
.SM HIMEM.SYS
functionality is incorporated within 
.SM EMM386.EXE.
Unfortunately, when loading
.SM EMM386.EXE
alone the ramdisk image gets corrupted for some reason. This can only be
prevented when explicitly using 
.SM HIMEM.SYS
with OpenDOS\*R\0.
If you choose not to use an XMS driver, or when you don't
have a driver which works correctly (like
.SM HIMEM.EXE
provided by FreeDOS) you should use the
.B -i
or 
.B --use-int-15
command line option to protect the ramdisk contents.
.B mknbi-dos
tries to automatically determine when this interrupt 15h memory protection
should be used, but this test is not very reliable because there are so
many different versions and brands of DOS floating around.
.P
To remove a ramdisk you can use the program 
.B rmrd.com
which not only restores access to the physical drive which has been 
replaced by the ramdisk, but also frees all memory (including extended
memory) used by the ramdisk image. However, a ramdisk can only be
removed, if it is simulating a floppy disk drive (see option
.B -c
above). In a standard installation
.B rmrd.com
can be found in the directory /usr/local/share/netboot/misc.

.SH DOS RAMDISK DRIVER
When 
.B mknbi-dos
gets installed on the host system, an additional file
.B nbramdrv.sys
gets installed, usually into the directory /usr/local/share/netboot/misc.
This file contains a DOS ramdisk driver which replaces the ramdisk driver 
installed on the diskless client by the primary netboot loader. Note that
the file 
.B nbramdrv.sys
can only be executed on a DOS netboot client. You can copy it into the
ramdisk image of your diskless client, and modify the file
.B config.sys
to contain a line which looks like:
.RS
.TP
devicehigh=nbramdrv.sys /verbose
.RE
.P
It should appear 
.SM AFTER
calling the XMS driver. The effect will be that a ramdisk driver will be
installed into DOS which represents an ordinary DOS device driver, and
does not simulate a fake disk drive like the one installed by the primary 
netboot loader. After
.B nbramdrv.sys
has been loaded, the initial ramdisk driver will be removed from memory
(just like it's done with rmrd.com), but the ramdisk will remain accessible
using the same drive letter as before.
.P
Another way of operation is by giving the 
.B /newdrive
command line option to 
.BR nbramdrv.sys .
In this case 
.B nbramdrv.sys
does not remove the old ramdisk driver but will install the ramdisk as a 
new drive, for example drive C: (if no hard disk is installed) or drive D:
(with a one-DOS-partition hard disk installed). Since after calling
.B nbramdrv.sys
this way there are two ramdisk drivers installed (the old one and the new
one), in order to avoid problems the new drive will be automatically set to
read-only initially. Lateron you can remove the old driver with
.B rmrd.com
when it's no longer needed, and then the new ramdisk drive becomes writable.
.P
Without 
.B nbramdrv.sys
the ramdisk appears to DOS and any other program like a physical disk 
connected to a physical controller. Some programs like Windows therefore try
to directly access the controller to which the ramdisk is supposed to be 
connected to but will obviously fail.
.B nbramdrv.sys
makes the ramdisk appear as a logical drive without a physical controller 
which is a lot closer to reality.
.P
Note that after installing 
.B nbramdrv.sys
from the config.sys file there is no way of removing the ramdisk lateron.
When using the 
.B /newdrive
command line option the old ramdisk driver can be removed using rmrd.com
but in any case, once
.B nbramdrv.sys
has been loaded the newly installed driver can't be removed anymore.
.P
.B nbramdrv.sys
supports the following command line options:
.RS
.TP
.B /VERBOSE
Print out some more or less useful information.
.TP
.B /READONLY
Make the ramdisk readonly.
.TP
.B /NEWDRIVE
Install the ramdisk as a new drive instead of replacing the old initial 
ramdisk driver. When the old driver is no longer needed it should be
removed with the 
.B rmrd.com
command.
.TP
.B /SIMPLE
Only provide a smaller subset of device driver commands to DOS. This option
might be necessary for some DOS variants which can't cope with MS-DOS 7.x
extensions to the device driver interface.
.TP
.B /DHCP=[ON|OFF]
Save the DHCP/BOOTP information record provided by the bootrom into some
XMS memory. Presently there is no application available which can make use
of this information. The default is
.BR ON .
.RE

.SH DATABASE FILE
.B mknbi-dos
does not use any sections in the configuration file except the [general]
section. However, for easier maintenance of different client configurations
the database file can be used. The entries have to be preceded by a
[mknbi-dos:<system name>] tag and can contain the following parameters:
.TP
.B outfile
Specifies the name of the output file 
.TP
.B ramdisk-image
Specifies the name of the ramdisk image file or directory 
.TP
.B ramdisk-size
Specifies the size of the ramdisk. This parameter works like the
.B -s
or 
.B --ramdisk-size
command line arguments. The ramdisk size gets therefore determined in
the same way as described above.
.TP
.B no-hard-disk
Boolean parameter which specifies if to allow hard disk accesses in the 
client or not.
.TP
.B simulate-hd
This boolean parameter allows the ramdisk to simulate a hard disk in the 
client.
.TP
.B no-rpl
Boolean parameter which specifies to not use the RPL method of 
protecting the initial ramdisk driver, but use an alternative way.
.TP
.B use-int-15
This boolean parameter tells the diskless client to not use an XMS driver 
to protect the ramdisk contents.
.TP
.B single-fat
This boolean parameter specifies to install just one FAT into the ramdisk 
file system. Without this parameter or when it's value is FALSE two FATs
will be installed.
.TP
.B volume-name
Specifies the volume name of the ramdisk image. This name should not be
longer than 11 characters.
.TP
.B keep
Specifies which parts of the bootrom should be kept in memory when DOS 
gets started. It works exactly like the
.B -k
or 
.B --keep
command line options, and therefore has to have one of these values:
.BR none ,
.BR undi ,
.BR all .

.SH ENVIRONMENT VARIABLES
See the netboot(5) man page for a description of all environment
variables used by 
.BR mknbi-dos .

.SH TRADEMARKS
The names Windows\*R, MS-DOS\*R, PC-DOS\*R, PTS-DOS\*R, NovellDOS\*R,
OpenDOS\*R and DR-DOS\*R are registered trademarks of their respective
owners.

.SH BUGS
None known yet.

.SH SEE ALSO
netboot(5), netboot.config(5)

.SH AUTHOR
.B mknbi-dos
was written by 
.SM Gero Kuhlmann <gero@gkminix.han.de>.

