/*
 * mknbi.h  -  mknbi constants and type definitions for DOS loader
 *
 * Copyright (C) 1996-2007 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mknbi.h,v 1.15 2007/01/06 18:31:22 gkminix Exp $
 */

#ifndef MKNBI_H_DOS
#define MKNBI_H_DOS


/*
 * Everything in this file has to be in packed structures.
 */
#include <common.h>
#define PACK_ENABLED
#ifdef USE_PRAGMA_PACK
#pragma pack(1)
#endif
#ifdef USE_PRAGMA_ALIGN
#pragma options align=packed
#endif



/*
 * Name of systems database section
 */
#define DBSECTNAME	"mknbi-dos"



/*
 * Load the primary boot loader definitions. This also loads the netboot
 * specification definitions.
 */
#include "first/first.i86"



/*
 * The bootrom loads the load header to 0x40000, the primary boot
 * loader to 0x40400, and the ram disk image at the first address
 * above the HMA int extended memory.
 */
#define HEADERSEG	0x4000		/* segment for primary load header */
#define HEADERLSIZE	512L		/* maximum load size of load header */
#define HEADERMSIZE	512L		/* maximum memory size of load header */

#define LOADERSEG	0x4040		/* segment for primary boot loader */
#define LOADERLSIZE	64512L		/* maximum load size of boot loader */
#define LOADERMSIZE	64512L		/* maximum memory size of boot loader */

#define RDADDR		0x110000L	/* start of ext memory at top of HMA */



/*
 * Turnoff structure packing and return to normal data alignment.
 */
#ifdef USE_PRAGMA_PACK
#pragma pack()
#endif
#ifdef USE_PRAGMA_ALIGN
#pragma options align=reset
#endif
#undef PACK_ENABLED



/*
 * Values for keep command line option
 */
#define KEEP_MISSING	0
#define KEEP_NONE	1
#define KEEP_ALL	2
#define KEEP_UNDI	3



/*
 * Maximum length of volume name
 */
#define MAX_VOLNAME_LEN	11



/*
 * Definition of data area which contains command line parameters or
 * the parameters specified in a systems database entry.
 */
struct sysdef {
	char          *outname;		/* Name of output file */
	char          *rdname;		/* Name of ramdisk image file */
	char          *volumename;	/* Volume name of ramdisk FS */
	int            rdsize;		/* Size of ramdisk in kB */
	int            usehd;		/* Non-zero if ramdisk is hard disk */
	int            nohd;		/* Non-zero if hard disk disabled */
	int            norpl;		/* Non-zero if RPL mech. not allowed */
	int            useint15;	/* Non-zero if int 15h protection */
	int            singlefat;	/* Non-zero if only one FAT */
	int            compress;	/* Non-zero if ramdisk is compressed */
	int            keepflag;	/* Keep flag value for load header */
};



/*
 * Global routines
 */
extern char *getkeepflag __P((const char *keepstr, struct sysdef *sysentry));
extern void getdb __P((const char *name, struct sysdef *sysentry));
extern void putdb __P((const char *name, struct sysdef *sysentry));
extern int openrd __P((struct sysdef *sysentry,
					unsigned long *imgsize,
					struct disk_geometry *geom,
					int *loadflags));



/*
 * Data area which contains the boot loader module
 */
extern __u8 first_data[];
extern unsigned int first_data_size;

extern __u8 firstd_data[];
extern unsigned int firstd_data_size;



/*
 * Data area which contains the floppy boot sector
 */
extern __u8 boot_data[];
extern unsigned int boot_data_size;


#endif

