/*
 * rd.h  -  Definitions for compressed ramdisk images
 *
 * Copyright (C) 2005-2007 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: rd.h,v 1.5 2007/01/06 18:31:23 gkminix Exp $
 */

#ifndef HEADERS_RD_H
#define HEADERS_RD_H


/*
 * Check the compile system and turn structure packing on
 */
#include <compiler.h>
#include <pack.h>



/*
 * Size definitions
 *
 * LDRADDSIZE  - Size for decompression buffers which has to be added to the
 *               memory size of the loader image when the ramdisk has been
 *               compressed
 *
 * RDBLKSIZE   - Largest block size, which keeps the compressed data below
 *               64 kB even if the image data is completely incompressible,
 *               rounded down to the nearest 8 kB boundary
 *
 * RDMAXBLKNUM - Maximum number of blocks so that the full header still fits
 *               into a 64 kB block
 */
#define LDRADDSIZE	(2 * 65536L)		/* add. loader memory */
#define RDBLKSIZE	57344			/* uncompressed block size */
#define RDMAXBLKNUM	32760			/* max. number of blocks */
#define RDHDRSIG	"LZO1X"			/* header signature */
#define RDSIGLEN	6			/* length of header signature */

#if (RDBLKSIZE + 2 * RDOVERHEAD) >= 65536
# error Invalid compression size values
#endif



/*
 * Compressed ramdisk image header
 */
#ifndef _ASSEMBLY_

struct rdheader {
  __u8    sig[RDSIGLEN];		/* header signature */
  __u16   hdrsize;			/* total size of header */
  __u16   blknum;			/* number of blocks */
  __u16   blksize;			/* uncompressed block size */
  __u16   lastsize;			/* bytes in last block */
} PACKED;


#else

			.struct	0
rdheader_sig:		.struct	.+RDSIGLEN	/* header signature */
rdheader_hdrsize:	.struct	.+2		/* total size of header */
rdheader_blknum:	.struct	.+2		/* number of blocks */
rdheader_blksize:	.struct	.+2		/* uncompressed block size */
rdheader_lastsize:	.struct	.+2		/* bytes in last block */
rdheader_blklist:	.struct	.		/* compressed block sizes */


#endif



/*
 * Restore all definitions for data structure packing
 */
#include <unpack.h>

#endif

