/*
 * fat.h  -  Definitions for FAT filesystem
 *
 * Copyright (C) 2003-2007 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: fat.h,v 1.7 2007/01/06 18:31:23 gkminix Exp $
 */

#ifndef HEADERS_FAT_H
#define HEADERS_FAT_H


/*
 * Check the compile system and turn structure packing on
 */
#include <compiler.h>
#include <pack.h>



/*
 * FAT file system definitions
 */
#define SECTSIZE	512			/* size of one sector */
#define SECTS_PER_KB	(1024 / SECTSIZE)	/* number of sectors per kB */

#define MAX_CYLS	1024			/* max number of cylinders */
#define MAX_SECTS	63			/* max number of sectors */
#define MAX_HEADS	256			/* max number of heads */
#define MAX_DRIVES	26			/* max number of drives */
						/* max size of ram disk in kB */
#define MAX_RDSIZE	(MAX_CYLS * MAX_SECTS * MAX_HEADS / SECTS_PER_KB)
#define MIN_RDSIZE	360			/* min size of ram disk in kB */

#define FIRST_CLUSTER	2			/* first usable cluster number */



/*
 * Definitions for DOS directory entries
 */
#ifndef _ASSEMBLY_

struct dos_dir {
  __u8          name[8];		/* name of file */
  __u8          ext[3];			/* file extension */
  __u8          attrib;			/* file attributes */
  __u8          res[10];		/* reserved */
  __u16         time;			/* time of last access */
  __u16         date;			/* date of last access */
  __u16         cluster;		/* number of start cluster */
  struct i_long size;			/* size of file in bytes */
} PACKED;

struct lfn_dir {
  __u8          sequence;		/* record sequence number */
  __u16         first_part[5];		/* first unicode part */
  __u8          attrib;			/* file attribute */
  __u8          res;			/* reserved */
  __u8          checksum;		/* checksum of short name */
  __u16         second_part[6];		/* second unicode part */
  __u16         cluster;		/* number of start cluster */
  __u16         third_part[2];		/* third unicode part */
} PACKED;


#define ATTR_READONLY	0x01		/* read only file */
#define ATTR_HIDDEN	0x02		/* hidden file */
#define ATTR_SYSTEM	0x04		/* system file */
#define ATTR_LABEL	0x08		/* filesystem label */
#define ATTR_DIR	0x10		/* directory */
#define ATTR_LFN	0x0F		/* LFN directory entry */

#define LFN_CHARS	13		/* number of chars per LFN entry */

#define LFN_SEQ_MASK	0x3F		/* mask for LFN sequence number */
#define LFN_SEQ_END	0x40		/* bit mask for last LFN record */

#endif



/*
 * Restore all definitions for data structure packing
 */
#include <unpack.h>

#endif

