/*
 * dir.h  -  Definitions for storing the ramdisk directory tree
 *
 * Copyright (C) 2002-2007 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: dir.h,v 1.10 2007/01/06 18:31:21 gkminix Exp $
 */


/* Structure to hold file name information */
struct fname_struct {
	hchar_t              name[8];	/* file name */
	hchar_t              ext[3];	/* extension name */
	ucs_t               *lfn_name;	/* LFN file name (unicode) */
	int                  lfn_num;	/* number of LFN dir entries */
};


/* Union to hold information from the source directory */
union src_info {
	char                 path[1];	/* path name on host server */
	unsigned long        cluster;	/* start cluster in FAT image file */
};


/* Structure to hold file information from directory */
struct file_struct {
	struct fname_struct  name;	/* file name */
	char                 attrib;	/* attributes */
	unsigned int         time;	/* time of last access (DOS format) */
	unsigned int         date;	/* date of last access (DOS format) */
	unsigned int         cluster;	/* number of start cluster */
	unsigned int         clustnum;	/* number of clusters */
	unsigned long        size;	/* file size in bytes */
	struct file_struct  *next;	/* pointer to next file in dir */
	union src_info       src;	/* file source info */
};


/* Structure to hold information about subdirectories */
struct dir_struct {
	struct fname_struct  name;	/* file name */
	char                 attrib;	/* attributes */
	unsigned int         time;	/* time of last access (DOS format) */
	unsigned int         date;	/* date of last access (DOS format) */
	unsigned int         cluster;	/* number of start cluster */
	unsigned int         clustnum;	/* number of clusters */
	unsigned long        totsize;	/* total size of all files in kB */
	unsigned int         subdirnum;	/* number of subdirectories */
	unsigned int         filenum;	/* number of files in directory */
	unsigned int         lfnnum;	/* number of LFN directory entries */
	struct dir_struct   *subdirs;	/* pointer to first subdir */
	struct file_struct  *files;	/* pointer to first file */
	struct dir_struct   *next;	/* pointer to next dir in cur subdir */
	union src_info       src;	/* directory source info */
};


#define DIR_ENTRIES(dir)	((dir)->subdirnum + \
				 (dir)->filenum + \
				 (dir)->lfnnum + 2)


/* Structure to hold file system information */
struct fs_struct {
	struct dir_struct  *root_dir;		/* root directory */
	__u8               *boot_block;		/* boot block buffer */
	size_t              boot_size;		/* size of boot block */
	int                 loadflags;		/* ramdisk load flags */
};



/*
 * Global routines
 */

/* Routines in misc.c */
extern int cvtstr __P((hchar_t *hname, const char *str, int n));
extern int cmpname __P((struct fname_struct *namep,
						const char *name,
						const char *ext));
extern struct file_struct *findfile __P((struct dir_struct *dsp,
						int recursive,
						const hchar_t *name,
						const hchar_t *ext));
extern struct file_struct *findfname __P((struct dir_struct *dsp,
						int recursive,
						const char *fname,
						const char *fext));
extern void gettime __P((time_t mtime, unsigned int *date,
						unsigned int *time));


/* Routines in hostfs.c */
extern void hostopen __P((struct sysdef *sysentry, struct fs_struct *filesys));
extern void hostclose __P((struct fs_struct *filesys));
extern unsigned long hostcopy __P((int clustsize, int handle,
						const struct file_struct *fsp));


/* Routines in fatfs.c */
extern void fatopen __P((struct sysdef *sysentry, struct fs_struct *filesys));
extern void fatclose __P((struct fs_struct *filesys));
extern unsigned long fatcopy __P((int clustsize, int handle,
						const struct file_struct *fsp));

