#
# SQL script to create the netboot database needed for using
# the ODBC database driver
#
# $Id: odbc.sql,v 1.1 2006/10/11 20:31:39 gkminix Exp $
#

#
# Create database: 'netboot'
#
CREATE DATABASE IF NOT EXISTS `netboot`;


#
# Table: 'systems'
# 
CREATE TABLE IF NOT EXISTS `netboot`.`systems` (
  `id` int(10) unsigned NOT NULL default '0',
  `sysname` varchar(48) NOT NULL default '',
  `description` varchar(128) default '',
  PRIMARY KEY  (`id`)
) COMMENT='Table to map system ID to system name'; 



#
# Table: 'params'
# 
CREATE TABLE IF NOT EXISTS `netboot`.`params` (
  `id` int(11) NOT NULL auto_increment,
  `sysid` int(10) unsigned NOT NULL default '0',
  `name` varchar(32) NOT NULL default '',
  `type` smallint(5) unsigned zerofill NOT NULL default '00000',
  `strval` varchar(255) default '',
  `intval` int(11) default '0',
  `boolval` tinyint(1) default '0',
  PRIMARY KEY  (`sysid`,`id`)
) COMMENT='Table with parameters for each system'; 

