/*
 * makec.c  -  Create C file from binary image
 *
 * Copyright (C) 1996-2007 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: makec.c,v 1.10 2007/01/06 18:31:19 gkminix Exp $
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include <stdio.h>
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef STDC_HEADERS
# include <stdlib.h>
#endif

#ifndef STDIN_FILENO
# define STDIN_FILENO 0
#endif


int main(argc, argv)
int argc;
char **argv;
{
  int nr, pos;
  char arrayname[16], *argp;
  unsigned char buf[256];
  unsigned char *cp;

  if (argc < 2) {
	printf("Usage: %s [arrayname]", argv[0]);
	exit(1);
  }
  for (argp = argv[1], pos = 0; *argp && (pos < 15); argp++, pos++)
	arrayname[pos] = *argp;
  arrayname[pos] = '\0';

  printf("/* This file has been generated automatically by makec */\n");
  printf("/* DO NOT EDIT! */\n\n");
  printf("#include <common.h>\n");
  printf("__u8 %s_data[] = {\n", arrayname);
  pos = 0;
  while ((nr = read(STDIN_FILENO, buf, 256)) > 0) {
	cp = buf;
	for (; nr > 0; nr--) {
		printf("0x%02x,", *cp++);
		if (pos++ >= 12) {
			printf("\n");
			pos = 0;
		}
	}
  }
  printf("0};\n\n");
  printf("unsigned int %s_data_size = sizeof(%s_data) - 1;\n",
							arrayname, arrayname);
  return(0);
}
