/*
 * Linker script for DOS .COM files with common text and data
 * segments
 *
 * $Id: ldscript.com,v 1.4 2005/02/13 21:50:12 gkminix Exp $
 */
OUTPUT_FORMAT("binary")
OUTPUT_ARCH(i386)
SECTIONS
{
  . = 0x00000100;
  .text : AT(0x00000100)
  {
    *(.text)
    __text_end = .;
  }
  .data :
  {
    __data_start = .;
    *(.rodata*)
    *(.data)
    CONSTRUCTORS
    __data_end  =  .;
  }
  .bss :
  {
    __bss_start = .;
   *(.bss)
   *(COMMON)
   __bss_end = ALIGN(4);
  }
  PROVIDE(__file_size = SIZEOF(.text) + SIZEOF(.data));
  PROVIDE(__stack_size = 2048);
  PROVIDE(__heap_size = 0);
}

