/*
 * Linker script for boot sector files with common text and data
 * segments
 *
 * $Id: ldscript.boot,v 1.4 2005/02/13 21:50:12 gkminix Exp $
 */
OUTPUT_FORMAT("binary")
OUTPUT_ARCH(i386)
SECTIONS
{
  . = 0x00007C00;
  .text : AT(0x00007C00)
  {
    *(.text)
    __text_end = .;
  }
  .data :
  {
    __data_start = .;
    *(.rodata*)
    *(.data)
    CONSTRUCTORS
    __data_end  =  .;
  }
  .bss :
  {
    __bss_start = .;
   *(.bss)
   *(COMMON)
   __bss_end = ALIGN(4);
  }

  /* Align file size up to 512 bytes */
  . = 0x00007E00;
  PROVIDE(__file_size = . - LOADADDR(.text));
  PROVIDE(__stack_size = 0);
  PROVIDE(__heap_size = 0);
}

