/*
 * protini.h  -  Definitions for processing an NDIS protocol.ini file
 *
 * Copyright (C) 1998-2007 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: protini.h,v 1.11 2007/01/06 18:31:15 gkminix Exp $
 */

#ifndef PROTINI_H
#define PROTINI_H


/*
 **************************************************************************
 *
 *		Definitions for protocol.ini memory image layout
 *
 **************************************************************************
 */
#ifndef NO_BINARY

/*
 * Everything in this file has to be in packed structures.
 */
#ifdef USE_PRAGMA_PACK
#pragma pack(1)
#endif
#ifdef USE_PRAGMA_ALIGN
#pragma options align=packed
#endif



/*
 * Header for each module definition (bracketed section name)
 */
struct module_config {
  struct i_addr	next;			/* far ptr to next module */
  struct i_addr	prev;			/* far ptr to prev module */
  __u8		name[16];		/* module name */
} PACKED;

#define MODCONF_SIZE	24		/* size of module header */



/*
 * Header for each keyword entry (name in front of equal sign)
 */
struct keyword_entry {
  struct i_addr	next;			/* far ptr to next keyword */
  struct i_addr	prev;			/* far ptr to prev keyword */
  __u8		name[16];		/* name of keyword */
  __u16		numparams;		/* number of parameters */
} PACKED;

#define KEYWORD_SIZE	26		/* size of keyword header */



/*
 * Header for each parameter value
 */
struct param_struct {
  __u16		paramtype;		/* type of parameter */
  __u16		paramlen;		/* length of parameter value */
} PACKED;

#define PARAM_SIZE	4		/* size of parameter struct */

#define PARAM_NUM	0		/* numerical parameter value */
#define PARAM_STRING	1		/* string parameter value */



/*
 * Turnoff structure packing and return to normal data alignment.
 */
#ifdef USE_PRAGMA_PACK
#pragma pack()
#endif
#ifdef USE_PRAGMA_ALIGN
#pragma options align=reset
#endif

#endif			/* NO_BINARY */




/*
 **************************************************************************
 *
 *			External routines
 *
 **************************************************************************
 */
extern char *readprotini __P((const char *fname));
extern void parseprotini __P((const char *protini,
					__u8 **image, size_t *imglen));

#endif

