.\" @(#)makerom.8
.\"
.\" Copyright (C) 1997-2007 Gero Kuhlmann   <gero@gkminix.han.de>
.\"
.\"  This program is free software; you can redistribute it and/or modify
.\"  it under the terms of the GNU General Public License as published by
.\"  the Free Software Foundation; either version 2 of the License, or
.\"  any later version.
.\"
.\"  This program is distributed in the hope that it will be useful,
.\"  but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"  GNU General Public License for more details.
.\"
.\"  You should have received a copy of the GNU General Public License
.\"  along with this program; if not, write to the Free Software
.\"  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.\"  $Id: makerom.man,v 1.19 2007/02/01 12:09:22 gkminix Exp $
.TH MAKEROM 8 "15 Dec 2004"
.SH NAME
makerom - Make bootrom image

.SH SYNOPSIS
.LP
.B makerom
[OPTIONS]

.SH DESCRIPTION
.B makerom
generates a 
.B netboot
bootrom either interactively or in batch mode. It works by first concatenating
the bootrom kernel file with the network driver interface and the network 
driver (like packet or NDIS driver), then compressing the resulting image
and concatenating it with either the floppy or the rom loader stubs.

.SH OPTIONS
.TP
.B -b, --batch-sys SYS
Lets 
.B makerom
operate in batch mode.
It will look up the given system name in a 
database and generate a bootrom according to the specifications 
given in the database entry. If this option is not given,
.B makerom
will operate in interactive mode, asking the user about all required
parameters on the console.
.TP
.B -C, --config-file FILE
Specifies the pathname of the configuration file. If this option is not
given, the value of the
.SM NETBOOT_CONFIG
environment variable or a compiled-in default will be used.
.TP
.B -d, --drivers FILE
Specifies the pathname of the network driver information file. If this
option is not given, the name will be taken from the main configuration
file, or a compiled-in default will be used.
.TP
.B -D, --database FILE|DBSPEC
Pathname of database file (or database specification) to be used
together with the 
.B -b
or 
.B --batch-sys
options. If this option is not given, the value of the
.SM NETBOOT_DATABASE
environment variable or a compiled-in default will be used.
See the netboot(5) man page for a further explanation of database
specifications.
.TP
.B -F, --logfile
Name of log file to write debugging output to. The default is to
print all verbose output to stdout.
.TP
.B -h, --help
Print short usage information.
.TP
.B -H, --home-dir
Specifies the home directory. If this command line option is not
given, either the
.B homedir
configuration file parameter or the current user's home directory
will be used.
.TP
.B -m, --md5sums FILE
Specifies the path name of a file containing the MD5 checksums of the
currently installed network drivers (MD5 checksum database file).
.TP
.B -N, --datadir DIR
Specifies the directory where 
.B makerom
looks for the files required for generating a new bootrom. If this option
is not given, the value of the
.SM NETBOOT_DATA
environment variable or a compiled-in default will be used.
.TP
.B -L, --libdir DIR
This directory holds system-dependant data files for
.BR makerom .
The default value is either given by the 
.SM NETBOOT_LIB
environment variable or it is a compiled-in default.
.TP
.B -v, --version
Print version information.
.TP
.B -x, --verbose
Increase verbosity level.

.SH INTERACTIVE MODE
When no 
.B -b
or 
.B --batch-sys
option has been specified on the command line,
.B makerom
will operate in interactive mode. It will ask for all the
information necessary to build a bootrom for the target client.
Of course it will only ask those questions which are really 
required for proper operation of the bootrom.
Most questions have a list of allowed values given in round 
brackets. The default answer, which will be taken when you just
press enter, is printed in square brackets. Entering a question
mark will print a short help text.

.SH CONFIGURATION FILE
Besides the 
.B [general]
section 
.B makerom
also uses the 
.B [makerom:general]
section of the configuration file. It contains general definitions only
required by 
.BR makerom .
It can contain the following parameters:
.TP
.B driverdb
Specification of the network driver information database. If missing,
the default will be to read the text file 
.IR //netboot.drivers .
See netboot(5)
about how to setup a database specification.
.TP
.B md5sums
Pathname of the MD5 checksum database file. This file should contain the
MD5 checksums of all network drivers which are currently installed. The format
of this file is the same as produced by the GNU md5sum(1) program. If the
.B md5sums
option is missing, the default will be
.IR //netdrvr/MD5SUMS .
You can specify more than one file with this parameter. All file names
have to be seperated by a colon character.
.B makerom
will search all MD5 checksum files in sequence when checking for a
specific network driver file.
.TP
.B bindir
Specifies the directory where 
.B makerom
can find the bootrom kernel, network driver interface and rom loader binary
files. The default is
.IR //binaries .
.TP
.B netdrvdir
Specifies the directory where the network drivers can be found. All
non-absolute network driver pathnames are relative to the value of this
parameter. It's default value is
.IR //netdrvr .
.TP
.B utilsdir
This parameter specifies the directory where utility files (like the
packet driver debugger) can be found. If this parameter is missing, the
default 
.I //misc://utils
will be used.
.TP
.B kernel
Pathname of bootrom kernel file. The default is
.IR kernel.bin .
.TP
.B rom
Pathname of rom loader file. The default is
.IR rom.bin .
.TP
.B floppy
Pathname of floppy loader file. The default is
.IR floppy.bin .
.LP
If a file name specified in this section of the configuration file is 
not absolute, it will be treated as relative to the value of the binary
directory parameter. For example, if the
.B bindir
parameter has the value 
.IR //binaries ,
the main netboot directory is 
.I /usr/local/lib/netboot
and the 
.B kernel
parameter has the value 
.IR kernel.bin ,
then the resulting file name which 
.B makerom
will look up is 
.IR /usr/local/lib/netboot/binaries/kernel.bin .

.SH SYSTEMS DATABASE
The 
.B makerom
records in the systems database use 
.B [makerom:<system name>]
for the tag names. They can contain the following parameters:

.SS General bootrom parameters
.B makerom
can generate several output files in one run, all for the same client
but with different loaders. The following parameters are used for
every output file:
.TP
.B kernel
Specifies the name of the kernel file to be used. If the name starts with
two slashes these get replaced by the name of the general netboot directory.
This parameter is required.
.TP
.B bustype
Specifies the bus type of the network card on which the resulting bootrom 
should run. The allowed values for this parameter are
.BR ISA ,
.BR EISA ,
.B MCA
and 
.BR PCI .
If this parameter is not given,
.B ISA
will be assumed.
.TP
.B pcivendor
Specifies the PCI vendor ID used by the network card. This value can be
given as a decimal number or as a hexadecimal number if prefixed with "0x".
For example, Intel has the vendor ID "0x8086" assigned. This number will
also be used by other vendors if their network cards use an Intel chipset.
The 
.B pcivendor
parameter is required for PCI network cards.
.TP
.B pcidevice
Specifies the PCI device ID used by the network card. Like the PCI vendor
ID this value can be given as a decimal or hexadecimal number. For example,
the Intel EtherExpress Pro/10 PCI network card uses "0x1226" as it's ID.
This parameter is required for PCI network cards.
.TP
.B pnpdevid
Specifies the device ID for non-PCI network cards. This parameter is
required for ISA-PnP, EISA and MCA cards. It's value has to have a
total length of 7 characters, with the first 3 characters being upper
letters and the last 4 characters being hexadecimal digits. For example,
a Intel EtherExpress 16 ISA card has been assigned an ID of "PNP812D".
.B makerom
is not able to check that this ID is correct, or even required or
suitable for the bus type selected.
.TP
.B krnflags
These flags modify the behaviour of the bootrom kernel. The value to
this option is a string which consists of comma-seperated flag names.
If a flag name appears in the string, that corresponding flag is set.
The following flags are defined:
.RS
.TP
.B nouid
Prevents the bootrom to send a client UID. This might be necessary if
the booted operating system also does not send a client UID, or it sends
a different UID causing the bootrom and the operating system to receive 
different IP addresses from the DHCP server. This option has no effect
when a BOOTP server is in use instead of a DHCP server.
.TP
.B opts
Lets the bootrom send an option request list with a DHCP request.
.TP
.B nobpext
Prevents the bootrom to load a BOOTP extension file via TFTP. This flag
gets ignored with a DHCP server.
.RE
.TP
.B netdrvr
Specifies the pathname of the network driver interface file to be used. If
this pathname starts with two slashes, these slashes get replaced by the
name of the main netboot directory. Otherwise, if the pathname is not
absolute, it is taken to be relative to the binaries directory as
specified in the main configuration file. This parameter is required.
.TP
.B netdrvtype
Type of network driver interface that is supported by the interface file 
given with the 
.B netdrvr
parameter. The allowed values are
.BR packet\ driver ,
.B ndis\ driver
and 
.BR undi\ driver .
This parameter is required.
.TP
.B netdrvflags
This is an integer value which is passed as a flag word to the network 
driver interface. The meaning of the different flags depend on the type
of the network driver interface. Currently, only flags for the packet
driver interface are supported:
.RS
.TP
.B 0x0001
Skip the hardware reset of the network card. This is needed for some
buggy packet drivers which do not implement the hardware reset properly.
.TP
.B 0x0002
Do not use receive mode 0 of the packet driver. This receive mode
turns off the network card receiver. However, some buggy packet drivers
turn off the receiver permanently, and even turn off the transmit unit
permanently without the ability to turn them on again when needed. When
using this flag, mode 0 will never be used and will be simulated in
software instead of hardware.
.TP
.B 0x0004
Override the IRQ found by the bootrom network driver interface code with 
the IRQ number given through the system PCI configuration. This is only
necessary for some older PCI network cards for which the driver does not 
properly configure the interrupt setting.
.RE
.IP
The 
.B netdrvflags
parameter has to be computed by adding the relevant values mentioned 
above. Any other value for packet drivers and all values for any other
network driver interface are silently ignored.

.SS Bootrom loader parameters
With these parameters it is possible to specify up to three different 
output files for the same bootrom. For example, you can define output
files with different hex encoding, or one output file for burning into
a flash EPROM (using the rom loader), and another for writing onto a
floppy (using the floppy loader).
.TP
.B loaderX
Specifies the file names of all bootrom loaders.
.B makerom
will create a bootrom image file for each rom loader specified. The
.B X
in the variable name can be a number from 1 to 3. For each
.B loaderX
variable there has to be a corresponding 
.B outnameX
variable as well. Normal substition for the main netboot directory will occur.
.TP
.B outnameX
Specifies the names of the bootrom image files created with the rom loaders.
For each 
.B loaderX
parameter there has to be a corresponding 
.B outnameX
parameter.
.TP
.B outsizeX
This specifies the size of the output file 
.B outnameX
in kB.
Using this parameter, it is possible to write a smaller bootrom into a
much larger EPROM, for example to fill one EPROM with more than one
option rom image. If this parameter is missing, the size of a rom output
file will be determined so that it will fit into the smallest possible 
EPROM. It will be ignored for the floppy bootrom loader.
.TP
.B outtypeX
This is an enumeration parameter which specifies the format of the 
output file generated for each bootrom image given in 
.BR outnameX .
The following values are recognized:
.RS
.TP
.B binary
Raw binary for programming an EPROM 
.TP
.B intel hex
Bootrom image will be converted to Intel hex format for use with EPROM 
programmers which require this format.
.TP
.B motorola hex
Bootrom image will be converted to Motorola EXORmacs hex format for use 
with EPROM programmers which require this format.
.TP
.B tektronix hex
Bootrom image will be converted to Tektronix hex format for use 
with EPROM programmers which require this format.
.TP
.B bios
Raw binary for inclusion into a system BIOS. The
.B netboot
package currently doesn't provide any tools for actually including
the resulting output file into the BIOS. You have to use tools
provided by the manufacturer of your BIOS and/or system board
(for example
.I amibcp.exe
for an AMI BIOS, or the open source program
.I awardmod
for different Award BIOS versions).
.TP
.B flash
The bootrom image will be prepended by a special boot loader which allows 
it to be booted using a bootrom. It will then program a FlashCard or a
Flash EPROM on the network card with the new bootrom image. This method
can be used to easily update the bootrom in a diskless client without 
unmounting the cover. It doesn't make sense to use this output type
with the floppy boot loader.  Therefore, the
.B loaderX
parameter has to specify a rom loader when using the 
.B flash
output file type.
.B makerom
will not check for this condition.
.RE
.TP
.B ldoptsX
Specify options for 
.BR loaderX .
By default, all options are
.B false
unless explicitely specified with this parameter. All option names are
seperated by a comma and have to be given in all lower case. Their order
within the parameter argument string doesn't matter. The following options
are available:
.RS
.TP
.B useint18
If this option is given, the bootrom will use interrupt 18h for startup which
is the BASIC startup vector on old PC's. This interrupt gets called by the
BIOS when it can't find a bootable floppy or hard disk partition. If this
option is not given,
the bootrom will use interrupt 19h instead, which is the PC bootstrap
interrupt. In this case, the system will not seek any hard disks in the
system for a bootable partition (but will still check the first floppy
drive), and immediately start the netboot process.
.TP
.B nobbs
With this option it is possible to disable support for the BIOS Boot 
Specification (BBS) in the bootrom. Using BBS the BIOS is able to
determine the order of devices on which to search for an operating 
system. If the BIOS does not support BBS, the bootrom will automatically
disable BBS support. However, some BIOS do implement BBS support
incorrectly, and the bootrom is not able to determine such a situation.
In those cases this option can be used. Only select it if the bootrom
does not start up on reset. The default is to enable BBS support.
.TP
.B bootask
If this option is given,
the bootrom will ask the user if it should continue with the network boot 
process or not upon startup.
.TP
.B asktime
This option should be followed by an equal sign and a number between 0 and
31. It specifies the time the bootrom will wait for a user to press a key
when the 
.B bootask
option (see above) is specified. A value of 0 means to wait forever. It is
the default. If the
.B bootask
option is not given, the
.B asktime
option has no effect.
.TP
.B devnum
With this option it is possible to specify a certain network card if more 
than one card of the same type is installed in the client system. The
card numbers range from 1 to 7. If the value of this option is zero, the
bootrom will instead use that network card on which it is installed.
.RE

.SS Packet driver parameters
These parameters are only used with the packet driver interface.
.TP
.B pktdrvidx
Specifies the index number of the packet driver in the list of programs 
to load (see below).
.TP
.B progX
Specifies the file names of programs to be loaded by the bootrom, including
the packet driver. The
.B X
in the parameter name can be a number from 0 to 7. For each
.B progX
parameter there has to be a corresponding 
.B argsX
parameter as well. If the file name is not absolute it will be treated
as relative to the utilities directory except for the packet driver 
itself (identified by the
.B pktdrvidx
parameter), which is relative to the network driver directory.
.TP
.B argsX
Command line arguments for program 
.BR progX .
.TP
.B minsizeX
Specifies the run-time size of program
.B progX
in bytes.
.TP
.B maxsizeX
Specifies the load size of program 
.B progX
in bytes.

.SS NDIS driver parameters
These parameters are only used with the NDIS driver interface.
.TP
.B protini
Specifies the pathname of a protocol.ini file, which will be parsed by
.BR makerom .
The bootrom will later use the parsed protocol.ini file to simulate a
protocol manager to the NDIS driver. The protocol.ini file has to have
at least the entry for the NDIS driver used by the bootrom. This entry
has to have at least a 
.SM drivername
specification, which has to be set according to what the NDIS driver
expects. Typical protocol.ini files for your NDIS driver can usually
be found at the same place where you got your driver binary. For a further
explanation of the format of the protocol.ini file see the
.B netboot
documentation.
.TP
.B ndisdrvidx
Specifies the index number of the NDIS driver in the list of programs 
to load (see below).
.TP
.B progX
.TP
.B argsX
.TP
.B minsizeX
.TP
.B maxsizeX
These four parameters have the same meaning for the NDIS driver interface 
as for the packet driver interface mentioned above. However, an NDIS driver
is usually unable to accept a command line, so you should leave the
corresponding argsX option empty.

.SS UNDI driver parameters
These parameters are only used with the UNDI driver interface.
.TP
.B undiprog
Specifies the file name of the UNDI driver binary. If it's not absolute it
will be treated as relative to the directory specified by the 
.B netdrvr
parameter in the main configuration file.

.SS minsize and maxsize parameters
All DOS file specifications (those used with the packet and NDIS driver interfaces)
use minsize and maxsize parameters. With these parameters it is possible to
optimize the memory usage of the bootrom, especially when programs get loaded
in addition to the network driver binary. All these parameters are optional,
and if any of them is missing,
.B makerom
tries to find a suitable default value (which can sometimes be wrong).
.TP
.B minsize
This parameter specifies the run-time size of the program or network driver
in bytes. If a program terminates normally, it's
.B minsize
value is zero. Only if the program or driver stays resident in memory, the
.B minsize
value should be larger than zero. You can determine it by running the program
under plain DOS, and then inspect the memory usage using the "mem /c" command.
Add 1024 bytes for the PSP and for a safety margin to the number of bytes
printed by the mem command.
.TP
.B maxsize
This parameter specifies the number of bytes to allocate in order to be 
able to load the program or driver. For EXE type programs it should not be
necessary to specify this parameter since 
.B makerom
can determine their memory requirements by using the file header. However,
COM type programs are a bit more difficult. Usually it should be sufficient
to take the size of the program or driver binary file, and add some amount
of say 4096 bytes for PSP and stack in order to determine the
.B maxsize
parameter value. The actual amount of memory required might be different
due to different stack requirements, but 4096 is probably a good stack
size assumption. If this parameter is not given,
.B makerom
will assume a stacksize requirement of 1024 bytes by default. If this is
too small (for example your program or network driver crashes when getting
started by the bootrom), you have to use a larger
.B maxsize
parameter. Especially, when the COM type program has been compressed (for
example with PKLITE, a popular executable compressor) this assumption might
be wrong and a larger 
.B maxsize
value has to be used.
.LP
Since 
.B minsize
gives the runtime size of a network driver, it's value should only be
smaller than 
.B maxsize
if the driver really shrinks after getting loaded. Sometimes, a network
driver increases in size because it has to allocate some internal buffer 
memory. In this case,
.B minsize
should have the same value as 
.BR maxsize ,
and both should be large enough to hold the memory requirements of the 
network driver. Since 
.B makerom
is unable to detect such a condition, you should NOT let it assume default
values in this case, but specify the sizes correctly.
.LP
If 
.B makerom
is unable to automatically detect your network driver (for example
because you run it in batch mode, or the driver is not mentioned
in the network driver information database), you
should run your packet driver under plain DOS first in order to find 
out about it's memory requirements and necessary command line options.
If your network driver doesn't load under plain DOS, it will most likely
not load in a bootrom either.

.SH NETWORK DRIVER INFORMATION DATABASE
The Driver Information Database contains definitions for all 
network driver interface files. It also contains definitions for a large
number of different pre-known network drivers. However, it will only be
used in interactive mode. When using
.B makerom
in batch mode, you have to specify all necessary parameters within the
systems database using the record format mentioned above.
.LP
Also note that not all network 
drivers named in the database files distributed with 
.B netboot
are included in this package due to copyright reasons. In fact,
most of the drivers mentioned in the database are manufacturer provided 
network drivers, which can usually be found on the driver disks shipped
with a network card, or on the manufacturer
FTP or HTML server. For a listing of some network card
manufacturers see the netboot home page on 
.IR http://netboot.sourceforge.net .
It also contains direct links to some pages where you can find the latest 
drivers.

.SS Network driver interface file definitions
For each network card, the
.B netboot
bootrom does not only require a network driver, but also an interface
file for that driver. Currently, files are provided for the following
interfaces:
.IR packet\ driver ,
.I NDIS\ driver
and 
.IR UNDI\ driver .
For each 
interface a seperate section has to be specified in the database. The
sections are named 
.B [netdrv:<interface>]
with the interface name being one of 
.BR pktdrv ,
.B ndis
or 
.BR undi .
Note that like with all other configuration files these names have to 
be given in all lower case. Each section can have the following parameters:
.TP
.B description
This parameter specifies a description string for the interface. This
string will be printed in interactive mode, when more than one interface
is available for a certain network card.
.TP
.B filename
Specifies the name of the binary file for the interface. If this
file name is not absolute, it will be assumed to be relative to the
binary directory as specified in the main configuration file.
.TP
.B directory
Specifies the directory or colon seperated directories where network drivers 
can be found for the interface.
.TP
.B pattern
When printing a listing of the directories specified with the 
.B directory
parameter, only those files will be printed which match the given patterns.
All patterns in the value to this parameter have to be seperated by colons.
These patterns are like the simple command line patterns used by the shell,
instead of regular expressions. A star character serves as a wildcard.

.SS Network card descriptions
A network card description contains parameters which describe the hardware 
and are common for all drivers for a certain NIC. The section names are
constructed as 
.B [card:<nicname>]
where <nicname> specifies a unique name for a network card. If more than
one section with the same NIC name appears in the database, the information
is used which comes last.  A network card section can contain the
following parameters:
.TP
.B description
This parameter specifies a descriptive text for the network card. It will
be printed in interactive mode in the listing of supported network cards.
.TP
.B bustype
Specifies the host bus type of the network card. If a card gets manufactured
with different bus types, a seperate section with a distinct <nicname> has to
be written for each type. This parameter can have one of the following values:
.BR ISA ,
.BR EISA ,
.B MCA
and 
.BR PCI .
.TP
.B pcivendor
If this NIC is a PCI card, then this parameter specifies the PCI vendor
ID. It has to be a numerical value, and can be given in hex if prefixed
by "0x".
.TP
.B pcidevice
Specifies the PCI device ID. This parameter also has to be numerical.
.TP
.B pnpdevid
Specifies the PNP device ID, which is a string of 7 characters. The first
3 characters have to be upper case letters, and the last 4 characters have
to be hexadecimal digits. This parameter is required if the NIC is a
ISA/PnP, EISA or MCA card. However,
.B makerom
is not able to check if this parameter really is required or suitable for 
the card or bus type selected.
.TP
.B usedriver
If no network driver has been specified for this NIC, then it is possible
to use the network driver descriptions of a different NIC using this 
parameter. It specifies the <nicname> of that network card whose driver
descriptions should be used.

.SS Network driver descriptions
Following a network card description there can be one or more network 
driver description sections. Each such section has to have a name of
.B [driver:<nicname>]
with <nicname> being the same name as the one for the card description
it belongs 
to. It is allowed to specify more than one driver description for
a certain NIC.
Each driver description section can have the following parameters:
.TP
.B driverdesc
Specifies a descriptive string for the driver. This string will be printed
in interactive mode if more than one driver for a selected network card 
has been found.
.TP
.B drvtype
Specifies the interface type supported for this driver. This enumeration
parameter can have one of the following values:
.B packet
.BR driver ,
.B ndis driver
and 
.B undi
.BR driver .
.B makerom
will select the proper interface binary file according to this parameter.
.TP
.B file
File name of the network driver binary. If this file name is not absolute,
it will be looked up by using the search directory path specified in the 
interface description relevant for this network driver.
.TP
.B params
Specifies the hardware parameters which 
.B makerom
should ask the user about in interactive mode. This parameter is required
when wildcards are used with 
.B cmdline
and 
.B protini
as described below. All parameter values have to be seperated by commas.
The following values are known:
.RS
.TP
.B HW_IRQ
Hardware IRQ number 
.TP
.B IO_ADDR
I/O port address
.TP
.B BASE_MEM
Base memory segment for shared RAM 
.TP
.B AUI_TYPE
Type of network connector to be used 
.TP
.B DMA_NUM
DMA channel number 
.LP
Note that in contrast to all other enumeration values used with the netboot 
configuration files, these parameter values are all upper case.
.RE
.TP
.B cmdline
For packet drivers, a command line is required. This parameter specifies the
string to be used for it. This string can contain wildcards
for certain values:
.RS
.TP
.B %S, %s
Gets replaced by the default software packet driver interrupt number. This
number is fixed and can't be changed.
.TP
.B %H, %h
Gets replaced by the hardware interrupt number as entered by the user.
.B makerom
will only ask for a hardware interrupt number if the 
.B HW_IRQ
option has been given with the 
.B params
parameter.
.TP
.B %A, %a
Gets replaced by the I/O port address as entered by the user.
.B makerom
will only ask for a I/O port address if the 
.B IO_ADDR
option has been given with the 
.B params
parameter.
.TP
.B %M, %m
Gets replaced by the base memory segment as entered by the user.
.B makerom
will only ask for a base memory segment if the 
.B BASE_MEM
option has been given with the 
.B params
parameter.
.TP
.B %D, %d
Gets replaced by the DMA channel number as entered by the user.
.B makerom
will only ask for a DMA channel number if the 
.B DMA_NUM
option has been given with the 
.B params
parameter.
.TP
.B %t
Gets replaced by the AUI type number as entered by the user.
.B makerom
will only ask for a AUI type number if the 
.B AUI_TYPE
option has been given with the 
.B params
parameter.
.LP
Upper case wildcards get replaced by a hexadecimal number, while lower case
wildcards get replaced by a decimal number. All wildcards used within the
command line string (except the %S and %s wildcards which are fixed) have
to be specified with the 
.B params
parameter as described above. Otherwise, their value will not be asked
for in interactive mode, and the resulting command line will get
unpredictable substitutions.
.RE
.TP
.B protini
NDIS drivers require a so called protocol manager, which in turn reads a
.I protocol.ini
file. The
.B netboot
bootrom simulates this mechanism, but still requires the protocol.ini
file contents which is relevant for the NDIS driver. This parameter
can specify an actual file name.
.B makerom
then reads that file as a protocol.ini file. Of course it doesn't have to
be named protocol.ini but can have any name you like. Alternatively, the
.B protini
parameter can contain a string value which is treated as the contents of 
a protocol.ini file relevant for the NDIS driver. Since such a file contents
usually requires newlines, this string should best be enclosed in double
quotes. It can then be spread across multiple lines. All newlines between
the double quotes get copied into the string verbatim. A protocol.ini file
contents (either given as a string or by reading an actual protocol.ini
file) can use the same wildcards as a packet driver command line. See above
for a further explanation of these wildcards.
.TP
.B md5sum
Specifies the MD5 checksum of the network driver binary. Using this
paramater it is possible to specify different driver information 
records for different versions of a network driver. If the
.B md5sum
parameter is missing in a network driver record,
.B makerom
will use this record whenever it is unable to find the network 
driver file name in the MD5 checksum database file specified in the
configuration file or on the command line with the 
.B -m
command line option. However, if an MD5 checksum has been specified
for a network driver record with the 
.B md5sum
parameter, this record will only be used when the file name has been
found in the MD5 database file, and the checksum values in the MD5
database file and given with the 
.B md5sum
parameter are exactly the same.
.TP
.B minsize
Specifies the runtime size of the network driver in bytes. See above
for a further explanation of the 
.B minsize
parameter.
.TP
.B maxsize
Specifies the required number of bytes to load the driver into memory. See
above for a further explanation of the 
.B maxsize
parameter.
.TP
.B noreset
This is a boolean parameter which specifies if the packet driver 
interface is allowed to use the NIC hardware reset feature. The default
if this parameter is missing is 
.BR false .
This parameter is only necessary for very few packet drivers for which 
it is known that the hardware reset feature doesn't work correctly.
.TP
.B nomode0
Some buggy packet drivers do not correctly implement receive mode 0 to
turn off the network card receiver, so using this boolean parameter
allows to never use receive mode 0 when set to a value of
.BR true .
Instead this receive mode is simulated in software.

.SH COMPRESSED NETWORK DRIVERS
Some network drivers (especially packet drivers) have been compressed
by the 
manufacturer. They will decompress themselves when started. This
decompression requires a lot of memory. For EXE type programs, the
memory requirement should be encoded into the EXE file header. However,
for COM programs there is no such header.
.B makerom
tries to identify compressed programs. Currently, it only knows about
the 
.SM PKLITE
compressor. All other runtime compressors (like
.SM LZEXE
or 
.SM TINYPROG
for example) convert COM type programs into EXE files, which have the
above mentioned header. When
.B makerom
finds a compressed program it tries to find out how much memory will 
be required. Unfortunately, at least all
.SM PKLITE
versions I found have 
a bug in the compressor which results in an incorrect specification 
about how much memory is required for the decompression.
.B makerom
can only rudimentarily check for this condition, and will print a
warning in this case. It will then use a hopefully safe default.
Even when 
.B makerom
does not print this warning, the bootrom might fail on the compressed
executable.
Therefore, whenever you experience problems running the network driver
either in it's startup phase or during bootrom operation, you should
check if it has been compressed, and decompress it manually if
possible. Programs to do so can be found on many DOS software FTP
sites, like
.IR ftp.simtel.net .
It doesn't make sense to use compressed
executables anyway, since the final bootrom gets compressed by
.B makerom
also.

.SH PROTOCOL.INI FILES
NDIS drivers require a so called protocol manager which gets simulated 
by the NDIS interface binary. However, this simulator needs a protocol.ini
file like a real protocol manager.
.B makerom
parses this protocol.ini file and converts it into a format suitable for
the bootrom. The contents of this protocol.ini file has to follow the
same rules as layed out in the NDIS specification, published by Microsoft
and 3Com. In general, a protocol.ini file is divided into sections like
all netboot configuration files. Each section has to start with a name
enclosed in square brackets. Usually, the protocol.ini file used for
a bootrom only requires one section for the network driver. All other
sections usually found in a DOS protocol.ini file are not required and
just increase the size of the bootrom. Especially, it's not necessary
to specify a section for the protocol manager.
.B makerom
is presently unable to remove those unused sections, so you should not
specify them in the first place. Comments in a protocol.ini file are
preceded by a semicolon, and will be removed by
.B makerom
internally, so that they don't take up any space in the final bootrom.
.LP
Like all netboot configuration files, each section of a protocol.ini
file contains several parameters, with each parameter on a seperate
line. However, in contrast to the netboot configuration files a
protocol.ini file is parsed case-independently. All text in the file
gets converted to upper case. A NDIS driver section has to contain at
least the 
.B drivername
parameter, followed by an equal sign and the driver name required by
the NDIS driver. This name has to be exactly the one expected by the driver.
You can usually find it in the documentation of the network driver. It
commonly ends with a dollar sign. Other parameters might be necessary
depending on the driver. Common parameters include:
.BR iobase ,
.B ramaddress
and 
.BR irq .
It is also usually possible to define many other parameters for a 
network driver, like specifying the number of transmit or receive
buffers etc. Please note that when changing these numbers from within
a protocol.ini file, the memory requirement of a NDIS driver might
change and might require different minsize/maxsize values. For
a further description of any additional NDIS driver protocol.ini
parameters refer to the documentation which comes with your driver.

.SH FILES
For all files mentioned below the physical path might differ according 
to the configuration of 
.BR makerom .
See the netboot(5) man page for a further explanation of these files.
.TP
.I /usr/local/etc/netboot.config
Main netboot configuration file.
.TP
.I //netboot.drivers
Network driver information file, which contains information about
various network driver interfaces and network driver binaries.
.TP
.I //netdrvr/MD5SUMS
Network driver MD5 checksum database.
.TP
.I //netboot.db
Default database file for specifying system configurations.
.TP
.I //binaries/kernel.bin
Standard bootrom kernel 
.TP
.I //binaries/floppy.bin
Floppy bootrom loader 
.TP
.I //binaries/rom.bin
Bootrom loader 
.TP
.I //binaries/netpkt.bin
Packet driver interface file 
.TP
.I //binaries/netndis.bin
NDIS driver interface file 
.TP
.I //binaries/netundi.bin
UNDI driver interface file 
.TP
.I //utils/pktwatch.com
Packet driver debugger 
.TP
.I //netdrvr/pktdrvr/*
Packet driver executables 
.TP
.I //netdrvr/ndis/*
NDIS driver executables 
.TP
.I //netdrvr/undi/*
UNDI driver executables 

.SH ENVIRONMENT VARIABLES
See the netboot(5) man page for a description of all environment
variables used by 
.BR makerom .

.SH BUGS
None known yet.

.SH SEE ALSO
netboot(5), netboot.config(5), netboot.drivers(5)

.SH AUTHOR
.B makerom
was written by 
.SM Gero Kuhlmann <gero@gkminix.han.de>.

