/*
 * makeflash.h  -  Include file for generating a FlashCard boot image file
 *
 * Copyright (C) 1997-2007 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: makeflash.h,v 1.10 2007/01/06 18:31:14 gkminix Exp $
 */

#ifndef MAKEFLASH_H
#define MAKEFLASH_H


/*
 * Everything in this file has to be in packed structures.
 */
#include <common.h>
#define PACK_ENABLED
#ifdef USE_PRAGMA_PACK
#pragma pack(1)
#endif
#ifdef USE_PRAGMA_ALIGN
#pragma options align=packed
#endif



/*
 * Load the Flash EPROM programmer definitions. This also loads the netboot
 * specification definitions.
 */
#include "flash/flash.i86"



/*
 * The bootrom loads the load header to 0x30000, the Flash EPROM programmer
 * to 0x30400, and the boot rom image at 0x40000.
 */
#define HEADERSEG	0x3000		/* segment for primary load header */
#define HEADERLSIZE	512L		/* maximum load size of load header */
#define HEADERMSIZE	512L		/* maximum memory size of load header */

#define PROGRAMSEG	0x3040		/* segment for Flash EPROM programmer */
#define PROGRAMLSIZE	64512L		/* maximum load size of programer */
#define PROGRAMMSIZE	64512L		/* maximum memory size of programmer */

#define ROMIMAGESEG	0x4000		/* segment for boot rom image */
#define ROMIMAGEMADD	65536		/* addnl. memory size for rom image */
#define ROMIMAGEMAX	262144		/* maxmimum rom image memory size */



/*
 * Turnoff structure packing and return to normal data alignment.
 */
#ifdef USE_PRAGMA_PACK
#pragma pack()
#endif
#ifdef USE_PRAGMA_ALIGN
#pragma options align=reset
#endif
#undef PACK_ENABLED



/*
 * Data area which holds the FlashCard programming loader
 */
extern __u8 flash_data[];
extern unsigned int flash_data_size;


#endif

