/*
 * doconfig.h  -  include file for storing makerom configuration information
 *
 * Copyright (C) 1998-2007 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: doconfig.h,v 1.14 2007/01/06 18:31:12 gkminix Exp $
 */

#ifndef DOCONFIG_H
#define DOCONFIG_H


/*
 **************************************************************************
 *
 *	Definitions for storing network driver binary file information
 *
 **************************************************************************
 *
 * These structure definitions are used to store descriptive information
 * about the network driver binary files (like packet drivers etc.).
 */


/*
 * List of manufacturer names
 */
struct mandesc {
	char		*name;		/* name of manufacturer */
	struct mandesc	*next;		/* next entry */
};


/*
 * Network driver options. These options define which values to ask
 * the user about for a specific network driver.
 */
#define HW_IRQ		0x0001		/* query for hardware interrupt */
#define IO_ADDR		0x0002		/* query for I/O address */
#define BASE_MEM	0x0004		/* query for base memory address */
#define AUI_TYPE	0x0008		/* query for AUI type */
#define DMA_NUM		0x0010		/* query for DMA channel number */


/* Structure holding packet driver descriptions */
struct pddesc {
	int		 options;	/* packet driver options */
	char		*cmdline;	/* packet driver command line */
	long		 minsize;	/* minimum size in bytes */
	long		 maxsize;	/* maximum size in bytes */
};


/* Structure holding NDIS driver descriptions */
struct ndisdesc {
	int		 options;	/* NDIS driver options */
	char		*protini;	/* default protocol.ini file contents */
	long		 minsize;	/* minimum size in bytes */
	long		 maxsize;	/* maximum size in bytes */
};


/* Structure holding UNDI driver descriptions */
struct undidesc {
	int		 dummy;		/* UNDI driver has no further options */
};


/* Structure holding list of driver descriptions */
struct drvdesc {
	int		 type;		/* type of network driver */
	char		*descript;	/* description of network driver */
	char		*filename;	/* name and path of binary file */
	char		*basename;	/* base file name of binary file */
	char		*md5sum;	/* MD5 checksum of driver binary */
	int		 flags;		/* driver flags */
	union {
		struct pddesc   pd;	/* description for packet driver */
		struct ndisdesc ndis;	/* description for NDIS driver */
		struct undidesc undi;	/* description for UNDI driver */
	}		 drv;
	struct drvdesc	*next;
};


/* List of network driver binary file descriptions */
struct filedesc {
	char		*name;		/* name of file description */
	int		 bustype;	/* network card bus type */
	int		 pci_vendid;	/* PCI vendor ID */
	int		 pci_devid;	/* PCI device ID */
	char		*pnp_devid;	/* PnP product ID string */
	char		*usedriver;	/* driver cross reference */
	char		*description;	/* network card description */
	struct mandesc	*manufacturer;	/* name of manufacturer */
	struct drvdesc  *drvlist;	/* list of driver descriptions */
	struct drvdesc  *altdrvlist;	/* alternative list of drivers */
	struct filedesc	*next;		/* pointer to next structure */
};



/*
 **************************************************************************
 *
 *	Definitions for storing information about files required by makerom
 *
 **************************************************************************
 *
 * These structure definitions are used to store certain information
 * about the files required by makerom to generate bootroms.
 */

/* Structure holding information about network driver interface */
struct netdrvinfo {
	char *filename;			/* name of interface file */
	char *descript;			/* interface description */
	char *searchdir;		/* dirs to search through for binaries */
	char *patlist;			/* list of search patterns */
};

/* Number of info records required to hold all network driver interfaces */
#define NETDRV_NUM	(DRVTYPE_MIN + DRVTYPE_MAX)


/* Defines used to acces the file information */
#define FILE_KERNEL	0		/* standard bootrom kernel file */
#define FILE_ROM	1		/* rom loader file */
#define FILE_FLOPPY	2		/* floppy loader file */

#define FILE_NUMBER	3		/* number of file definitions */



/*
 **************************************************************************
 *
 *			Configuration information
 *
 **************************************************************************
 *
 * Structure holding all the information read from a makerom configuration
 * file.
 */
extern struct confstruct {
	char *bindir;				/* directory with binaries */
	char *netdrvdir;			/* directory with drivers */
	char *utilsdir;				/* utilities directory */
	char *drvdbname;			/* network driver defs */
	char *md5fname;				/* network driver MD5 sums */
	char *helpfile;				/* name of help file */
	char *instprog;				/* installation program */
	char *files[FILE_NUMBER];		/* filename array */
	struct netdrvinfo netdrv[NETDRV_NUM];	/* netdrv interface array */
	struct filedesc *drvdesc;		/* driver description list */
	struct mandesc *manlist;		/* list of manufacturer names */
} config;




/*
 **************************************************************************
 *
 *			External routines
 *
 **************************************************************************
 */
extern void doconfig __P((int argc, char **argv, struct cmdopt *opts));
extern void dodrvdb __P((void));

#endif

