/*
 * console.h  -  Include file for user interface routines
 *
 * Copyright (C) 1998-2007 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: console.h,v 1.11 2007/01/06 18:31:12 gkminix Exp $
 */

#ifndef CONSOLE_H
#define CONSOLE_H


/*
 * Structure to hold information for list printing
 */
struct listitem {
	voidstar	*desc;
	char		*descstr;
	char		*status;
	struct listitem	*next;
};



/*
 * External routines
 */
extern void initconsole __P((const char *helpname));
extern void closeconsole __P((void));
extern char *getstring __P((const char *prompt, int topic));
extern int getyn __P((const char *prompt, int def, int topic));
extern long getnum __P((const char *prompt, long min, long max,
					int hex, int topic));
extern int getsel __P((const char *prompt, int minsel, int maxsel,
					int defsel, int topic, int plines));
extern char *getfilename __P((const char *prompt, const char *searchdir,
					const char *pattern, int topic));
extern voidstar getlistsel __P((const char *header, const char *prompt,
					struct listitem *itemlist,
					struct listitem *defitem,
					int dosort, int topic));

#endif

